/*
 * CarouselMenu.java
 *
 * Created on January 12, 2007, 6:13 AM
 *
 * Copyright 2006-2007 Nigel Hughes 
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at http://www.apache.org/
 * licenses/LICENSE-2.0 Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR 
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language 
 * governing permissions and limitations under the License.
 */

package contrib.com.blogofbug.examples;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.net.URL;

import javax.swing.JOptionPane;

import contrib.com.blogofbug.swing.components.AbstractCarouselMenuAction;
import contrib.com.blogofbug.swing.components.JCarouselMenu;

/**
 *
 * @author  nigel
 */
public class CarouselMenu extends javax.swing.JFrame {
    
    /** Creates new form CarouselMenu */
    public CarouselMenu() {
        initComponents();
        this.setResizable(false);
        JCarouselMenu carousel = new JCarouselMenu();
        carousel.setBackground(Color.BLACK,new Color(0,0,1      ));
        this.getContentPane().setLayout(new BorderLayout());
        carousel.setPreferredSize(new Dimension(400,400));
        
        carousel.add(new ActionCarouselLayout(CaroselFinal.class.getResource("/contrib/com/blogofbug/examples/images/Carousel Layout.png"),"Carousel Layout"),256,256);
        carousel.add(new ActionCarouselComponent(CaroselFinal.class.getResource("/contrib/com/blogofbug/examples/images/Carousel Component.png"),"Carousel Component"),256,256);
        carousel.add(new ActionCarouselFinal(CaroselFinal.class.getResource("/contrib/com/blogofbug/examples/images/Full Carousel.png"),"Full Carousel Demo"),256,256);
        carousel.add(new ActionQuit(CaroselFinal.class.getResource("/contrib/com/blogofbug/examples/images/Quit.png"),"Quit"),256,256);
        carousel.setSelectedIndex(0);
        
        this.getContentPane().add(carousel,BorderLayout.CENTER);
        this.setSize(600,400);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("BlogOfBug Demo Library");
        pack();
    }// </editor-fold>//GEN-END:initComponents
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new CarouselMenu().setVisible(true);
            }
        });
    }
        
    public class ActionCarouselLayout extends AbstractCarouselMenuAction{
        public ActionCarouselLayout(URL image, String label){
            super(image,label);
        }
        public void actionPerformed(ActionEvent actionEvent) {
            new CaroselLayoutManager().setVisible(true);
        }    
    }
    
    public class ActionCarouselComponent extends AbstractCarouselMenuAction{
        public ActionCarouselComponent(URL image, String label){
            super(image,label);
        }
        public void actionPerformed(ActionEvent actionEvent) {
            new CaroselComponentExample().setVisible(true);
        }    
    }

    public class ActionCarouselFinal extends AbstractCarouselMenuAction{
        public ActionCarouselFinal(URL image, String label){
            super(image,label);
        }
        public void actionPerformed(ActionEvent actionEvent) {
            new CaroselFinal().setVisible(true);
        }    
    }
    
    public class ActionQuit extends AbstractCarouselMenuAction{
        public ActionQuit(URL image, String label){
            super(image,label);
        }
        public void actionPerformed(ActionEvent actionEvent) {
            if (JOptionPane.showConfirmDialog(null,"Are you sure you want to quit?","BlogOfBug",JOptionPane.QUESTION_MESSAGE,JOptionPane.YES_NO_OPTION)==JOptionPane.YES_OPTION){
                System.exit(0);
            }
        }    
    }    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables

    
}
