/*
 * mod.c
 * $Id: mod.c,v 1.7 2001/12/08 14:49:44 ttate Exp $
 */

#include "ruby.h"
#include "rbldap.h"

VALUE rb_cLDAP_Mod;


void
rb_ldap_mod_free(RB_LDAPMOD_DATA *data)
{
  if( data->mod ){
    struct berval **bvals;
    char **svals;
    int i;

    if( data->mod->mod_op & LDAP_MOD_BVALUES ){
      bvals =data->mod->mod_vals.modv_bvals;
      for( i=0; bvals[i] != NULL; i++ ){
	free(bvals[i]);
      };
      free(bvals);
    }
    else{
      svals = data->mod->mod_vals.modv_strvals;
      for( i=0; svals[i] != NULL; i++ ){
	free(svals[i]);
      };
      free(svals);
    };
    free(data->mod);
  };
};

VALUE
rb_ldap_mod_new(int mod_op, char *mod_type, char **modv_strvals)
{
  VALUE obj;
  LDAPMod *mod;
  RB_LDAPMOD_DATA *moddata;

  if( mod_op & LDAP_MOD_BVALUES ){
    rb_bug("rb_ldap_mod_new: illegal mod_op");
  };

  mod = (LDAPMod*)malloc(sizeof(LDAPMod));
  mod->mod_op = mod_op;
  mod->mod_type = mod_type;
  mod->mod_vals.modv_strvals = modv_strvals;
  obj = Data_Make_Struct(rb_cLDAP_Mod, RB_LDAPMOD_DATA,
			 0, rb_ldap_mod_free, moddata);
  moddata->mod = mod;

  return obj;
};

VALUE
rb_ldap_mod_new2(int mod_op, char *mod_type, struct berval **modv_bvals)
{
  VALUE obj;
  LDAPMod *mod;
  RB_LDAPMOD_DATA *moddata;

  if( !(mod_op & LDAP_MOD_BVALUES) ){
    rb_bug("rb_ldap_mod_new: illegal mod_op");
  };

  mod = (LDAPMod*)malloc(sizeof(LDAPMod));
  mod->mod_op = mod_op;
  mod->mod_type = mod_type;
  mod->mod_vals.modv_bvals = modv_bvals;
  obj = Data_Make_Struct(rb_cLDAP_Mod, RB_LDAPMOD_DATA,
			 0, rb_ldap_mod_free, moddata);
  moddata->mod = mod;

  return obj;
};

VALUE
rb_ldap_mod_s_new(VALUE self, VALUE op, VALUE type, VALUE vals)
{
  struct berval **bvals;
  char **strvals;
  int mod_op;
  char *mod_type;
  int i;
  VALUE ret_val;

  mod_op = NUM2INT(op);
  mod_type = STR2CSTR(type);
  Check_Type(vals, T_ARRAY);

  if( mod_op & LDAP_MOD_BVALUES ){
    bvals = (struct berval **)malloc(sizeof(struct berval *)
				     * ((RARRAY(vals)->len) + 1));
    for( i=0; i < RARRAY(vals)->len; i++ ){
      VALUE str;
      struct berval *bval;
      str = RARRAY(vals)->ptr[i];
      Check_Type(str, T_STRING);
      bval = (struct berval *)malloc(sizeof(struct berval));
      bval->bv_len = RSTRING(str)->len;
      bval->bv_val = STR2CSTR(str);
      bvals[i] = bval;
    };
    bvals[i] = NULL;
    ret_val = rb_ldap_mod_new2(mod_op, mod_type, bvals);
  }
  else{
    strvals = (char **)malloc(sizeof(char*) * ((RARRAY(vals)->len)+1));
    for( i=0; i < RARRAY(vals)->len; i++ ){
      VALUE str;
      char *sval;
      str = RARRAY(vals)->ptr[i];
      Check_Type(str, T_STRING);
      sval = STR2CSTR(str);
      strvals[i] = sval;
    };
    strvals[i] = NULL;
    ret_val = rb_ldap_mod_new(mod_op, mod_type, strvals);
  };

  return ret_val;
};

static VALUE
rb_ldap_mod_initialize(int argc, VALUE argv[], VALUE self)
{
  return Qnil;
};

VALUE
rb_ldap_mod_op(VALUE self)
{
  RB_LDAPMOD_DATA *moddata;

  GET_LDAPMOD_DATA(self, moddata);
  return INT2NUM(moddata->mod->mod_op);
};

VALUE
rb_ldap_mod_type(VALUE self)
{
  RB_LDAPMOD_DATA *moddata;

  GET_LDAPMOD_DATA(self, moddata);
  return rb_tainted_str_new2(moddata->mod->mod_type);
};

VALUE
rb_ldap_mod_vals(VALUE self)
{
  RB_LDAPMOD_DATA *moddata;
  struct berval **bvals;
  char **svals;
  int i;
  VALUE val;

  GET_LDAPMOD_DATA(self, moddata);

  if( moddata->mod->mod_op & LDAP_MOD_BVALUES ){
    bvals = moddata->mod->mod_vals.modv_bvals;
    val = rb_ary_new();
    for( i = 0; bvals[i] != NULL; i++ ){
      VALUE str;
      str = rb_tainted_str_new(bvals[i]->bv_val, bvals[i]->bv_len);
      rb_ary_push(val, str);
    };
  }
  else{
    svals = moddata->mod->mod_vals.modv_strvals;
    val = rb_ary_new();
    for( i = 0; svals[i] != NULL; i++ ){
      VALUE str;
      str = rb_tainted_str_new2(svals[i]);
      rb_ary_push(val, str);
    };
  };

  return val;
};

void
Init_ldap_mod(){
  rb_cLDAP_Mod = rb_define_class_under(rb_mLDAP,"Mod",rb_cObject);
  rb_define_singleton_method(rb_cLDAP_Mod, "new", rb_ldap_mod_s_new, 3);
  rb_ldap_mod_define_method("initialize", rb_ldap_mod_initialize, -1);
  rb_ldap_mod_define_method("mod_op", rb_ldap_mod_op, 0);
  rb_ldap_mod_define_method("mod_type", rb_ldap_mod_type, 0);
  rb_ldap_mod_define_method("mod_vals", rb_ldap_mod_vals, 0);

  /*
  rb_ldap_mod_define_method("mod_op=", rb_ldap_mod_set_op, 1);
  rb_ldap_mod_define_method("mod_type=", rb_ldap_mod_set_type, 1);
  rb_ldap_mod_define_method("mod_vals=", rb_ldap_mod_set_vals, 1);
  */
};
