# $Id: ruby-ldap.spec,v 1.4 2005/03/03 00:26:20 ianmacd Exp $

%define openldap %( rpm -q --qf '%%{version}' openldap | ruby -e 'puts gets.sub(/\\d+$/,"0")' )
# build documentation if we have rdoc on the build system
%define rdoc %( type rdoc > /dev/null && echo 1 || echo 0 )
Summary: LDAP API (RFC1823) library module for Ruby.
Name: ruby-ldap
Version: 0.9.0
Release: 1
License: Redistributable
Group: Applications/Ruby
Source: http://prdownloads.sourceforge.net/%{name}/%{name}-%{version}.tar.gz
URL: http://%{name}.sourceforge.net/
Packager: Ian Macdonald <ian@caliban.org>
BuildRoot: /var/tmp/%{name}-%{version}
BuildRequires: ruby, openssl-devel, openldap-devel >= %{openldap}
Requires: ruby, openssl, openldap >= %{openldap}

%description
Ruby/LDAP is an extension module for Ruby. It provides the interface to some
LDAP libraries (for example, OpenLDAP, UMich LDAP, Netscape SDK and
ActiveDirectory). The common API for application development is described in
RFC1823 and most libraries comply with it. Ruby/LDAP supports those libraries.

%prep
%setup

%build
ruby extconf.rb
make

%clean 
rm -rf $RPM_BUILD_ROOT

%install
rm -rf $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install
%if %{rdoc}
rdocpath=`ruby -rrdoc/ri/ri_paths -e 'puts RI::Paths::PATH[1]'`
rdoc -r -o $RPM_BUILD_ROOT$rdocpath -x CVS *.c lib/ldap
rm $RPM_BUILD_ROOT$rdocpath/created.rid
%endif
find $RPM_BUILD_ROOT -type f -print | \
  ruby -pe 'sub(%r(^'$RPM_BUILD_ROOT'), "")' > %{name}-%{version}-filelist
%if %{rdoc}
echo '%%docdir' $rdocpath >> %{name}-%{version}-filelist
%endif

%files -f %{name}-%{version}-filelist
%defattr(-,root,root)
%doc ChangeLog FAQ README* TODO
%doc example/ test/

%changelog
* Wed Mar  2 2005 Ian Macdonald <ian@caliban.org> 0.9.0-1
- 0.9.0
- There is a new, fully functional LDIF module, complete with unit tests.
- In LDAP::Conn#add, LDAP::Conn#add_ext, LDAP::Conn#modify and
  LDAP::Conn#modify_ext, LDAP_MOD_BVALUES should be set when passing in a
  hash, in case there are mods containing binary values.
- LDAP::Conn#sasl_bind now returns nil when a block is passed to it, not self.
- The LDAP module, as well as the LDAP::Conn, LDAP::SSLConn, LDAP::Entry,
  LDAP::Mod, LDAP::Control and LDAP::Schema classes, now have extensive
  RDoc documentation.

* Mon Feb  7 2005 Ian Macdonald <ian@caliban.org> 0.8.4-1
- 0.8.4
- All patches from 0.8.3-[3-9] merged upstream into 0.8.4.

* Mon Dec  6 2004 Ian Macdonald <ian@caliban.org> 0.8.3-9
- New accessor LDAP::Conn#sasl_quiet silences OpenLDAP SASL messages when
  set to true. It is false by default.

* Thu Nov 18 2004 Ian Macdonald <ian@caliban.org> 0.8.3-8
- Issue a warning if an attempt is made to set the LDAP protocol version
  after a bind has taken place.
- Implement LDAP::Conn#bound?

* Sat Nov 13 2004 Ian Macdonald <ian@caliban.org> 0.8.3-7
- Controls patch now returns controls from both LDAP::Conn#search and
  LDAP::Conn#search2.

* Fri Nov 12 2004 Ian Macdonald <ian@caliban.org> 0.8.3-6
- Further refinement of controls patch, so that controls are now returned
  as the @controls attribute of the connection object.
- New patch to provide more grammatical error message.

* Thu Nov 11 2004 Ian Macdonald <ian@caliban.org> 0.8.3-5
- Improve patch to allow controls to be duped or cloned.
- Add ldap/control.rb to extend the usefulness of controls.

* Tue Nov  9 2004 Ian Macdonald <ian@caliban.org> 0.8.3-4
- Patch to allow setting and retrieving of LDAP controls.

* Mon Nov  8 2004 Ian Macdonald <ian@caliban.org> 0.8.3-3
- Patch to fix setting of OID when LDAP controls are created.

* Sat Nov  6 2004 Ian Macdonald <ian@caliban.org> 0.8.3-2
- Build with specific OpenLDAP dependencies, as .so version changed in
  OpenLDAP 2.2.x.

* Wed Oct 20 2004 Ian Macdonald <ian@caliban.org> 0.8.3-1
- SASL GSSAPI patch removed, since it's been merged upstream.
- Patch incorrect library version.

* Sun Dec 14 2003 Ian Macdonald <ian@caliban.org> 0.8.2-4
- further refine saslconn.c patch

* Thu Dec 11 2003 Ian Macdonald <ian@caliban.org> 0.8.2-3
- further refine saslconn.c patch

* Thu Dec 11 2003 Ian Macdonald <ian@caliban.org> 0.8.2-2
- patch saslconn.c to allow GSSAPI via SASL

* Sun Dec  7 2003 Ian Macdonald <ian@caliban.org> 0.8.2-1
- 0.8.2

* Sun Oct 19 2003 Ian Macdonald <ian@caliban.org> 0.8.1-1
- 0.8.1

* Mon Mar 17 2003 Ian Macdonald <ian@caliban.org>
- 0.8.0

* Tue Jul 30 2002 Ian Macdonald <ian@caliban.org>
- 0.7.2

* Fri Jul 19 2002 Ian Macdonald <ian@caliban.org>
- 0.7.1

* Tue Jul  2 2002 Ian Macdonald <ian@caliban.org>
- add BuildRequires for openssl-devel and openldap-devel

* Sun Jun  2 2002 Ian Macdonald <ian@caliban.org>
- 0.7.0

* Mon Apr 29 2002 Ian Macdonald <ian@caliban.org>
- simplified install section

* Fri Apr  5 2002 Ian Macdonald <ian@caliban.org>
- added test directory to docs

* Tue Apr  2 2002 Ian Macdonald <ian@caliban.org>
- 0.6.1

* Wed Mar 13 2002 Ian Macdonald <ian@caliban.org>
- 0.6.0

* Mon Jan  7 2002 Ian Macdonald <ian@caliban.org>
- 0.5.0
