/**
 * ================================================
 * LibLoader : a free Java resource loading library
 * ================================================
 *
 * Project Info:  http://reporting.pentaho.org/libloader/
 *
 * (C) Copyright 2006-2008, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 *
 * ------------
 * ResourceManagerBackend.java
 * ------------
 */

package org.pentaho.reporting.libraries.resourceloader;

import java.net.URL;
import java.util.Map;

/**
 * Todo: Document Me
 *
 * @author Thomas Morgner
 */
public interface ResourceManagerBackend
{
  public ResourceKey createKey(final Object data, final Map parameters)
      throws ResourceKeyCreationException;

  public ResourceKey deriveKey(final ResourceKey parent, final String path, final Map parameters)
      throws ResourceKeyCreationException;

  public URL toURL(final ResourceKey key);

  public Resource create(final ResourceManager frontEnd, final ResourceData key, final ResourceKey context, final Class[] target)
      throws ResourceLoadingException, ResourceCreationException;

  public ResourceBundleData loadResourceBundle(final ResourceManager frontEnd, final ResourceKey key) throws ResourceLoadingException;

  public void registerDefaultFactories();
  public void registerDefaultLoaders();

  public void registerBundleLoader(final ResourceBundleLoader loader);
  public void registerLoader(final ResourceLoader loader);
  public void registerFactory(final ResourceFactory factory);
  
  public ResourceData loadRawData(final ResourceManager frontEnd, final ResourceKey key)
      throws ResourceLoadingException, UnrecognizedLoaderException;

  public boolean isResourceUnchanged(final ResourceManager resourceManager, final Resource resource) throws ResourceLoadingException;
}
