package Locales::DB::Language::nl_be;

# Auto generated from CLDR

$Locales::DB::Language::nl_be::VERSION = '0.06';

$Locales::DB::Language::nl_be::cldr_version = '1.7.2';

%Locales::DB::Language::nl_be::misc_info = (
    'cldr_formats' => {
        '_decimal_format_decimal' => "\,",
        '_decimal_format_group'   => "\.",
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'language'                => "Language\:\ \{0\}",
        'locale'                  => "\{0\}\ \(\{1\}\)",
        'percent'                 => "\#\,\#\#0\%",
        'territory'               => "Region\:\ \{0\}"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr'  => "no\:n",
        'yesstr' => "yes\:y"
    },
);

%Locales::DB::Language::nl_be::code_to_name = (
    'aa'    => 'Afar',
    'ab'    => 'Abchazisch',
    'ace'   => 'Atjees',
    'ach'   => 'Akoli',
    'ada'   => 'Adangme',
    'ady'   => 'Adyghe',
    'ae'    => 'Avestisch',
    'af'    => 'Afrikaans',
    'afa'   => "Afro\-Aziatische\ taal",
    'afh'   => 'Afrihili',
    'ain'   => 'Ainu',
    'ak'    => 'Akan',
    'akk'   => 'Akkadisch',
    'ale'   => 'Aleut',
    'alg'   => "Algonkium\-taal",
    'alt'   => "Zuid\-Altaïsch",
    'am'    => 'Amhaars',
    'an'    => 'Aragonees',
    'ang'   => 'Oudengels',
    'anp'   => 'Angika',
    'apa'   => "Apache\-taal",
    'ar'    => 'Arabisch',
    'arc'   => "klassiek\ Aramees",
    'arn'   => 'Araukaans',
    'arp'   => 'Arapaho',
    'art'   => "kunstmatige\ taal",
    'arw'   => 'Arawak',
    'as'    => 'Assamees',
    'ast'   => 'Asturisch',
    'ath'   => "Athapascaanse\ taal",
    'aus'   => "Australische\ taal",
    'av'    => 'Avarisch',
    'awa'   => 'Awadhi',
    'ay'    => 'Aymara',
    'az'    => 'Azerbeidzjaans',
    'ba'    => 'Basjkiers',
    'bad'   => 'Banda',
    'bai'   => "Bamiléké\-taal",
    'bal'   => 'Baloetsji',
    'ban'   => 'Balinees',
    'bas'   => 'Basa',
    'bat'   => "Baltische\ taal",
    'be'    => "Wit\-Russisch",
    'bej'   => 'Beja',
    'bem'   => 'Bemba',
    'ber'   => 'Berbertaal',
    'bg'    => 'Bulgaars',
    'bh'    => 'Bihari',
    'bho'   => 'Bhojpuri',
    'bi'    => 'Bislama',
    'bik'   => 'Bikol',
    'bin'   => 'Bini',
    'bla'   => 'Siksika',
    'bm'    => 'Bambara',
    'bn'    => 'Bengalees',
    'bnt'   => 'Bantoetaal',
    'bo'    => 'Tibetaans',
    'br'    => 'Bretons',
    'bra'   => 'Braj',
    'bs'    => 'Bosnisch',
    'btk'   => 'Batak',
    'bua'   => 'Buriat',
    'bug'   => 'Buginees',
    'byn'   => 'Blin',
    'ca'    => 'Catalaans',
    'cad'   => 'Caddo',
    'cai'   => "Midden\-Amerikaans\ Indiaanse\ taal",
    'car'   => 'Caribisch',
    'cau'   => "Kaukasische\ taal",
    'cch'   => 'Atsam',
    'ce'    => 'Chechen',
    'ceb'   => 'Cebuano',
    'cel'   => "Keltische\ taal",
    'ch'    => 'Chamorro',
    'chb'   => 'Chibcha',
    'chg'   => 'Chagatai',
    'chk'   => 'Chuukees',
    'chm'   => 'Mari',
    'chn'   => "Chinook\-jargon",
    'cho'   => 'Choctaw',
    'chp'   => 'Chipewyan',
    'chr'   => 'Cherokee',
    'chy'   => 'Cheyenne',
    'cmc'   => "Chamische\ taal",
    'co'    => 'Corsicaans',
    'cop'   => 'Koptisch',
    'cpe'   => "op\ Engels\ gebaseerd\ Creools\ of\ Pidgin",
    'cpf'   => "op\ Frans\ gebaseerd\ Creools\ of\ Pidgin",
    'cpp'   => "op\ Portugees\ gebaseerd\ Creools\ of\ Pidgin",
    'cr'    => 'Cree',
    'crh'   => "Krim\-Tataars",
    'crp'   => "Creools\ of\ Pidgin",
    'cs'    => 'Tsjechisch',
    'csb'   => 'Kasjoebisch',
    'cu'    => 'Kerkslavisch',
    'cus'   => "Koesjitische\ taal",
    'cv'    => 'Tsjoevasjisch',
    'cy'    => 'Welsh',
    'da'    => 'Deens',
    'dak'   => 'Dakota',
    'dar'   => 'Dargwa',
    'day'   => "Bidayuh\ taal",
    'de'    => 'Duits',
    'de_at' => "Oostenrijks\ Duits",
    'de_ch' => "Zwitsers\ Hoogduits",
    'del'   => 'Delaware',
    'den'   => 'Slavey',
    'dgr'   => 'Dogrib',
    'din'   => 'Dinka',
    'doi'   => 'Dogri',
    'dra'   => "Dravidische\ taal",
    'dsb'   => 'Nedersorbisch',
    'dua'   => 'Duala',
    'dum'   => 'Middelnederlands',
    'dv'    => 'Divehi',
    'dyu'   => 'Dyula',
    'dz'    => 'Dzongkha',
    'ee'    => 'Ewe',
    'efi'   => 'Efik',
    'egy'   => 'Oudegyptisch',
    'eka'   => 'Ekajuk',
    'el'    => 'Grieks',
    'elx'   => 'Elamitisch',
    'en'    => 'Engels',
    'en_au' => "Australisch\ Engels",
    'en_ca' => "Canadees\ Engels",
    'en_gb' => "Brits\ Engels",
    'en_us' => "Amerikaans\ Engels",
    'enm'   => 'Middelengels',
    'eo'    => 'Esperanto',
    'es'    => 'Spaans',
    'es_es' => "Iberisch\ Spaans",
    'et'    => 'Estlands',
    'eu'    => 'Baskisch',
    'ewo'   => 'Ewondo',
    'fa'    => 'Perzisch',
    'fan'   => 'Fang',
    'fat'   => 'Fanti',
    'ff'    => 'Fulah',
    'fi'    => 'Fins',
    'fil'   => 'Filipijns',
    'fiu'   => "Finoegrische\ taal",
    'fj'    => 'Fijisch',
    'fo'    => 'Faeröers',
    'fon'   => 'Fon',
    'fr'    => 'Frans',
    'fr_ca' => "Canadees\ Frans",
    'fr_ch' => "Zwitsers\ Frans",
    'frm'   => 'Middelfrans',
    'fro'   => 'Oudfrans',
    'frr'   => "Noord\-Fries",
    'frs'   => "Oost\-Fries",
    'fur'   => 'Friulisch',
    'fy'    => 'Fries',
    'ga'    => 'Iers',
    'gaa'   => 'Ga',
    'gay'   => 'Gayo',
    'gba'   => 'Gbaya',
    'gd'    => "Schots\-Gaelisch",
    'gem'   => "Germaanse\ taal",
    'gez'   => 'Geez',
    'gil'   => 'Gilbertees',
    'gl'    => 'Galicisch',
    'gmh'   => 'Middelhoogduits',
    'gn'    => 'Guarani',
    'goh'   => 'Oudhoogduits',
    'gon'   => 'Gondi',
    'gor'   => 'Gorontalo',
    'got'   => 'Gothisch',
    'grb'   => 'Grebo',
    'grc'   => 'Oudgrieks',
    'gsw'   => "Zwitsers\ Duits",
    'gu'    => 'Gujarati',
    'gv'    => 'Manx',
    'gwi'   => 'Gwichʼin',
    'ha'    => 'Hausa',
    'hai'   => 'Haida',
    'haw'   => 'Hawaïaans',
    'he'    => 'Hebreeuws',
    'hi'    => 'Hindi',
    'hil'   => 'Hiligaynon',
    'him'   => 'Himachali',
    'hit'   => 'Hettitisch',
    'hmn'   => 'Hmong',
    'ho'    => "Hiri\ Motu",
    'hr'    => 'Kroatisch',
    'hsb'   => 'Oppersorbisch',
    'ht'    => 'Haïtiaans',
    'hu'    => 'Hongaars',
    'hup'   => 'Hupa',
    'hy'    => 'Armeens',
    'hz'    => 'Herero',
    'ia'    => 'Interlingua',
    'iba'   => 'Iban',
    'id'    => 'Indonesisch',
    'ie'    => 'Interlingue',
    'ig'    => 'Igbo',
    'ii'    => "Sichuan\ Yi",
    'ijo'   => 'Ijo',
    'ik'    => 'Inupiaq',
    'ilo'   => 'Iloko',
    'inc'   => "Indische\ taal",
    'ine'   => "Indo\-Europese\ taal",
    'inh'   => 'Ingoesj',
    'io'    => 'Ido',
    'ira'   => "Iraanse\ taal",
    'iro'   => "Irokese\ taal",
    'is'    => 'IJslands',
    'it'    => 'Italiaans',
    'iu'    => 'Inuktitut',
    'ja'    => 'Japans',
    'jbo'   => 'Lojban',
    'jpr'   => "Judeo\-Perzisch",
    'jrb'   => "Judeo\-Arabisch",
    'jv'    => 'Javaans',
    'ka'    => 'Georgisch',
    'kaa'   => 'Karakalpaks',
    'kab'   => 'Kabyle',
    'kac'   => 'Kachin',
    'kaj'   => 'Jju',
    'kam'   => 'Kamba',
    'kar'   => 'Karen',
    'kaw'   => 'Kawi',
    'kbd'   => 'Kabardisch',
    'kcg'   => 'Tyap',
    'kfo'   => 'Koro',
    'kg'    => 'Kongo',
    'kha'   => 'Khasi',
    'khi'   => "Khoisan\-taal",
    'kho'   => 'Khotanees',
    'ki'    => 'Kikuyu',
    'kj'    => 'Kuanyama',
    'kk'    => 'Kazachs',
    'kl'    => 'Kalaallisut',
    'km'    => 'Khmer',
    'kmb'   => 'Kimbundu',
    'kn'    => 'Kannada',
    'ko'    => 'Koreaans',
    'kok'   => 'Konkani',
    'kos'   => 'Kosraeaans',
    'kpe'   => 'Kpelle',
    'kr'    => 'Kanuri',
    'krc'   => "Karachay\-Balkar",
    'krl'   => 'Karelisch',
    'kro'   => 'Kru',
    'kru'   => 'Kurukh',
    'ks'    => 'Kasjmiri',
    'ku'    => 'Koerdisch',
    'kum'   => 'Kumyk',
    'kut'   => 'Kutenai',
    'kv'    => 'Komi',
    'kw'    => 'Cornish',
    'ky'    => 'Kirgizisch',
    'la'    => 'Latijn',
    'lad'   => 'Ladino',
    'lah'   => 'Lahnda',
    'lam'   => 'Lamba',
    'lb'    => 'Luxemburgs',
    'lez'   => 'Lezgisch',
    'lg'    => 'Ganda',
    'li'    => 'Limburgs',
    'ln'    => 'Lingala',
    'lo'    => 'Laotiaans',
    'lol'   => 'Mongo',
    'loz'   => 'Lozi',
    'lt'    => 'Litouws',
    'lu'    => "Luba\-Katanga",
    'lua'   => "Luba\-Lulua",
    'lui'   => 'Luiseno',
    'lun'   => 'Lunda',
    'luo'   => 'Luo',
    'lus'   => 'Lushai',
    'lv'    => 'Lets',
    'mad'   => 'Madurees',
    'mag'   => 'Magahi',
    'mai'   => 'Maithili',
    'mak'   => 'Makassaars',
    'man'   => 'Mandingo',
    'map'   => "Austronesische\ taal",
    'mas'   => 'Masai',
    'mdf'   => 'Moksha',
    'mdr'   => 'Mandar',
    'men'   => 'Mende',
    'mfe'   => 'Morisyen',
    'mg'    => 'Malagasi',
    'mga'   => 'Middeliers',
    'mh'    => 'Marshallees',
    'mi'    => 'Maori',
    'mic'   => "Mi\'kmaq",
    'min'   => 'Minangkabau',
    'mis'   => "andere\ taal",
    'mk'    => 'Macedonisch',
    'mkh'   => "Mon\-Khmer\-taal",
    'ml'    => 'Malayalam',
    'mn'    => 'Mongools',
    'mnc'   => 'Mantsjoe',
    'mni'   => 'Manipoeri',
    'mno'   => "Manobo\-taal",
    'mo'    => 'Moldavisch',
    'moh'   => 'Mohawk',
    'mos'   => 'Mossi',
    'mr'    => 'Marathi',
    'ms'    => 'Maleis',
    'mt'    => 'Maltees',
    'mul'   => "meerdere\ talen",
    'mun'   => "Munda\-taal",
    'mus'   => 'Creek',
    'mwl'   => 'Mirandees',
    'mwr'   => 'Marwari',
    'my'    => 'Birmees',
    'myn'   => "Mayan\-taal",
    'myv'   => 'Erzya',
    'na'    => 'Nauru',
    'nah'   => 'Nahuatl',
    'nai'   => "Noord\-Amerikaans\ Indiaanse\ taal",
    'nap'   => 'Napolitaans',
    'nb'    => "Noors\ \-\ Bokmål",
    'nd'    => "Noord\-Ndbele",
    'nds'   => 'Laagduits',
    'ne'    => 'Nepalees',
    'new'   => 'Newari',
    'ng'    => 'Ndonga',
    'nia'   => 'Nias',
    'nic'   => "Niger\-Kordofanische\ taal",
    'niu'   => 'Niueaans',
    'nl'    => 'Nederlands',
    'nl_be' => 'Vlaams',
    'nn'    => 'Nieuwnoors',
    'no'    => 'Noors',
    'nog'   => 'Nogai',
    'non'   => 'Oudnoors',
    'nqo'   => 'N’ko',
    'nr'    => "Zuid\-Ndbele",
    'nso'   => "Noord\-Sotho",
    'nub'   => "Nubische\ taal",
    'nv'    => 'Navajo',
    'nwc'   => "Klassiek\ Newari",
    'ny'    => 'Nyanja',
    'nym'   => 'Nyamwezi',
    'nyn'   => 'Nyankole',
    'nyo'   => 'Nyoro',
    'nzi'   => 'Nzima',
    'oc'    => "Occitaans\ \(na\ 1500\)\;\ Provençaals",
    'oj'    => 'Ojibwa',
    'om'    => 'Oromo',
    'or'    => 'Oriya',
    'os'    => 'Ossetisch',
    'osa'   => 'Osage',
    'ota'   => "Ottomaans\-Turks",
    'oto'   => "Otomi\-taal",
    'pa'    => 'Punjabi',
    'paa'   => 'Papoeataal',
    'pag'   => 'Pangasinan',
    'pal'   => 'Pahlavi',
    'pam'   => 'Pampanga',
    'pap'   => 'Papiamento',
    'pau'   => 'Palauaans',
    'peo'   => 'Oudperzisch',
    'phi'   => "Filippijnse\ taal",
    'phn'   => 'Foenicisch',
    'pi'    => 'Pali',
    'pl'    => 'Pools',
    'pon'   => 'Pohnpeiaans',
    'pra'   => "Prakrit\-taal",
    'pro'   => 'Oudprovençaals',
    'ps'    => 'Pasjtoe',
    'pt'    => 'Portugees',
    'pt_br' => "Braziliaans\ Portugees",
    'pt_pt' => "Iberisch\ Portugees",
    'qu'    => 'Quechua',
    'raj'   => 'Rajasthani',
    'rap'   => 'Rapanui',
    'rar'   => 'Rarotongan',
    'rm'    => "Reto\-Romaans",
    'rn'    => 'Rundi',
    'ro'    => 'Roemeens',
    'roa'   => "Romaanse\ taal",
    'rom'   => 'Romani',
    'ru'    => 'Russisch',
    'rup'   => 'Aromaniaans',
    'rw'    => 'Kinyarwanda',
    'sa'    => 'Sanskriet',
    'sad'   => 'Sandawe',
    'sah'   => 'Yakut',
    'sai'   => "Zuid\-Amerikaans\ Indiaanse\ taal",
    'sal'   => "Salishan\-taal",
    'sam'   => "Samaritaans\-Aramees",
    'sas'   => 'Sasak',
    'sat'   => 'Santali',
    'sc'    => 'Sardinisch',
    'scn'   => 'Siciliaans',
    'sco'   => 'Schots',
    'sd'    => 'Sindhi',
    'se'    => "Noord\-Samisch",
    'sel'   => 'Selkup',
    'sem'   => "Semitische\ taal",
    'sg'    => 'Sango',
    'sga'   => 'Oudiers',
    'sgn'   => 'Gebarentaal',
    'sh'    => "Servo\-Kroatisch",
    'shn'   => 'Shan',
    'si'    => 'Singalees',
    'sid'   => 'Sidamo',
    'sio'   => "Siouaanse\ talen",
    'sit'   => "Sino\-Tibetaanse\ taal",
    'sk'    => 'Slowaaks',
    'sl'    => 'Sloveens',
    'sla'   => "Slavische\ taal",
    'sm'    => 'Samoaans',
    'sma'   => "Zuid\-Samisch",
    'smi'   => "Sami\-taal",
    'smj'   => "Lule\ Sami",
    'smn'   => "Inari\ Sami",
    'sms'   => "Skolt\ Sami",
    'sn'    => 'Shona',
    'snk'   => 'Soninke',
    'so'    => 'Somalisch',
    'sog'   => 'Sogdisch',
    'son'   => "Songhai\-taal",
    'sq'    => 'Albanees',
    'sr'    => 'Servisch',
    'srn'   => 'Sranantongo',
    'srr'   => 'Serer',
    'ss'    => 'Swazi',
    'ssa'   => "Nilo\-Saharaans",
    'st'    => "Zuid\-Sotho",
    'su'    => 'Soendanees',
    'suk'   => 'Sukuma',
    'sus'   => 'Soesoe',
    'sux'   => 'Soemerisch',
    'sv'    => 'Zweeds',
    'sw'    => 'Swahili',
    'syc'   => "klassiek\ Syrisch",
    'syr'   => 'Syriac',
    'ta'    => 'Tamil',
    'tai'   => "Tai\-taal",
    'te'    => 'Teloegoe',
    'tem'   => 'Timne',
    'ter'   => 'Tereno',
    'tet'   => 'Tetum',
    'tg'    => 'Tadzjieks',
    'th'    => 'Thai',
    'ti'    => 'Tigrinya',
    'tig'   => 'Tigre',
    'tiv'   => 'Tiv',
    'tk'    => 'Turkmeens',
    'tkl'   => 'Tokelau',
    'tl'    => 'Tagalog',
    'tlh'   => 'Klingon',
    'tli'   => 'Tlingit',
    'tmh'   => 'Tamashek',
    'tn'    => 'Tswana',
    'to'    => 'Tonga',
    'tog'   => "Nyasa\ Tonga",
    'tpi'   => "Tok\ Pisin",
    'tr'    => 'Turks',
    'trv'   => 'Taroko',
    'ts'    => 'Tsonga',
    'tsi'   => 'Tsimshian',
    'tt'    => 'Tataars',
    'tum'   => 'Toemboeka',
    'tup'   => "Tupi\-taal",
    'tut'   => "Altaïsche\ taal",
    'tvl'   => 'Tuvalu',
    'tw'    => 'Twi',
    'ty'    => 'Tahitisch',
    'tyv'   => 'Tuvinisch',
    'udm'   => 'Udmurt',
    'ug'    => 'Oeigoers',
    'uga'   => 'Oegaritisch',
    'uk'    => 'Oekraïens',
    'umb'   => 'Umbundu',
    'und'   => "onbepaalde\ taal",
    'ur'    => 'Urdu',
    'uz'    => 'Oezbeeks',
    'vai'   => 'Vai',
    've'    => 'Venda',
    'vi'    => 'Vietnamees',
    'vo'    => 'Volapük',
    'vot'   => 'Votisch',
    'wa'    => 'Wallonisch',
    'wak'   => "Wakashan\-taal",
    'wal'   => 'Walamo',
    'war'   => 'Waray',
    'was'   => 'Washo',
    'wen'   => "Sorbische\ taal",
    'wo'    => 'Wolof',
    'xal'   => 'Kalmyk',
    'xh'    => 'Xhosa',
    'yao'   => 'Yao',
    'yap'   => 'Yapees',
    'yi'    => 'Jiddisch',
    'yo'    => 'Yoruba',
    'ypk'   => "Yupik\-talen",
    'za'    => 'Zhuang',
    'zap'   => 'Zapotec',
    'zbl'   => 'Blissymbolen',
    'zen'   => 'Zenaga',
    'zh'    => 'Chinees',
    'znd'   => 'Zande',
    'zu'    => 'Zulu',
    'zun'   => 'Zuni',
    'zxx'   => "geen\ linguïstische\ inhoud",
    'zza'   => 'Zazaki',
);

%Locales::DB::Language::nl_be::name_to_code = (
    'abchazisch'                          => 'ab',
    'adangme'                             => 'ada',
    'adyghe'                              => 'ady',
    'afar'                                => 'aa',
    'afrihili'                            => 'afh',
    'afrikaans'                           => 'af',
    'afroaziatischetaal'                  => 'afa',
    'ainu'                                => 'ain',
    'akan'                                => 'ak',
    'akkadisch'                           => 'akk',
    'akoli'                               => 'ach',
    'albanees'                            => 'sq',
    'aleut'                               => 'ale',
    'algonkiumtaal'                       => 'alg',
    'altaïschetaal'                      => 'tut',
    'amerikaansengels'                    => 'en_us',
    'amhaars'                             => 'am',
    'anderetaal'                          => 'mis',
    'angika'                              => 'anp',
    'apachetaal'                          => 'apa',
    'arabisch'                            => 'ar',
    'aragonees'                           => 'an',
    'arapaho'                             => 'arp',
    'araukaans'                           => 'arn',
    'arawak'                              => 'arw',
    'armeens'                             => 'hy',
    'aromaniaans'                         => 'rup',
    'assamees'                            => 'as',
    'asturisch'                           => 'ast',
    'athapascaansetaal'                   => 'ath',
    'atjees'                              => 'ace',
    'atsam'                               => 'cch',
    'australischengels'                   => 'en_au',
    'australischetaal'                    => 'aus',
    'austronesischetaal'                  => 'map',
    'avarisch'                            => 'av',
    'avestisch'                           => 'ae',
    'awadhi'                              => 'awa',
    'aymara'                              => 'ay',
    'azerbeidzjaans'                      => 'az',
    'balinees'                            => 'ban',
    'baloetsji'                           => 'bal',
    'baltischetaal'                       => 'bat',
    'bambara'                             => 'bm',
    'bamilékétaal'                      => 'bai',
    'banda'                               => 'bad',
    'bantoetaal'                          => 'bnt',
    'basa'                                => 'bas',
    'basjkiers'                           => 'ba',
    'baskisch'                            => 'eu',
    'batak'                               => 'btk',
    'beja'                                => 'bej',
    'bemba'                               => 'bem',
    'bengalees'                           => 'bn',
    'berbertaal'                          => 'ber',
    'bhojpuri'                            => 'bho',
    'bidayuhtaal'                         => 'day',
    'bihari'                              => 'bh',
    'bikol'                               => 'bik',
    'bini'                                => 'bin',
    'birmees'                             => 'my',
    'bislama'                             => 'bi',
    'blin'                                => 'byn',
    'blissymbolen'                        => 'zbl',
    'bosnisch'                            => 'bs',
    'braj'                                => 'bra',
    'braziliaansportugees'                => 'pt_br',
    'bretons'                             => 'br',
    'britsengels'                         => 'en_gb',
    'buginees'                            => 'bug',
    'bulgaars'                            => 'bg',
    'buriat'                              => 'bua',
    'caddo'                               => 'cad',
    'canadeesengels'                      => 'en_ca',
    'canadeesfrans'                       => 'fr_ca',
    'caribisch'                           => 'car',
    'catalaans'                           => 'ca',
    'cebuano'                             => 'ceb',
    'chagatai'                            => 'chg',
    'chamischetaal'                       => 'cmc',
    'chamorro'                            => 'ch',
    'chechen'                             => 'ce',
    'cherokee'                            => 'chr',
    'cheyenne'                            => 'chy',
    'chibcha'                             => 'chb',
    'chinees'                             => 'zh',
    'chinookjargon'                       => 'chn',
    'chipewyan'                           => 'chp',
    'choctaw'                             => 'cho',
    'chuukees'                            => 'chk',
    'cornish'                             => 'kw',
    'corsicaans'                          => 'co',
    'cree'                                => 'cr',
    'creek'                               => 'mus',
    'creoolsofpidgin'                     => 'crp',
    'dakota'                              => 'dak',
    'dargwa'                              => 'dar',
    'deens'                               => 'da',
    'delaware'                            => 'del',
    'dinka'                               => 'din',
    'divehi'                              => 'dv',
    'dogri'                               => 'doi',
    'dogrib'                              => 'dgr',
    'dravidischetaal'                     => 'dra',
    'duala'                               => 'dua',
    'duits'                               => 'de',
    'dyula'                               => 'dyu',
    'dzongkha'                            => 'dz',
    'efik'                                => 'efi',
    'ekajuk'                              => 'eka',
    'elamitisch'                          => 'elx',
    'engels'                              => 'en',
    'erzya'                               => 'myv',
    'esperanto'                           => 'eo',
    'estlands'                            => 'et',
    'ewe'                                 => 'ee',
    'ewondo'                              => 'ewo',
    'faeröers'                           => 'fo',
    'fang'                                => 'fan',
    'fanti'                               => 'fat',
    'fijisch'                             => 'fj',
    'filipijns'                           => 'fil',
    'filippijnsetaal'                     => 'phi',
    'finoegrischetaal'                    => 'fiu',
    'fins'                                => 'fi',
    'foenicisch'                          => 'phn',
    'fon'                                 => 'fon',
    'frans'                               => 'fr',
    'fries'                               => 'fy',
    'friulisch'                           => 'fur',
    'fulah'                               => 'ff',
    'ga'                                  => 'gaa',
    'galicisch'                           => 'gl',
    'ganda'                               => 'lg',
    'gayo'                                => 'gay',
    'gbaya'                               => 'gba',
    'gebarentaal'                         => 'sgn',
    'geenlinguïstischeinhoud'            => 'zxx',
    'geez'                                => 'gez',
    'georgisch'                           => 'ka',
    'germaansetaal'                       => 'gem',
    'gilbertees'                          => 'gil',
    'gondi'                               => 'gon',
    'gorontalo'                           => 'gor',
    'gothisch'                            => 'got',
    'grebo'                               => 'grb',
    'grieks'                              => 'el',
    'guarani'                             => 'gn',
    'gujarati'                            => 'gu',
    'gwichʼin'                           => 'gwi',
    'haida'                               => 'hai',
    'hausa'                               => 'ha',
    'hawaïaans'                          => 'haw',
    'haïtiaans'                          => 'ht',
    'hebreeuws'                           => 'he',
    'herero'                              => 'hz',
    'hettitisch'                          => 'hit',
    'hiligaynon'                          => 'hil',
    'himachali'                           => 'him',
    'hindi'                               => 'hi',
    'hirimotu'                            => 'ho',
    'hmong'                               => 'hmn',
    'hongaars'                            => 'hu',
    'hupa'                                => 'hup',
    'iban'                                => 'iba',
    'iberischportugees'                   => 'pt_pt',
    'iberischspaans'                      => 'es_es',
    'ido'                                 => 'io',
    'iers'                                => 'ga',
    'igbo'                                => 'ig',
    'ijo'                                 => 'ijo',
    'ijslands'                            => 'is',
    'iloko'                               => 'ilo',
    'inarisami'                           => 'smn',
    'indischetaal'                        => 'inc',
    'indoeuropesetaal'                    => 'ine',
    'indonesisch'                         => 'id',
    'ingoesj'                             => 'inh',
    'interlingua'                         => 'ia',
    'interlingue'                         => 'ie',
    'inuktitut'                           => 'iu',
    'inupiaq'                             => 'ik',
    'iraansetaal'                         => 'ira',
    'irokesetaal'                         => 'iro',
    'italiaans'                           => 'it',
    'japans'                              => 'ja',
    'javaans'                             => 'jv',
    'jiddisch'                            => 'yi',
    'jju'                                 => 'kaj',
    'judeoarabisch'                       => 'jrb',
    'judeoperzisch'                       => 'jpr',
    'kabardisch'                          => 'kbd',
    'kabyle'                              => 'kab',
    'kachin'                              => 'kac',
    'kalaallisut'                         => 'kl',
    'kalmyk'                              => 'xal',
    'kamba'                               => 'kam',
    'kannada'                             => 'kn',
    'kanuri'                              => 'kr',
    'karachaybalkar'                      => 'krc',
    'karakalpaks'                         => 'kaa',
    'karelisch'                           => 'krl',
    'karen'                               => 'kar',
    'kasjmiri'                            => 'ks',
    'kasjoebisch'                         => 'csb',
    'kaukasischetaal'                     => 'cau',
    'kawi'                                => 'kaw',
    'kazachs'                             => 'kk',
    'keltischetaal'                       => 'cel',
    'kerkslavisch'                        => 'cu',
    'khasi'                               => 'kha',
    'khmer'                               => 'km',
    'khoisantaal'                         => 'khi',
    'khotanees'                           => 'kho',
    'kikuyu'                              => 'ki',
    'kimbundu'                            => 'kmb',
    'kinyarwanda'                         => 'rw',
    'kirgizisch'                          => 'ky',
    'klassiekaramees'                     => 'arc',
    'klassieknewari'                      => 'nwc',
    'klassieksyrisch'                     => 'syc',
    'klingon'                             => 'tlh',
    'koerdisch'                           => 'ku',
    'koesjitischetaal'                    => 'cus',
    'komi'                                => 'kv',
    'kongo'                               => 'kg',
    'konkani'                             => 'kok',
    'koptisch'                            => 'cop',
    'koreaans'                            => 'ko',
    'koro'                                => 'kfo',
    'kosraeaans'                          => 'kos',
    'kpelle'                              => 'kpe',
    'krimtataars'                         => 'crh',
    'kroatisch'                           => 'hr',
    'kru'                                 => 'kro',
    'kuanyama'                            => 'kj',
    'kumyk'                               => 'kum',
    'kunstmatigetaal'                     => 'art',
    'kurukh'                              => 'kru',
    'kutenai'                             => 'kut',
    'laagduits'                           => 'nds',
    'ladino'                              => 'lad',
    'lahnda'                              => 'lah',
    'lamba'                               => 'lam',
    'laotiaans'                           => 'lo',
    'latijn'                              => 'la',
    'lets'                                => 'lv',
    'lezgisch'                            => 'lez',
    'limburgs'                            => 'li',
    'lingala'                             => 'ln',
    'litouws'                             => 'lt',
    'lojban'                              => 'jbo',
    'lozi'                                => 'loz',
    'lubakatanga'                         => 'lu',
    'lubalulua'                           => 'lua',
    'luiseno'                             => 'lui',
    'lulesami'                            => 'smj',
    'lunda'                               => 'lun',
    'luo'                                 => 'luo',
    'lushai'                              => 'lus',
    'luxemburgs'                          => 'lb',
    'macedonisch'                         => 'mk',
    'madurees'                            => 'mad',
    'magahi'                              => 'mag',
    'maithili'                            => 'mai',
    'makassaars'                          => 'mak',
    'malagasi'                            => 'mg',
    'malayalam'                           => 'ml',
    'maleis'                              => 'ms',
    'maltees'                             => 'mt',
    'mandar'                              => 'mdr',
    'mandingo'                            => 'man',
    'manipoeri'                           => 'mni',
    'manobotaal'                          => 'mno',
    'mantsjoe'                            => 'mnc',
    'manx'                                => 'gv',
    'maori'                               => 'mi',
    'marathi'                             => 'mr',
    'mari'                                => 'chm',
    'marshallees'                         => 'mh',
    'marwari'                             => 'mwr',
    'masai'                               => 'mas',
    'mayantaal'                           => 'myn',
    'meerderetalen'                       => 'mul',
    'mende'                               => 'men',
    'middelengels'                        => 'enm',
    'middelfrans'                         => 'frm',
    'middelhoogduits'                     => 'gmh',
    'middeliers'                          => 'mga',
    'middelnederlands'                    => 'dum',
    'middenamerikaansindiaansetaal'       => 'cai',
    'mikmaq'                              => 'mic',
    'minangkabau'                         => 'min',
    'mirandees'                           => 'mwl',
    'mohawk'                              => 'moh',
    'moksha'                              => 'mdf',
    'moldavisch'                          => 'mo',
    'mongo'                               => 'lol',
    'mongools'                            => 'mn',
    'monkhmertaal'                        => 'mkh',
    'morisyen'                            => 'mfe',
    'mossi'                               => 'mos',
    'mundataal'                           => 'mun',
    'nahuatl'                             => 'nah',
    'napolitaans'                         => 'nap',
    'nauru'                               => 'na',
    'navajo'                              => 'nv',
    'ndonga'                              => 'ng',
    'nederlands'                          => 'nl',
    'nedersorbisch'                       => 'dsb',
    'nepalees'                            => 'ne',
    'newari'                              => 'new',
    'nias'                                => 'nia',
    'nieuwnoors'                          => 'nn',
    'nigerkordofanischetaal'              => 'nic',
    'nilosaharaans'                       => 'ssa',
    'niueaans'                            => 'niu',
    'nogai'                               => 'nog',
    'noordamerikaansindiaansetaal'        => 'nai',
    'noordfries'                          => 'frr',
    'noordndbele'                         => 'nd',
    'noordsamisch'                        => 'se',
    'noordsotho'                          => 'nso',
    'noors'                               => 'no',
    'noorsbokmål'                        => 'nb',
    'nubischetaal'                        => 'nub',
    'nyamwezi'                            => 'nym',
    'nyanja'                              => 'ny',
    'nyankole'                            => 'nyn',
    'nyasatonga'                          => 'tog',
    'nyoro'                               => 'nyo',
    'nzima'                               => 'nzi',
    'n’ko'                              => 'nqo',
    "occitaansna1500\;provençaals"       => 'oc',
    'oegaritisch'                         => 'uga',
    'oeigoers'                            => 'ug',
    'oekraïens'                          => 'uk',
    'oezbeeks'                            => 'uz',
    'ojibwa'                              => 'oj',
    'onbepaaldetaal'                      => 'und',
    'oostenrijksduits'                    => 'de_at',
    'oostfries'                           => 'frs',
    'opengelsgebaseerdcreoolsofpidgin'    => 'cpe',
    'opfransgebaseerdcreoolsofpidgin'     => 'cpf',
    'oppersorbisch'                       => 'hsb',
    'opportugeesgebaseerdcreoolsofpidgin' => 'cpp',
    'oriya'                               => 'or',
    'oromo'                               => 'om',
    'osage'                               => 'osa',
    'ossetisch'                           => 'os',
    'otomitaal'                           => 'oto',
    'ottomaansturks'                      => 'ota',
    'oudegyptisch'                        => 'egy',
    'oudengels'                           => 'ang',
    'oudfrans'                            => 'fro',
    'oudgrieks'                           => 'grc',
    'oudhoogduits'                        => 'goh',
    'oudiers'                             => 'sga',
    'oudnoors'                            => 'non',
    'oudperzisch'                         => 'peo',
    'oudprovençaals'                     => 'pro',
    'pahlavi'                             => 'pal',
    'palauaans'                           => 'pau',
    'pali'                                => 'pi',
    'pampanga'                            => 'pam',
    'pangasinan'                          => 'pag',
    'papiamento'                          => 'pap',
    'papoeataal'                          => 'paa',
    'pasjtoe'                             => 'ps',
    'perzisch'                            => 'fa',
    'pohnpeiaans'                         => 'pon',
    'pools'                               => 'pl',
    'portugees'                           => 'pt',
    'prakrittaal'                         => 'pra',
    'punjabi'                             => 'pa',
    'quechua'                             => 'qu',
    'rajasthani'                          => 'raj',
    'rapanui'                             => 'rap',
    'rarotongan'                          => 'rar',
    'retoromaans'                         => 'rm',
    'roemeens'                            => 'ro',
    'romaansetaal'                        => 'roa',
    'romani'                              => 'rom',
    'rundi'                               => 'rn',
    'russisch'                            => 'ru',
    'salishantaal'                        => 'sal',
    'samaritaansaramees'                  => 'sam',
    'samitaal'                            => 'smi',
    'samoaans'                            => 'sm',
    'sandawe'                             => 'sad',
    'sango'                               => 'sg',
    'sanskriet'                           => 'sa',
    'santali'                             => 'sat',
    'sardinisch'                          => 'sc',
    'sasak'                               => 'sas',
    'schots'                              => 'sco',
    'schotsgaelisch'                      => 'gd',
    'selkup'                              => 'sel',
    'semitischetaal'                      => 'sem',
    'serer'                               => 'srr',
    'servisch'                            => 'sr',
    'servokroatisch'                      => 'sh',
    'shan'                                => 'shn',
    'shona'                               => 'sn',
    'sichuanyi'                           => 'ii',
    'siciliaans'                          => 'scn',
    'sidamo'                              => 'sid',
    'siksika'                             => 'bla',
    'sindhi'                              => 'sd',
    'singalees'                           => 'si',
    'sinotibetaansetaal'                  => 'sit',
    'siouaansetalen'                      => 'sio',
    'skoltsami'                           => 'sms',
    'slavey'                              => 'den',
    'slavischetaal'                       => 'sla',
    'sloveens'                            => 'sl',
    'slowaaks'                            => 'sk',
    'soemerisch'                          => 'sux',
    'soendanees'                          => 'su',
    'soesoe'                              => 'sus',
    'sogdisch'                            => 'sog',
    'somalisch'                           => 'so',
    'songhaitaal'                         => 'son',
    'soninke'                             => 'snk',
    'sorbischetaal'                       => 'wen',
    'spaans'                              => 'es',
    'sranantongo'                         => 'srn',
    'sukuma'                              => 'suk',
    'swahili'                             => 'sw',
    'swazi'                               => 'ss',
    'syriac'                              => 'syr',
    'tadzjieks'                           => 'tg',
    'tagalog'                             => 'tl',
    'tahitisch'                           => 'ty',
    'taitaal'                             => 'tai',
    'tamashek'                            => 'tmh',
    'tamil'                               => 'ta',
    'taroko'                              => 'trv',
    'tataars'                             => 'tt',
    'teloegoe'                            => 'te',
    'tereno'                              => 'ter',
    'tetum'                               => 'tet',
    'thai'                                => 'th',
    'tibetaans'                           => 'bo',
    'tigre'                               => 'tig',
    'tigrinya'                            => 'ti',
    'timne'                               => 'tem',
    'tiv'                                 => 'tiv',
    'tlingit'                             => 'tli',
    'toemboeka'                           => 'tum',
    'tokelau'                             => 'tkl',
    'tokpisin'                            => 'tpi',
    'tonga'                               => 'to',
    'tsimshian'                           => 'tsi',
    'tsjechisch'                          => 'cs',
    'tsjoevasjisch'                       => 'cv',
    'tsonga'                              => 'ts',
    'tswana'                              => 'tn',
    'tupitaal'                            => 'tup',
    'turkmeens'                           => 'tk',
    'turks'                               => 'tr',
    'tuvalu'                              => 'tvl',
    'tuvinisch'                           => 'tyv',
    'twi'                                 => 'tw',
    'tyap'                                => 'kcg',
    'udmurt'                              => 'udm',
    'umbundu'                             => 'umb',
    'urdu'                                => 'ur',
    'vai'                                 => 'vai',
    'venda'                               => 've',
    'vietnamees'                          => 'vi',
    'vlaams'                              => 'nl_be',
    'volapük'                            => 'vo',
    'votisch'                             => 'vot',
    'wakashantaal'                        => 'wak',
    'walamo'                              => 'wal',
    'wallonisch'                          => 'wa',
    'waray'                               => 'war',
    'washo'                               => 'was',
    'welsh'                               => 'cy',
    'witrussisch'                         => 'be',
    'wolof'                               => 'wo',
    'xhosa'                               => 'xh',
    'yakut'                               => 'sah',
    'yao'                                 => 'yao',
    'yapees'                              => 'yap',
    'yoruba'                              => 'yo',
    'yupiktalen'                          => 'ypk',
    'zande'                               => 'znd',
    'zapotec'                             => 'zap',
    'zazaki'                              => 'zza',
    'zenaga'                              => 'zen',
    'zhuang'                              => 'za',
    'zuidaltaïsch'                       => 'alt',
    'zuidamerikaansindiaansetaal'         => 'sai',
    'zuidndbele'                          => 'nr',
    'zuidsamisch'                         => 'sma',
    'zuidsotho'                           => 'st',
    'zulu'                                => 'zu',
    'zuni'                                => 'zun',
    'zweeds'                              => 'sv',
    'zwitsersduits'                       => 'gsw',
    'zwitsersfrans'                       => 'fr_ch',
    'zwitsershoogduits'                   => 'de_ch',
);

1;
