#!/usr/bin/env python

import sys, os
import musicbrainz
from musicbrainz.queries import *
import webbrowser

def main():
    mb = musicbrainz.mb()

    mb.Query(MBQ_GetCDTOC)

    first = mb.GetResultInt(MBE_TOCGetFirstTrack)
    last = mb.GetResultInt(MBE_TOCGetLastTrack)

    for ii in xrange(first, last + 2):
        sectors = mb.GetResultInt1(MBE_TOCGetTrackNumSectors, ii)
        offset = mb.GetResultInt1(MBE_TOCGetTrackSectorOffset, ii)
        sec = sectors / 75        
        dura = "%d:%02d" % divmod(sec, 60)
        print dura
#
# Main program starts here
#
if __name__ == "__main__":
    main()
