// BASE_WND.CPP

// Copyright (C) 2005 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "base_wnd.h"

#include "base_app.h"
#include <stdlib.h>	// the definition for NULL...

/*################################################################################################*/

base_wnd::base_wnd()
{
	wcl = NULL;
	
	is_realized = false;
	is_initialized = false;
	
	size[0] = size[1] = -1;
}

base_wnd::~base_wnd(void)
{
	if (wcl != NULL)
	{
		base_app * app = base_app::GetAppB();
		app->ErrorMessage("base_wnd dtor : unlinked!");
	}
}

base_wcl * base_wnd::GetClient(void)
{
	return wcl;
}

bool base_wnd::GetRealized(void)
{
	return is_realized;
}

bool base_wnd::GetInitialized(void)
{
	return is_initialized;
}

int base_wnd::GetWidth(void)
{
	return size[0];
}

int base_wnd::GetHeight(void)
{
	return size[1];
}

bool base_wnd::IsTimerON(void)
{
	cout << "base_wnd::IsTimerON() called." << endl;
	return false;
}

void base_wnd::SetTimerON(int msec)
{
	cout << "base_wnd::SetTimerON() called, ";
	cout << "msec = " << msec << "." << endl;
}

void base_wnd::SetTimerOFF(void)
{
	cout << "base_wnd::SetTimerOFF() called." << endl;
}

void base_wnd::SetRealized(void)
{
	is_realized = true;
}

void base_wnd::SetInitialized(void)
{
	is_initialized = true;
}

void base_wnd::SetWidth(int w)
{
	size[0] = w;
}

void base_wnd::SetHeight(int h)
{
	size[1] = h;
}

/*################################################################################################*/

// eof
