MODULE Directory [FOREIGN "C"; LINK FILE "Directory.c" END];

IMPORT C;

CONST
  (* file types *)
  normal    * = 0;
  directory * = 1;
  
  typeCount * = 2;
  
  rightRead    * = 0;
  rightWrite   * = 1;
  rightExecute * = 2;
  
  specialUID    * = 0;
  specialGID    * = 1;
  specialSticky * = 2;

  (* available attributes *)
  type  * = 0;
  size  * = 1;
  user  * = 2;
  group * = 3;
  other * = 4;

TYPE
  Handle       * = C.address;

  DirEntry     * = POINTER TO DirEntryDesc;
  DirEntryDesc * = RECORD
                     attr*    : SET;     (** the attributes, that are set *)
                     type*    : LONGINT; (** the type of the file *)
                     size*    : LONGINT; (** the size of the file *)
                     user*,              (** the access rights for the user *)
                     group*,             (** the access rights for the group members *)
                     other*,             (** the access rights for all others *)
                     special* : SET;     (** other special file flags *)
                   END;

  PROCEDURE GetCurrentDirectory*(VAR directory : ARRAY OF CHAR);

  (** return the upper directory part of the given directory *)
  PROCEDURE Up*(VAR directory : ARRAY OF CHAR):BOOLEAN;

  (** Append the given subdirectory to the directory *)
  PROCEDURE Append*(VAR directory : ARRAY OF CHAR;
                    subdir : ARRAY OF CHAR):BOOLEAN;

  (** Makes a absolute directory from a relative directory *)
  PROCEDURE AbsoluteDir*(VAR directory : ARRAY OF CHAR):BOOLEAN;

  PROCEDURE GetDetails*(attributes : SET;
                        name : ARRAY OF CHAR;
                        entry : DirEntry);

  PROCEDURE OpenDir*(name : ARRAY OF CHAR):Handle;
  
  PROCEDURE GetDirEntry*(handle : Handle; VAR name : ARRAY OF CHAR):BOOLEAN;

  PROCEDURE CloseDir*(handle : Handle);

END Directory.