/***************************************************************************
  $RCSfile: mediumpluginlist.h,v $
  -------------------
  cvs         : $Id: mediumpluginlist.h,v 1.4 2003/05/11 16:56:09 aquamaniac Exp $
  begin       : Thu Apr 24 2003
  copyright   : (C) 2003 by Martin Preuss
  email       : martin@libchipcard.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef MEDIUMPLUGINLIST_H
#define MEDIUMPLUGINLIST_H

/** @file mediumpluginlist.h
 * @short List of plugins, with C wrappers
 */
#ifdef __cplusplus
namespace HBCI {
  class MediumPluginList;
};
typedef HBCI::MediumPluginList HBCI_MediumPluginList;
#else /* __cplusplus */
typedef struct HBCI_MediumPluginList HBCI_MediumPluginList;
#endif /* __cplusplus */

#include <openhbci/mediumplugin.h>

#ifdef __cplusplus
#include <list>
using namespace std;

namespace HBCI {

class MediumPluginFile;
class API;

/**
 * This class holds a list of plugin files which are loaded but not
 * registered !
 * This is needed to give a list of available plugins to the application.
 * @author Martin Preuss<martin@libchipcard.de>
 */
class MediumPluginList {
  friend class API;
private:
  list <Pointer<MediumPluginFile> > _files;
  list <Pointer<MediumPlugin> > _plugins;


  /**
   * can only be called by the class API
   */
  Error addPluginFile(const API *api,
		      Pointer<MediumPluginFile> pf);

  /**
   * can only be called by the class API
   */
  bool addPlugin(const API *api,
		 Pointer<MediumPlugin> p);

public:
  MediumPluginList();
  ~MediumPluginList();

  /** Returns the STL std::list of MediumPlugin s. */
  const std::list<Pointer<MediumPlugin> > &plugins() const;
};

}; /* namespace HBCI */


extern "C" {
#endif /* __cplusplus */
    
  /** @name HBCI_MediumPluginList
   *
   * Wrapper for HBCI::MediumPluginList */
  /*@{*/
  extern void HBCI_MediumPluginList_delete(HBCI_MediumPluginList *l);
  extern unsigned int 
  HBCI_MediumPluginList_size(const HBCI_MediumPluginList *l);
  /** Callback function for HBCI_MediumPluginList_foreach. */
  typedef void *(*HBCI_MediumPluginList_cb) (const HBCI_MediumPlugin* value, 
					     void *user_data);
  /** Traverses the list, calling the callback function 'func' on
   * each list element.  Traversal will stop when 'func' returns a
   * non-NULL value, and the routine will return with that
   * value. Otherwise the routine will return NULL. 
   * @param l The list to traverse.
   * @param func The function to be called with each list element.
   * @param user_data A pointer passed on to the function 'func'.
   * @return The non-NULL pointer returned by 'func' as soon as it
   * returns one. Otherwise (i.e. 'func' always returns NULL)
   * returns NULL.
   * @author Christian Stimming <stimming@tuhh.de> */
  extern void *HBCI_MediumPluginList_foreach(const HBCI_MediumPluginList *l,
					     HBCI_MediumPluginList_cb func,
					     void *user_data);
  /*@}*/

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif


