/***************************************************************************
 $RCSfile: simpleconfig.h,v $
                             -------------------
    cvs         : $Id: simpleconfig.h,v 1.8 2003/04/08 09:38:00 aquamaniac Exp $
    begin       : Fri Dec 21 2001
    copyright   : (C) 2001 by Martin Preuss
    email       : martin@aquamaniac.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/




/*
 */

#ifndef C_SIMPLECONFIG_H
#define C_SIMPLECONFIG_H

#include <string>
#include <openhbci/conf.h>
#include <openhbci/file.h>
#include <openhbci/dllimport.h>
#include <openhbci/pointer.h>

namespace HBCI {

/**
 * @short This class simplifies work with configuration files.
 * @author Martin Preuss<martin@aquamaniac.de>
 */
class DLLIMPORT SimpleConfig: public Config {
private:
public:
    SimpleConfig();
    ~SimpleConfig();

    /**
     * Set the value of a variable.
     * @author Martin Preuss<martin@aquamaniac.de>
     * @param name name of the variable (or path relative to root)
     * @param value new value to be set
     * @param where Starting point of variable search in this config
     */
    void setVariable(const string &name, 
		     const string &value,
                     Tree<ConfigNode>::iterator where);

    /**
     * Set the value of an integer variable.
     * @author Martin Preuss<martin@aquamaniac.de>
     * @param name name of the variable (or path relative to root)
     * @param value new value to be set
     * @param where Starting point of variable search in this config
     */
    void setIntVariable(const string &name, 
			int value,
                        Tree<ConfigNode>::iterator where);

    /**
     * Set the value of a float variable.
     * @author Martin Preuss<martin@aquamaniac.de>
     * @param name name of the variable (or path relative to root)
     * @param value new value to be set
     * @param where Starting point of variable search in this config
     */
    void setFloatVariable(const string &name, 
			  float value,
                          Tree<ConfigNode>::iterator where);

    /**
     * Set the value of a boolean variable.
     * @author Martin Preuss<martin@aquamaniac.de>
     * @param name name of the variable (or path relative to root)
     * @param value new value to be set
     * @param where Starting point of variable search in this config
     */
    void setBoolVariable(const string &name, 
			 bool value,
                         Tree<ConfigNode>::iterator where);

    /**
     * Get the value of the given variable.
     * If the variable does not exist or is empty then the given default
     * value will be returned.
     * @author Martin Preuss<martin@aquamaniac.de>
     * @param name name of the variable (or path relative to root)
     * @param defval default value
     * @param where Starting point of variable search in this config
     */
    const string &getVariable(const string &name, 
			      const string &defval,
			      Tree<ConfigNode>::const_iterator where) 
	const;

    /**
     * Get the value of the given integer variable.
     * If the variable does not exist or is empty then the given default
     * value will be returned.
     * @author Martin Preuss<martin@aquamaniac.de>
     * @param name name of the variable (or path relative to root)
     * @param defval default value
     * @param where Starting point of variable search in this config
     */
    int getIntVariable(const string &name, 
		       int defval,
                       Tree<ConfigNode>::const_iterator where) const;

    /**
     * Get the value of the given floating point variable.
     * If the variable does not exist or is empty then the given default
     * value will be returned.
     * @author Martin Preuss<martin@aquamaniac.de>
     * @param name name of the variable (or path relative to root)
     * @param defval default value
     * @param where Starting point of variable search in this config
     */
    float getFloatVariable(const string &name, 
			   float defval,
                           Tree<ConfigNode>::const_iterator where) const;

    /**
     * Get the value of the given boolean variable.
     * If the variable does not exist or is empty then the given default
     * value will be returned.
     * @author Martin Preuss<martin@aquamaniac.de>
     * @param name name of the variable (or path relative to root)
     * @param defval default value
     * @param where Starting point of variable search in this config
     */
    bool getBoolVariable(const string &name,
			 bool defval,
                         Tree<ConfigNode>::const_iterator where) const;

    /**
     * Reads a file. This new file will be merged into this config.
     * @author Martin Preuss<martin@aquamaniac.de>
     * @return error object (isOk() returns false on error)
     * @param name name of the file to read
     * @param access FIXME: add docs here
     */
    Error readFile(const string &name,
		   int access=FILE_AM_RDWR | FILE_AM_OPEN_EXISTING);

    Error readFile(File::StdType typ=File::StdTypeStdIn);

    /**
     * Writes a configuration file.
     * @author Martin Preuss<martin@aquamaniac.de>
     * @return error object (isOk() returns false on error)
     * @param name name of the file to write
     * @param access FIXME: add docs here
     * @param mode FIXME: add docs here
     */
    Error writeFile(const string &name,
		    int access=FILE_AM_RDWR | FILE_AM_CREATE_ALWAYS,
		    int mode=FILE_CM_WRITE | FILE_CM_READ);

    Error writeFile(File::StdType typ=File::StdTypeStdOut);

};

} /* namespace HBCI */
#endif





