/* consistencyTest.h
 */
#ifndef TEST_PROGRESS_CONSISTENCYTEST_H
#define TEST_PROGRESS_CONSISTENCYTEST_H

#include "osl/state/numEffectState.h"
#include "osl/record/csaString.h"
#include "osl/record/csaRecord.h"
#include "osl/oslConfig.h"
#include <fstream>
#include <string>
#include <iostream>

#include <cppunit/extensions/HelperMacros.h>

template <class Progress>
void consistencyTest()
{
  using namespace osl;

  std::ifstream ifs(OslConfig::testCsaFile("FILES"));
  CPPUNIT_ASSERT(ifs);
  std::string file_name;
  for (int i=0;i<(OslConfig::inUnitTestShort() ? 10 : 200) && (ifs >> file_name) ; i++)
  {
    if (file_name == "") 
      break;
    file_name = OslConfig::testCsaFile(file_name);

    const Record rec=CsaFile(file_name).getRecord();
    const vector<osl::Move> moves=rec.getMoves();

    NumEffectState state(rec.getInitialState());
    Progress progress(state);
    
    for (unsigned int i=0; i<moves.size(); i++)
    {
      const Move m = moves[i];
      state.makeMove(m);
      progress.update(state, m);
      const Progress new_progress(state);
      CPPUNIT_ASSERT_EQUAL(new_progress.progress(BLACK), 
			   progress.progress(BLACK));
      CPPUNIT_ASSERT_EQUAL(new_progress.progress(WHITE), 
			   progress.progress(WHITE));
      CPPUNIT_ASSERT(new_progress.progress16().isValid());
      CPPUNIT_ASSERT(progress.progress16().isValid());
    }
  }
}

template <class Progress>
void consistencyTestUpdate()
{
  using namespace osl;

  std::ifstream ifs(OslConfig::testCsaFile("FILES"));
  CPPUNIT_ASSERT(ifs);
  std::string file_name;
  for (int i=0;i<(OslConfig::inUnitTestShort() ? 10 : 200) && (ifs >> file_name) ; i++)
  {
    if (file_name == "") 
      break;
    file_name = OslConfig::testCsaFile(file_name);

    const Record rec=CsaFile(file_name).getRecord();
    const vector<osl::Move> moves=rec.getMoves();

    NumEffectState state(rec.getInitialState());
    Progress progress(state);
    
    for (unsigned int i=0; i<moves.size(); i++)
    {
      const Move m = moves[i];
      state.makeMove(m);
      progress.update(state, m);
      const Progress new_progress(state);
      if (new_progress.progress(BLACK) != progress.progress(BLACK)
	  || new_progress.progress(WHITE) != progress.progress(WHITE)) {
	std::cerr << state << "moves " << i << " " << m << "\n";
	std::cerr << (new_progress.progress(BLACK) != progress.progress(BLACK)
		      ? "BLACK" : "WHITE") << "\n";
      }
      CPPUNIT_ASSERT_EQUAL(new_progress.progress(BLACK), 
			   progress.progress(BLACK));
      CPPUNIT_ASSERT_EQUAL(new_progress.progress(WHITE), 
			   progress.progress(WHITE));
      CPPUNIT_ASSERT(new_progress.progress16().isValid());
      CPPUNIT_ASSERT(progress.progress16().isValid());
    }
  }
}


#endif /* TEST_PROGRESS_CONSISTENCYTEST_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
