package debian::scripts::dh_helper;

use strict;
use warnings;

BEGIN {
    use Exporter ();
    our ($VERSION, @ISA, @EXPORT, @EXPORT_OK, %EXPORT_TAGS);

    # set the version for version checking
    $VERSION     = 1.00;
    #if using RCS/CVS


    @ISA         = qw(Exporter);
    @EXPORT      = qw(&debhelper_split $debiandir);
    %EXPORT_TAGS = ();

    # exported package globals & additional functions
    @EXPORT_OK   = ();
}
our @EXPORT_OK;

# non-exported package globals go here

# initialize package globals, first exported ones
our $debiandir = 'debian';
# then the others


# functions that are exported

# functions that are not exported, but accessible

END { } # module clean-up code here (global destructor)

# splits a file in debian/packages.d/ into the files specified by %.ending% into
# debian/
# params: $infile = file in debian/packages.d
#         $outfile = file in debian/ (when set to '' it is assumed that $infile
#                    is the firstpackage in the control file
#         $append = when true append to and do not overwrite existing files
#         $config = ref to %config hash
sub debhelper_split($$$$) {
    my( $infile, $outfile, $append, $config ) = @_;
    my( $inhead ) = 1;

    $outfile=$outfile."." 
	if ( $outfile ne '' ); # append a . to make things easier for later
    if( $append ) {
	$append = ">>";
	#open( OLDOUT, "<${outfile}${1}" );
    } else {
	$append = ">";
    }

    if( !open( INFILE, "<$debiandir/packages.d/$infile" ) ) {
	print( "$debiandir/packages.d/$infile not found\n" ) 
	    if ($$config{'debug'});
	return( -1 );
    }
    
    while( <INFILE> ) {
	if (m/^\%(.*)\%$/) {
	    if ($$config{'needclean'}) { # remove files
		system("rm -f ${outfile}${1}");
	    } elsif ($$config{'needlist'}) { # output dependency list
		print "${outfile}${1} ";
	    } else {
		if (!$inhead) { close OUTFILE; } 
		$inhead = 0;
		print( "opening ${outfile}${1}\n" )
		    if ($$config{'debug'});
		if( !open( OUTFILE, "$append${outfile}${1}" ) ) {
		    die( "couldn't open outputfile: ${outfile}${1}\n" );
		}
	    }
	} elsif (!$inhead) {
	    s/\@BUILD_TREE\@/$ENV{'BUILD_TREE'}/g;
	    
	    print OUTFILE $_;
	}
    }
    print( OUTFILE "\n" )
	if( !$inhead ); # to prevent adding bad things twice
    close OUTFILE;
    close INFILE;
}

sub firstpackagename() {

}

sub appendfile(*$$) {
    my( $TFILE, $file, $config ) = @_;
    
    if ( !open( AFILE, "<$file" ) ) {
	print( "$file not found\n" ) if $$config{'debug'};
	return -1;
    }
    while(<AFILE>) { print( $TFILE $_ ); }
    close(AFILE);
    
    return( 0 );
}
