#!/usr/bin/ruby -I. -w

require "runit/testcase"
require "runit/cui/testrunner"

require "test/core_test"
require "test/xpath_test"
require "test/sub_test"

# Possible usage:
# 	suite.rb xpath				runs the XPath suite
# 	suite.rb xpath <test>	runs <test> from the XPath suite
# 	suite.rb <test>			runs <test> from the core suite
# 	suite.rb						runs all tests
if ARGV.size > 0
	if ARGV[0] == "xpath"
		test = XPathTester
	elsif ARGV[0] == "subtest"
		test = SubTester
	else
		test = Tester
		ARGV<<ARGV[0] if ARGV.size == 1
	end
	if ARGV.size == 2
		test = test.new(ARGV[1])
	else
		test = test.suite
	end
	RUNIT::CUI::TestRunner.run( test )
else
	RUNIT::CUI::TestRunner.run( Tester.suite )
	RUNIT::CUI::TestRunner.run( XPathTester.suite )
end
