/*
  imho_french.pike v0.1 for IMHO v0.96.3
  
  Copyright  
  Samson Bisaro <Samson.Bisaro@uhp.u-nancy.fr> 1999
  
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  See the file "LICENSE" for details.


*/

// Messages
//
//login
#define M_LOGIN 1
#define M_PASSWORD 2
#define M_NOLOGIN 3
#define M_IMAPERROR 10
#define M_SMTPERROR 11
#define M_SAVEDUSERINTERFACE 12
#define M_USERINTERFACE 13
#define M_LOGIN_OK 14
// page header
#define M_NEWMAIL 50
#define M_MAILBOX 51
#define M_MAILBOXES 52
#define M_FILES 53
#define M_PREFS 54
#define M_LOGOUT 55
#define M_CURRMAILBOX 56
#define M_CHECKACTIVEMAILBOXES 57
// compose
#define M_SEND 100
#define M_CANCELSEND 101
#define M_SENDMOREFILES 102
#define M_COMPOSEMAIL 103
#define M_SPELLCHECK 104
#define M_DONTSAVEMAIL 105
#define M_ADDFILEASATTACHMENT 106
#define M_NOATTACHMENTS 107
#define M_ADDATTACHMENT 108
#define M_REMOVEMARKEDATTACHMENTS 109
#define M_UPLOADATTACHMENT 110
#define M_ADDMARKEDTOATTACHMENTS 111
#define M_UPLOADTOATTACHMENTS 112
#define M_BACKTOCOMPOSE 113
#define M_NOATTACHFILES 114
#define M_ATTACHMENTSHEADER 115
#define M_SENDSAVEFAILED 116
#define M_SENDNORECV 117
// mailindex
#define M_DELETEMARKED 200
#define M_MOVEMARKED 201
#define M_SELECTMBOX 202
#define M_CHECKNEWMAIL 203
#define M_MAILSHOWN 204
#define M_BACKN 205
#define M_FORWARDN 206
#define M_NUMBER 207
#define M_DELETEMARKEDP 208
#define M_DELETEMARKEDNONE 209
#define M_CHANGESORTORDER 210
#define M_MOVETOTRASH 211
#define M_DELETEALLTRASH 212
#define M_NOMAILS 213
// mailboxlist
#define M_MBOXNAME 300
#define M_DELETEMARKEDMBOX 301
#define M_CREATEMBOX 302
#define M_NEWMBOXNAME 303
#define M_MBOXREMOVEP 350
#define M_MBOXMARKONE 351
#define M_NEWMBOXNONAME 352
#define M_CREATEMBOXERROR 353
#define M_INBOX 354
#define M_PREVIOUS_LEVEL 355
#define M_FOLDER_PATH 356
// files
#define M_FILENAME 400
#define M_SIZE 401
#define M_MIMETYPE 402
#define M_DELETEMARKEDFILES 403
#define M_UPLOAD 404
#define M_AVAILSPACE 405
#define M_WINDOWSBUG 406
#define M_NOFILES 407
// preferences
#define M_PNAME 500
#define M_PMAILADDRESS 501
#define M_PMAILPATH 502
#define M_PINCLUDEMAIL 503
#define M_PQUOTEPREFIX 504
#define M_PSIGNATURE 505
#define M_PINACTIVELOGOUT 506
#define M_PSAVEANDUSE 550
#define M_PVISIBLEMESSAGES 507
#define M_PSORTORDER 508
#define M_PSORTORDERS 509
#define M_PTRASHFOLDER 510
#define M_PSENTFOLDER 511
#define M_PDEFAULTBCC 512
#define M_PSAVEATTACHMENTS 513
#define M_PLANGUAGE 514
#define M_PUSERINTERFACE 515
#define M_PINBOXES 516
#define M_PCOMMASEPARATED 517
// logout
#define M_LOGOUTMSG 600
#define M_LOGGEDOUT 601
// dialog
#define M_QUESTION 700
#define M_INFO 701
// readmail
#define M_REPLY 800
#define M_READPREV 801
#define M_READNEXT 802
#define M_ATTACHMENTLINK 803
#define M_MAILMISSING 804
#define M_MAILMISSINGBACK 805
#define M_DELETE 806
#define M_FORWARD 807
#define M_MAIL 808
#define M_SHOWFULLHEADERS 809
#define M_HIDEFULLHEADERS 810
#define M_MAILTOOBIG 811
//spellcheck
#define M_SPELLDONE 900
#define M_SPELLPREV 901
#define M_SPELLNEXT 902
#define M_SPELLCHANGETO 903
#define M_SPELLSUGGESTIONS 904
// mailheaders
#define M_FROM 1000
#define M_TO 1001
#define M_CC 1002
#define M_BCC 1003
#define M_SUBJECT 1004
#define M_ATTACHMENTS 1005
#define M_TIME 1006
#define M_DATE 1007
// table heads
#define M_MARKFLAG 1100
#define M_NEWFLAG 1101
#define M_ANSWEREDFLAG 1102
// address book
#define M_ADDRESSBOOKTITLE 1200
#define M_ADDRESSBOOK 1201
#define M_INDEXNAMERECIPIENT 1202
#define M_INDEXNAMEEDIT 1203
#define M_ADDRESS 1204
#define M_NOADDRESSES 1205
#define M_NEWADDRESS 1206
#define M_EDITADDRESS 1207
#define M_ADDADDRESS 1208
#define M_INDEXNAME 1209
#define M_ADDRESSFORMAT 1210
#define M_SAVEADDRESS 1211
#define M_DELETEADDRESS 1212
#define M_CANCELADDRESS 1213
#define M_CANNOTIMPORT 1214
#define M_IMPORTADDRESSBOOKTITLE 1215
#define M_UPLOADADDRESSBOOK 1216
#define M_PINELOCATION 1217
#define M_UPLOADANDIMPORT 1218
#define M_IMPORTADDRESSBOOK 1219
//ldap support
#define M_LDAPTITLE 1300
#define M_LDAP 1301
#define M_SEARCHLDAP 1302
#define M_NAMECONT 1303
#define M_OU 1304

// general
#define M_YES 2000
#define M_NO 2001
#define M_DIALOGOK 2002
#define M_DIALOGCANCEL 2003


string imho_lang() {
	return "franais";
}

string imho_lang_short() {
	return "fr";
}

string imho_lang_charset() {
  return "iso-8859-1";
}

string msg(object sessobj,int m,array arg) {
	switch(m) {

  case M_LOGIN:
    return "Login:";
  case M_PASSWORD:
    return "Mot de passe:";
  case M_NOLOGIN:
    return "<b>Accs impossible :</b> Mauvais mot de passe ou login incorrect. Recommencez. ";
  case M_IMAPERROR:
    return "Problme avec le serveur IMAP. Cantactez l'administrateur systeme.";
  case M_SMTPERROR:
    return "Problme avec le serveur sortant SMTP, message non envoy.";
  case M_SAVEDUSERINTERFACE:
    return "Depuis les prfrences";
  case M_USERINTERFACE:
    return "Interface utilisateur:";
  case M_LOGIN_OK:
    return "OK";

  case M_NEWMAIL:
    return "Ecrire un message";
  case M_MAILBOX:
    return sprintf("Dossier: %s",@arg);
  case M_MAILBOXES:
    return "Dossier(s)";
  case M_FILES:
    return "Fichiers";
  case M_PREFS:
    return "Prfrences";
  case M_LOGOUT:
    return "Se dconnecter";
  case M_CURRMAILBOX:
    return "Bote en cours";
  case M_CHECKACTIVEMAILBOXES:
    return "Vrifier les botes";

  case M_FROM:
    return "Expditeur";
  case M_TO:
    return "Destinataire";
  case M_CC:
    return "Copie ";
  case M_BCC:
    return "Copie cache ";
  case M_SUBJECT:
    return "Sujet";
  case M_ATTACHMENTS:
    return "Fichier(s) joint(s)";
  case M_TIME:
    return "Heure";
  case M_DATE:
    return "Date";

  case  M_MARKFLAG:
    return "M";
  case M_NEWFLAG:
    return "N";
  case M_ANSWEREDFLAG:
    return "R";


  case M_SEND:
    return "Envoyer";
  case M_CANCELSEND:
    return "Annuler";
  case M_SENDMOREFILES:
    return "Choisir fichier  envoyer. Appuyer sur 'Ctrl' pour choix multiple.";
  case M_COMPOSEMAIL:
    return "Rdaction de message";  
  case M_SPELLCHECK:
    return "Orthographe";
  case M_DONTSAVEMAIL:
   return "Ne pas sauvegarder ce message.";
  case M_ADDFILEASATTACHMENT:
    return "Joindre un fichier";
  case M_NOATTACHMENTS:
    return "Pas de fichier joint";  
  case M_ADDATTACHMENT:
    return "Joindre un fichier...";
  case M_REMOVEMARKEDATTACHMENTS:
    return "Annuler fichier(s) joint(s) slectionn(s)";
  case M_UPLOADATTACHMENT:
    return "Joindre un fichier"; 
  case M_ADDMARKEDTOATTACHMENTS:
    return "Joindre fichier(s) slectionn(s)";
  case M_UPLOADTOATTACHMENTS:
    return "Ajouter fichier slectionn au message";
  case M_BACKTOCOMPOSE:
    return "Retour au message";
  case M_NOATTACHFILES:
    return "Pas de fichier joint";
  case M_ATTACHMENTSHEADER:
    return "Joindre Fichier(s)";
  case M_SENDSAVEFAILED:
    return "Message envoy, mais la sauvegarde dans le dossier a choue.";
  case M_SENDNORECV:
    return "Vous devez spcifier le destinataire du message !";

  case M_DELETEMARKED:
    return "Effacer lment(s) slectionn(s);";
  case M_MOVEMARKED:
    return "Dplacer lment(s) slectionn(s) vers";
  case M_SELECTMBOX:
    return "Choisir un dossier..."; 
  case M_CHECKNEWMAIL:
    return "Retirer message(s)";
  case M_MAILSHOWN:
    return sprintf("Mail %d-%d of %d", @arg);
  case M_BACKN:
    return sprintf("[<< Precedent %d]", @arg);
  case M_FORWARDN:
    return sprintf("[Suivant %d >>]", @arg);
  case M_NUMBER:
    return "#";
  case M_DELETEMARKEDP:
    return 
      sprintf("Etes vous sr de vouloir effacer le(s) %d message(s) selectionne(s) ?",@arg);
  case M_DELETEMARKEDNONE:
    return "Selectionnez d'abord un message.";
  case M_CHANGESORTORDER:
    return "Changer l'ordre de tri"; 
  case M_MOVETOTRASH:
    return "Dplacer vers la poubelle";
  case M_DELETEALLTRASH:
    return "Effacer toute la poubelle";
  case M_NOMAILS:
    return "Pas de nouveau(x) message(s)";

  case M_MBOXNAME:
    return "Dossier";
  case M_DELETEMARKEDMBOX:
    return "Effacer lment(s) slectionn(s)";
  case M_CREATEMBOX:
    return "Crer un nouveau dossier ";   
  case M_NEWMBOXNAME:
    return "";
  case M_MBOXREMOVEP:
    return "Etes vous sr de vouloir effacer le(s) dossier(s) suivant(s) ?";
  case M_MBOXMARKONE:
    return "Selectionnez au moins un dossier.";
  case M_NEWMBOXNONAME:
    return "Veuillez d'abord entrer un nom.";  
  case M_CREATEMBOXERROR:
    return "La cration a choue. Le nom est illgal ou dej utilis.";
  case M_INBOX:
    return "Rception";
  case M_PREVIOUS_LEVEL:
    return "Dossier prcedent";
  case M_FOLDER_PATH:
    return "Chemin:";

  case M_FILENAME:
    return "Nom du fichier";  
  case M_SIZE:
    return "Taille";
  case M_MIMETYPE:
    return "Type";
  case M_DELETEMARKEDFILES:
    return "Effacer fichier(s) slectionn(s)";
  case M_UPLOAD:
     return "Charger fichier";
  case M_AVAILSPACE:
     return sprintf("Vous avez %d Kb de disponible pour charger des fichiers.",@arg);
  case M_WINDOWSBUG :
     return "Utilisateurs Windows : Vous pouvez rencontrer des problmes selon le navigateur utilis, les noms de fichiers peuvent tre altrs. Afin d'y remdier, remplacer le dernier \ par \\ avant d'ajouter le fichier joint au message.";
  case M_NOFILES:
    return "Vous n'avez chargez aucun fichier.";

  case M_PNAME:
    return "Nom";
  case M_PMAILADDRESS:
    return "Adresse lectronique";
  case M_PMAILPATH:
    return "Chemin de la bote"; 
  case M_PINCLUDEMAIL:
    return "Inclure le message d'origine en rpondant  l'expditeur";
  case M_PQUOTEPREFIX :
    return "Prfixe";
  case M_PSIGNATURE:
    return "Signature";
  case M_PINACTIVELOGOUT:
    return "Dconnexion automatique (minutes)";
  case M_PSAVEANDUSE:
    return "Enregistrer les modifications";
  case M_PVISIBLEMESSAGES:
    return "Nombre de messages  afficher dans la bote de rception"; 
  case M_PSORTORDER:
    return "Ordre de tri des messages";
  case M_PSORTORDERS:
    return ([ "forward": "croissant", "backward":"dcroissant"])[arg[0]];
  case M_PTRASHFOLDER:
    return "Emplacement poubelle"; 
  case M_PSENTFOLDER:
    return "Dossier des messages envoys"; 
  case M_PDEFAULTBCC:
    return "Destinataire de copie cache par dfaut";
  case M_PSAVEATTACHMENTS:
    return "Inclure fichier(s) joint(s)";
  case M_PLANGUAGE:
    return "Langage";
  case M_PUSERINTERFACE:
    return "Interface utilisateur";
  case M_PINBOXES:
    return "Bote(s) aux lettres";
  case M_PCOMMASEPARATED: 
    return "(Si plusieurs, virgule pour sparer)";

  case M_SPELLDONE:
    return "Correction effectue";
  case M_SPELLPREV:
    return "Prcedent";
  case M_SPELLNEXT:
    return "Suivant";
  case  M_SPELLCHANGETO:
    return "Remplacer par";
  case M_SPELLSUGGESTIONS:
    return "Suggestions"; 

  case M_LOGOUTMSG:
    return "<b><br><br>Vous tes  prsent dconnect, merci d'avoir utilis la messagerie.<br>Fermez votre navigateur pour vous assurer que personne d'autre ne lise vos messages.<br>Rechargez cette page pour vous reconnecter.<br><br></b>";
  case M_LOGGEDOUT:
    return "Se dconnecter";

  case M_QUESTION:
    return "Question";
  case M_INFO:
    return "Information";

  case M_REPLY:
    return "Rpondre";
  case M_READPREV:
    return "Lire prcedent";
  case M_READNEXT:
    return "Lire suivant";
  case M_ATTACHMENTLINK:
    return sprintf("%sfichier joint de type %s",@arg);
  case M_MAILMISSING:
    return "<b>Erreur:</b> Impossible de rcuprer le courrier. Essayer encore. <br>";
  case M_MAILMISSINGBACK:
    return "Retour";
  case M_DELETE:
    return "Effacer";
  case M_FORWARD:
    return "Transfrer";
  case M_MAIL:
    return "Mail";
  case M_SHOWFULLHEADERS:
    return "Montrer l'entte";
  case M_HIDEFULLHEADERS:
    return "Masquer l'entte";
  case M_MAILTOOBIG:
    return "Message trop grand pour tre affich.Cliquez ici pour le sauvegarder";

  case M_ADDRESSBOOKTITLE: 
    return("Carnet d'adresses");
  case M_ADDRESSBOOK:
    return("Carnet d'adresses...");
  case M_INDEXNAMERECIPIENT:
    return("Nom");
  case M_INDEXNAMEEDIT:
    return("Nom");
  case M_ADDRESS:
    return("Adresse lectronique");
  case M_NOADDRESSES:
    return("Pas de carte dfinie"); 
  case M_NEWADDRESS:
    return("Nouvelle carte...");
  case M_EDITADDRESS:
    return("Modifier carte"); 
  case M_ADDADDRESS:
    return("Ajouter au carnet d'adresse");
  case M_INDEXNAME:
    return("Nom");
  case M_ADDRESSFORMAT:
    return("Adresse(s) lectronique(s), virgule pour sparer");
  case M_SAVEADDRESS:
    return("Enregistrer");
  case M_DELETEADDRESS:
    return("Effacer carte");   
  case M_CANCELADDRESS:
    return("Annuler"); 
  case M_CANNOTIMPORT:
    return("Impossible d'importer ce fichier, format non reconnu."); 
  case M_IMPORTADDRESSBOOKTITLE:
    return("Importer carnet d'adresse depuis un fichier"); 
  case M_UPLOADADDRESSBOOK:
    return("Importer un fichier Pine ou Netscape (.ldif)");
  case M_PINELOCATION:
    return("Le fichier de carnet d'adresses Pine est souvent ~/.addressbook");
  case M_UPLOADANDIMPORT:
    return("Valider"); 
  case M_IMPORTADDRESSBOOK:
    return("Importer carnet d'adresse depuis un fichier..."); 
    
    // added for ldap
  case M_LDAPTITLE:
    return("LDAP adresses");
  case M_LDAP:
    return("Annuaire...");
  case M_SEARCHLDAP:
    return("Lancer la recherche");
  case M_NAMECONT:
    return("Rechercher le nom comportant :");
  case M_OU:
    return("Filire");

  case M_YES:
    return "Oui";
  case M_NO:
    return "Non";
  case M_DIALOGOK:
    return "OK";
  case M_DIALOGCANCEL:
    return "Annuler";

  }
  return 0;
}



