/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.jdbc.translators;

import java.sql.*;
import java.io.IOException;
import com.sap.dbtech.util.*;
import com.sap.dbtech.jdbc.exceptions.*;
/**
 *
 */
class BytesTranslator extends BinaryDataTranslator {
    /**
     *
     */
    BytesTranslator(
        int mode,
        int ioType,
        int dataType,
        int len,
        int ioLen,
        int bufpos,
        boolean readOnly, 
        boolean autoIncr)
    {
        super (mode, ioType, dataType, len, ioLen, bufpos, readOnly, autoIncr);
    }
    public byte getByte (
        SQLParamController controller,
        StructuredMem mem) throws SQLException
    {
        byte [] result = null;
        if (this.isNull (controller, mem))
          return 0;
        else
          result = mem.getBytes (this.bufpos, 1);
        return result[0];
    }
    /**
     *
     * @return byte []
     */
    public java.sql.Blob getBlob (
            SQLParamController controller,
            StructuredMem mem,
            StructuredMem longData)
            throws SQLException
    {
        Blob result = null;

        if (!this.isNull (controller, mem)) {
            result = new GetvalCharByte( mem.getBytes (this.bufpos, this.logicalLength));
        }
        return result;
    }
    /**
    *
    * @return byte []
    */
   public byte [] getBytes (
       SQLParamController controller,
       StructuredMem mem)
   throws SQLException
   {
       byte [] result = null;

       if (!this.isNull (controller, mem)) {
           result = mem.getBytes (this.bufpos, this.logicalLength);
       }
       return result;
   }

   /**
     *
     * @return java.lang.String
     */
    public Object getObject (
        SQLParamController controller,
        StructuredMem mem)
    throws SQLException
    {
        return this.getBytes (controller, mem);
    }
    /**
     *
     * @return java.lang.String
     */
    public String getString (
        SQLParamController controller,
        StructuredMem mem)
    throws SQLException
    {
        String result;
        byte [] rawResult;

        rawResult = this.getBytes (controller, mem);
        if (rawResult == null) {
            result = null;
        }
        else {
            result = new String (rawResult);
        }
        return result;
    }



    public Object transByteForInput (
            byte val) throws SQLException
    {
        byte[] barr=new byte[1];
        barr[0]=val;
        return this.transBytesForInput(barr);
    }

    /**
     *
     * @param newValue byte
     */
    public Object transBytesForInput (byte [] arg)
    throws java.sql.SQLException
    {
        if (arg == null) {
            return arg;
        }
        this.checkFieldLimits (arg.length);
        return arg;
    }
    /**
     *
     * @param obj java.lang.Object
     */
    public Object transSpecificForInput (Object obj)
    throws SQLException
    {
        Object result = null;
        Class clazz = obj.getClass ();
        String clazzName;

        if (clazz.isArray ()) {
            clazzName = clazz.getName ();
            if (clazzName.equals("[B")) {
                result = this.transBytesForInput ((byte []) obj);
            }
        }
        return result;
    }
    /**
     *
     * @return java.sql.Date
     */
    public Object transStringForInput (
        String val) throws SQLException
    {
        if (val == null) {
            return null;
        }
        else {
            return this.transBytesForInput (val.getBytes ());
        }
    }

    public Object transCharacterStreamForInput(java.io.Reader stream, int length)
        throws SQLException
    {
        if(length <=0) {
            return null;
        }
        try {
            char[] ba=new char[length];
            int r=stream.read(ba);
            if(r!=length) {
                if(r==-1) r=0;
                char[] ba2=ba;
                ba=new char[r];
                System.arraycopy(ba2, 0, ba, 0, r);
            }
            return transStringForInput(new String(ba));
        } catch(IOException ioex) {
            throw new SQLExceptionSapDB(ioex.getMessage());
        }
    }


    public Object transBinaryStreamForInput(java.io.InputStream stream, int length)
        throws SQLException
    {
        if(length <=0) {
            return null;
        }
        try {
            byte[] ba=new byte[length];
            int r=stream.read(ba);
            if(r!=length) {
                if(r==-1) r=0;
                byte[] ba2=ba;
                ba=new byte[r];
                System.arraycopy(ba2, 0, ba, 0, r);
            }
            return transBytesForInput(ba);
        } catch(IOException ioex) {
            throw new SQLExceptionSapDB(ioex.getMessage());
        }
    }

    /**
     *
     * @return java.io.InputStream
     * @exception java.sql.SQLException The exception description.
     */
    public java.io.InputStream getBinaryStream (
            SQLParamController controller,
            StructuredMem mem,
            StructuredMem longData) throws SQLException
    {
        byte [] asBytes = this.getBytes (controller, mem);
        java.io.InputStream result;

        if (asBytes == null) {
            return null;
        }
        result = new java.io.ByteArrayInputStream (asBytes);
        return result;
    }
}
