package com.sap.dbtech.jdbc.translators;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import java.sql.Clob;
import java.sql.SQLException;

import com.sap.dbtech.util.MessageKey;
import com.sap.dbtech.util.MessageTranslator;
/*

 @author d031096

 ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


 */
public class GetvalChar extends AbstractSimpleGetval implements Clob {
    
    String data;
    
    public GetvalChar(String datavalue) {
      this.data = datavalue;
    }

    public long length() throws SQLException {
        return data.length();
    }

    public String getSubString(long pos, int length) throws SQLException {
        if (length+pos-1 > data.length() ){
            throw new SQLException(MessageTranslator.translate(MessageKey.ERROR_INVALID_BLOB_POSITION, String.valueOf(pos)));  
        }
        String erg = null; 
        try {
           erg = data.substring((int)pos-1, (int)pos-1+length);
        } catch (Exception e) {
            throw new SQLException(MessageTranslator.translate(MessageKey.ERROR_INVALID_BLOB_POSITION, String.valueOf(pos)));  
        }
        return erg;
    }

    public Reader getCharacterStream() throws SQLException {
        return new StringReader(data);
    }

    public InputStream getAsciiStream() throws SQLException {
        return new StringBufferInputStream(data);
    }

}
