// TeSpatialOperators.cpp: implementation of the TeSpatialOperators class.
//
//////////////////////////////////////////////////////////////////////

#include "TeComputeAttributeStrategies.h"
#include "TeSTElementSet.h"
#include "TeOverlay.h"

using namespace TeOVERLAY;

bool TeNearest (TeCoord2D& pt,TePointSet& ps, TeCoord2D& pout, double& dmin, const double& tol = 0.0);

TePropertyVector 
TeCategoryAreaPercentageStrategy::compute (TeTheme* theme, const string& attrName, TeBox box, const string& columnName)  
{

	// convert input box to a polygonset
	TePolygonSet box_ps = TeBox2PolygonSet (box);
	map<string, double>  areaMap;
	double partial_area = 0.0;

	// Build stoset
	TeSTElementSet stos (theme);
	vector<string> attrNames;
	attrNames.push_back (attrName);	
	if (TeSTOSetBuildDB (&stos, true, false, attrNames))
		{	
		
			// initialize areMap
			map<string, string>::iterator itMap = classesMap_.begin();
			while (itMap != classesMap_.end())
			{
				areaMap[(*itMap).second] = 0;
				++itMap;
			}
			partial_area = 0.0;
			// iterate over all objects that intercept the box
			TeSTElementSet::iterator it = stos.begin();
			while (it != stos.end())
			{
				string category;
				if ((*it).getPropertyValue (attrName, category))
				{	
					TePolygonSet objGeom;  
					if ((*it).getGeometry(objGeom))
					{
						TePolygonSet intersect;
						TeOverlay(box_ps, objGeom, intersect, TeINTERSECTION);
						double intersectArea = TeGeometryArea (intersect);
						partial_area += intersectArea;
						areaMap[classesMap_[category]] +=  intersectArea; // suppose objects are disjoint
					
					}
			
				}
				++it;
			}
		}

	double areaTot = TeGeometryArea (box_ps);
	double perc_total = 0.0;
	double corrected_perc_total = 0.0;
	vector<double> vec_percent;


	map <string, double>:: iterator areaIt = areaMap.begin();
	while(areaIt != areaMap.end())  
	{
		double percent = 0.0;
		if (areaTot != 0) percent = (*areaIt).second/areaTot;
		perc_total += percent;
		vec_percent.push_back (percent);
		++areaIt;
	}


	int i = 0;
	if (perc_total > 1.5) 
	{
		areaIt = areaMap.begin();
		while(areaIt != areaMap.end())  
		{
			if ((*areaIt).first == "")
			{
				perc_total = perc_total - vec_percent[i];
				vec_percent[i] = 0.0;
			}
			++areaIt;
			i++;
		}
	}

	i = 0;
	if (perc_total > 1.02) 
	{
		areaIt = areaMap.begin();
		while(areaIt != areaMap.end())  
		{
			vec_percent[i] = vec_percent[i]/perc_total;
			++areaIt;
			i++;
		}
	}	
	
	TePropertyVector  result;
	i= 0;
	areaIt = areaMap.begin();
	while(areaIt != areaMap.end())  
	{
	
		TeProperty prop;
		double percent = vec_percent[i];
		corrected_perc_total += percent;
		prop.value_    = Te2String (percent); // count
		prop.attr_.rep_.name_ = columnName + (*areaIt).first; // category
		prop.attr_.rep_.type_ = TeREAL;
		result.push_back (prop);
		++areaIt;
		i++;

	}
	return result;

}




// For relative values to be weighted in space (e.g., population densitity, malaria per number of inhabitants, etc.)	

TePropertyVector  TeAverageWeighbyAreaStrategy::
compute (TeTheme* theme, const string& attrName, TeBox box, const string& columnName)  
{

	double weigh_val = 0.0;


	// Build stoset
	TeSTElementSet stos (theme);
	vector<string> attrNames;
	attrNames.push_back (attrName);	
	if (TeSTOSetBuildDB (&stos, true, false, attrNames))
	{	

		// convert input box to a polygonset
		TePolygonSet box_ps = TeBox2PolygonSet (box);
		double areaBox = TeGeometryArea(box);
		if (areaBox > 0.0)
		{
			TeSTElementSet::iterator it = stos.begin();
			while (it != stos.end())
			{
				string val;
				if ((*it).getPropertyValue (attrName, val))
				{
					double num_val = atof (val.c_str());
					TePolygonSet objGeom;  
					if ((*it).getGeometry(objGeom))
					{
					
						// for (unsigned int i = 0 ; i < objGeom.size(); i++)
						//	TeRemoveDuplicatedCoordinates (objGeom[i]);
						TePolygonSet intersect;
						TeOverlay(box_ps, objGeom, intersect, TeINTERSECTION);
						double intersectArea = TeGeometryArea (intersect);
						weigh_val += num_val*(intersectArea/areaBox); // suppose objects are disjoint
		
					
					}
				}
				++it;
			}
		}
	}

 	TeProperty  prop;
	prop.value_ = Te2String (weigh_val);
	prop.attr_.rep_.name_ = columnName;
	prop.attr_.rep_.type_ = TeREAL;

	TePropertyVector  result;
	result.push_back (prop);
	return result;
}





TePropertyVector 
TeCategorySoilsAreaPercentageStrategy::compute (TeTheme* theme, const string& attrName, TeBox box, const string& columnName)  
{

	map<string, double>  areaMap;
	double partial_area = 0.0;

	// convert input box to a polygonset
	TePolygonSet box_ps = TeBox2PolygonSet (box);
	map<string, double> categoryMap;


	// Build stoset
	TeSTElementSet stos (theme);
	vector<string> attrNames;
	attrNames.push_back (attrName);	
	if (TeSTOSetBuildDB (&stos, true, false, attrNames))
	{	
	
			// initialize areMap
			map<string, string>::iterator itMap = classesMap_.begin();
			while (itMap != classesMap_.end())
			{
				areaMap[(*itMap).second] = 0;
				++itMap;
			}
			partial_area = 0.0;
			// iterate over all objects that intercept the box
			TeSTElementSet::iterator it = stos.begin();
			while (it != stos.end())
			{
				string category;
				if ((*it).getPropertyValue (attrName, category))
				{	
					TePolygonSet objGeom;  
					if ((*it).getGeometry(objGeom))
					{
						TePolygonSet intersect;
						TeOverlay(box_ps, objGeom, intersect, TeINTERSECTION);
						double intersectArea = TeGeometryArea (intersect);
						partial_area += intersectArea;
						areaMap[classesMap_[category]] +=  intersectArea; // suppose objects are disjoint
						categoryMap[category] +=  intersectArea; 
					}
			
				}
				++it;
			}
		}

	double areaTot = TeGeometryArea (box_ps);

	map <string, double>:: iterator categoryIt = categoryMap.begin();
	if (partial_area > (1.5*areaTot)) 
	{
		while(categoryIt != categoryMap.end())  
		{
			if ((*categoryIt).first == "")
			{
				partial_area -= (*categoryIt).second;
				areaMap[classesMap_[(*categoryIt).first]] -= (*categoryIt).second;
				(*categoryIt).second = 0.0;
			}
			++categoryIt;
		}
	}

	int i = 0;
	double perc_total = 0.0;
	vector<double> vec_percent;		
	map <string, double>:: iterator areaIt = areaMap.begin();
	while(areaIt != areaMap.end())  
	{
		double percent = 0.0;
		if (areaTot != 0) percent = (*areaIt).second/areaTot;
		perc_total += percent;
		vec_percent.push_back (percent);
		++areaIt;
	}

	double corrected_perc_total = 0.0;
	i = 0;
	if (perc_total > 1.02) 
	{
		areaIt = areaMap.begin();
		while(areaIt != areaMap.end())  
		{
			vec_percent[i] = vec_percent[i]/perc_total;
			++areaIt;
			i++;
		}
	}	
	
	TePropertyVector  result;
	i= 0;
	areaIt = areaMap.begin();
	while(areaIt != areaMap.end())  
	{
	
		TeProperty prop;
		double percent = vec_percent[i];
		corrected_perc_total += percent;
		prop.value_    = Te2String (percent); // count
		prop.attr_.rep_.name_ = columnName + (*areaIt).first; // category
		prop.attr_.rep_.type_ = TeREAL;
		result.push_back (prop);
		++areaIt;
		i++;

	}
	return result;

}

TePropertyVector 
TeCategoryMajorityStrategy::compute (TeTheme* theme, const string& attrName, TeBox box, const string& columnName)  
{
	map<string, double>  areaMap;
	// convert input box to a polygonset
	TePolygonSet box_ps = TeBox2PolygonSet (box);

	// Build stoset
	TeSTElementSet stos (theme);
	vector<string> attrNames;
	attrNames.push_back (attrName);	
	if (TeSTOSetBuildDB (&stos, true, false, attrNames))
	{	
			// initialize areMap
			map<string, string>::iterator itMap = classesMap_.begin();
			while (itMap != classesMap_.end())
			{
				areaMap[(*itMap).second] = 0;
				++itMap;
			}

			// iterate over all objects that intercept the box
			TeSTElementSet::iterator it = stos.begin();
			while (it != stos.end())
			{
				string category;
				if ((*it).getPropertyValue (attrName, category))
				{	

					TePolygonSet objGeom;  
					if ((*it).getGeometry(objGeom))
					{
						TePolygonSet intersect;
						TeOverlay(box_ps, objGeom, intersect, TeINTERSECTION);
						double intersectArea = TeGeometryArea (intersect);
						areaMap[classesMap_[category]] +=  intersectArea; // suppose objects are disjoint
					}
			
				}
				++it;
			}
		}

	double max = 0.0;
	TePropertyVector  result;
	TeProperty prop;
	prop.attr_.rep_.type_ = TeSTRING;
//	prop.value_ = defaultValue_.value_;
	prop.attr_.rep_.name_ = columnName; 
	prop.attr_.rep_.numChar_ = 48;
	map <string, double>:: iterator it = areaMap.begin();
	while(it != areaMap.end())  
		{
			if ((*it).second > max)
			{
				prop.value_ = (*it).first;
				max = (*it).second;
			}
			++it;		
		}


	result.push_back (prop);
	return result;

}

TePropertyVector TeTotalAreaPercentageStrategy:: 
compute (TeTheme* theme, const string& attrName, TeBox box, const string& columnName)
{  
	double area = TeGeometryArea(box);
	double totArea = 0.0;

	if (area > 0.0)
	{
		// convert input box to a polygonset
		TePolygonSet box_ps = TeBox2PolygonSet (box);

		// Build stoset
		TeSTElementSet stos (theme);
		vector<string> attrNames;
		attrNames.push_back (attrName);	
		if (TeSTOSetBuildDB (&stos, true, false, attrNames))
		{
			// iterate over all objects that intercept the box
			TeSTElementSet::iterator it = stos.begin();
			while (it != stos.end())
			{
				TePolygonSet objGeom;  
				if ((*it).getGeometry(objGeom))
				{
						TePolygonSet intersect;
						//TeGeometryAlgorithmsPrecision temp(0.0);
						TeOverlay(box_ps, objGeom, intersect, TeINTERSECTION);
						double intersectArea = TeGeometryArea (intersect);
						totArea +=  intersectArea; // suppose objects are disjoint
		
				}
				++it;
			}
		}
	}

	double percentage = 0.0;
	if (area > 0.0) percentage = totArea/area;

	if (percentage > 0.999) percentage = 1;
	TeProperty  prop;
	prop.value_ = Te2String (percentage);
	prop.attr_.rep_.name_ = columnName;
	prop.attr_.rep_.type_ = TeREAL;
	TePropertyVector  result;
	result.push_back (prop);
	return result;
}



TePropertyVector  TeCountPolygonalObjectsStrategy::
compute (TeTheme* theme, const string& attrName, TeBox /* box */, const string& columnName)
{
	// Build stoset
	TeSTElementSet stos (theme);
	vector<string> attrNames;
	attrNames.push_back (attrName);	
	TeSTOSetBuildDB (&stos, true, false, attrNames);

	TeProperty  prop;
	prop.attr_.rep_.name_ = columnName;
	prop.attr_.rep_.type_ = TeREAL;
	prop.value_ = Te2String (stos.numElements());
	TePropertyVector  result;
	result.push_back (prop);
	return result;
}


TePropertyVector  TeCountLineObjectsStrategy::
compute (TeTheme* theme, const string& attrName, TeBox /* box */, const string& columnName)
{
	// Build stoset
	TeSTElementSet stos (theme);
	vector<string> attrNames;
	attrNames.push_back (attrName);	
	TeSTOSetBuildDB (&stos, true, false, attrNames);

	TeProperty  prop;
	prop.attr_.rep_.name_ = columnName;
	prop.attr_.rep_.type_ = TeREAL;
	prop.value_ = Te2String (stos.numElements());
	TePropertyVector  result;
	result.push_back (prop);
	return result;
}



TePropertyVector  TeCountPointObjectsStrategy::
compute (TeTheme* theme, const string& attrName, TeBox /* box */, const string& columnName)
{  
	// Build stoset
	TeSTElementSet stos (theme);
	vector<string> attrNames;
	attrNames.push_back (attrName);	
	TeSTOSetBuildDB (&stos, true, false, attrNames);

	TeProperty  prop;
	prop.attr_.rep_.name_ = columnName;
	prop.attr_.rep_.type_ = TeREAL;
	prop.value_ = Te2String (stos.numElements());
	TePropertyVector  result;
	result.push_back (prop);
	return result;
}


TePropertyVector  TeLineLengthStrategy::
compute (TeTheme* theme, const string& attrName, TeBox box, const string& columnName)
{
	double length = 0;

	// Build stoset
	TeSTElementSet stos (theme);
	vector<string> attrNames;
	attrNames.push_back (attrName);	
	if (TeSTOSetBuildDB (&stos, true, false, attrNames))
	{

		// convert input box to a polygonset
		TePolygonSet box_ps = TeBox2PolygonSet (box);

		double length = 0.0;
		TeSTElementSet::iterator it = stos.begin();
		while (it != stos.end())
		{
				TeLineSet objGeom;  
				if ((*it).getGeometry(objGeom))
				{
					TeLineSet intersect;
	//				if ((TeIntersection (area, (*it).geometry , intersect))
					TeLineSet::iterator lineIt = intersect.begin();
					while (lineIt != intersect.end())
					{
						length += TeLength (*lineIt); // suppose objects are disjoin
						lineIt++;
					}
				}
				++it;
		}
	}


	TeProperty  prop;
	prop.value_ = Te2String (length);
	TePropertyVector  result;
	prop.attr_.rep_.name_ = columnName;
	prop.attr_.rep_.type_ = TeREAL;

	result.push_back (prop);
	return result;
}



// For absolute values to be partinioned in space (e.g., population, number of malaria cases, etc.)	
TePropertyVector  TeSumWeighByAreaStrategy::
compute (TeTheme* theme, const string& attrName, TeBox box, const string& columnName)
{
	double weigh_val = 0.0;

	// Build stoset
	TeSTElementSet stos (theme);
	vector<string> attrNames;
	attrNames.push_back (attrName);	
	if (TeSTOSetBuildDB (&stos, true, false, attrNames))
	{	

		// convert input box to a polygonset
		TePolygonSet box_ps = TeBox2PolygonSet (box);
		double areaBox = TeGeometryArea(box);
		if (areaBox > 0.0)
		{
			TeSTElementSet::iterator it = stos.begin();
			while (it != stos.end())
			{
				string val;
				if ((*it).getPropertyValue (attrName, val))
				{
					double num_val = atof (val.c_str());
					TePolygonSet objGeom;  
					if ((*it).getGeometry(objGeom))
					{
						//for (unsigned int i = 0 ; i < objGeom.size(); i++)
						//		TeRemoveDuplicatedCoordinates (objGeom[i]);
						double geomArea = TeGeometryArea (objGeom);
						if (geomArea > 0.0)
						{
							TePolygonSet intersect;
							//TeGeometryAlgorithmsPrecision temp(0.0);
							TeOverlay(box_ps, objGeom, intersect, TeINTERSECTION);
							double intersectArea = TeGeometryArea (intersect);
							weigh_val += num_val*(intersectArea/geomArea); 
						
						}
					
					}
				}
				++it;
			}
		}
	}


	TeProperty  prop;
	prop.value_ = Te2String (weigh_val);
	prop.attr_.rep_.name_ = columnName;
	prop.attr_.rep_.type_ = TeREAL;

	TePropertyVector  result;
	result.push_back (prop);
	return result;
}




TePropertyVector  TeSumWeighByRestrictedAreaStrategy::
compute (TeTheme* theme, const string& attrName, TeBox box, const string& columnName)
{
	double weigh_val = 0.0;

	if (!raster_)
	{
		TeProperty  prop;
		prop.value_ = Te2String (weigh_val);
		prop.attr_.rep_.name_ = columnName;
		prop.attr_.rep_.type_ = TeREAL;
		TePropertyVector  result;
		result.push_back (prop);
		return result;
	}

	double raster_elem_area = raster_->params().resx_*raster_->params().resy_;

	// Build stoset
	TeSTElementSet stos (theme);
	vector<string> attrNames;
	attrNames.push_back (attrName);	
	if (TeSTOSetBuildDB (&stos, true, false, attrNames))
	{	
				// convert input box to a polygonset
		TePolygonSet box_ps = TeBox2PolygonSet (box);
		double areaBox = TeGeometryArea(box);
		if (areaBox > 0.0)
		{
			TeSTElementSet::iterator it = stos.begin();
			while (it != stos.end())
			{
				string val;
				if ((*it).getPropertyValue (attrName, val))
				{
					double num_val = atof (val.c_str());
					TePolygonSet objGeom;  
					if ((*it).getGeometry(objGeom))
					{
						double geomArea = TeGeometryArea (objGeom);
						if (geomArea > 0.0)
						{
							TePolygonSet intersect;
							TeOverlay(box_ps, objGeom, intersect, TeINTERSECTION);
							double raster_intersect_area = 0.0;
//							double intersec_area = TeGeometryArea (intersect);
							TePolygonSet::iterator psIt = intersect.begin();
							while (psIt != intersect.end())
							{
							
								TeRaster::iteratorPoly raster_it;
								TeRaster::iteratorPoly raster_it_end;
								raster_it = raster_->begin (box_ps.first(), TeBoxPixelIn);
								raster_it_end = raster_->end (box_ps.first(), TeBoxPixelIn);

								while 	(raster_it != raster_it_end)
								{
									int val = (int)(raster_it.operator*(band_));  // OPERADOR * POR BANDA
									if (val != 0) val = 5;
									if (classesSelection_[val] == 1)
											raster_intersect_area +=  raster_elem_area;
									++raster_it;
								}
								++psIt;
							}
							weigh_val += num_val*(raster_intersect_area/geomArea); // avarege considering cell area
						}
					}
				}
				++it;
			}
		
		}
	}


	TeProperty  prop;
	prop.value_ = Te2String (weigh_val);
	prop.attr_.rep_.name_ = columnName;
	prop.attr_.rep_.type_ = TeREAL;

	TePropertyVector  result;
	result.push_back (prop);
	return result;
}


// For relative values to be weighted in space (e.g., percentage of a given land cover in the municipality, etc.)	
TePropertyVector  TeAverageWeighByRestrictedAreaStrategy::
compute (TeTheme* theme, const string& attrName, TeBox box, const string& columnName)
{
	double weigh_val = 0.0;

	if (!raster_)
	{
		TeProperty  prop;
		prop.value_ = Te2String (weigh_val);
		prop.attr_.rep_.name_ = columnName;
		prop.attr_.rep_.type_ = TeREAL;
		TePropertyVector  result;
		result.push_back (prop);
		return result;
	}

	double raster_elem_area = raster_->params().resx_*raster_->params().resy_;

	// Build stoset
	TeSTElementSet stos (theme);
	vector<string> attrNames;
	attrNames.push_back (attrName);	
	if (TeSTOSetBuildDB (&stos, true, false, attrNames))
	{	
		// convert input box to a polygonset
		TePolygonSet box_ps = TeBox2PolygonSet (box);
		double areaBox = TeGeometryArea(box);
		if (areaBox > 0.0)
		{
			TeSTElementSet::iterator it = stos.begin();
			while (it != stos.end())
			{
				string val;
				if ((*it).getPropertyValue (attrName, val))
				{
					double num_val = atof (val.c_str());
					TePolygonSet objGeom;  
					if ((*it).getGeometry(objGeom))
					{
						double geomArea = TeGeometryArea (objGeom);
						if (geomArea > 0.0)
						{
							TePolygonSet intersect;
							TeOverlay(box_ps, objGeom, intersect, TeINTERSECTION);

							double raster_intersect_area = 0.0;
//							double intersec_area = TeGeometryArea (intersect);

							TePolygonSet::iterator psIt = intersect.begin();
							while (psIt != intersect.end())
							{
								TeRaster::iteratorPoly raster_it(raster_);
								TeRaster::iteratorPoly raster_it_end (raster_);
								raster_it = raster_->begin ((*psIt), TeBoxPixelIn);
								raster_it_end = raster_->end ((*psIt), TeBoxPixelIn);
								while 	(raster_it != raster_it_end)
								{
									int val = (int)(raster_it.operator*(band_));  // OPERADOR * POR BANDA
									if (classesSelection_[val] == 1)
										raster_intersect_area +=  raster_elem_area;
									++raster_it;
								}
								++psIt;
							}
							weigh_val += num_val*(raster_intersect_area/areaBox); // avarege considering cell area
						}
					}
				
				}
				++it;
			}
		
		}
	}


	TeProperty  prop;
	prop.value_ = Te2String (weigh_val);
	prop.attr_.rep_.name_ = columnName;
	prop.attr_.rep_.type_ = TeREAL;

	TePropertyVector  result;
	result.push_back (prop);
	return result;
}


TePropertyVector  TeMinimumDistancePolygonsStrategy::
compute (TeTheme* theme, const string& /* attrName */, TeBox box, const string& columnName)
{
	TePolygonSet ps;
	if (theme->layer()->getPolygons(ps) == false) 
	{
		TeProperty  prop;
		prop.value_ = Te2String (TeMAXFLOAT);
		prop.attr_.rep_.name_ = columnName;
		prop.attr_.rep_.type_ = TeREAL;
		TePropertyVector  result;
		result.push_back (prop);
		return result;
	}
	TeCoord2D p1 = box.center();

	TeCoord2D pinter;
	double dmin = TeMAXFLOAT;

	for (unsigned int i = 0; i < ps.size(); i++)
	{
		TePolygon p = ps[i];
		if ((p.objectId() == "913") || (p.objectId() == "898"))
		for (unsigned int j = 0; j < p.size(); j++)
		{
			TeLinearRing l = p[j];
			//if (TeOrientation (l) == TeCOUNTERCLOCKWISE) // outside polygon
				for (unsigned int k = 0; k < l.size(); k++)
				{
					double d = 	TeDistance (p1, l[k]);
					if (d < dmin) dmin = d;
				}
		}
	}
	
	TeProperty  prop;
	prop.value_ = Te2String (dmin);
	prop.attr_.rep_.name_ = columnName;
	prop.attr_.rep_.type_ = TeREAL;

	TePropertyVector  result;
	result.push_back (prop);
	return result;

}

TePropertyVector  TeMinimumDistanceLinesStrategy::
compute (TeTheme* theme, const string& /* attrName */, TeBox box, const string& columnName)
{
	TeLineSet ls;
	if (theme->layer()->getLines(ls) == false) 
	{
		TeProperty  prop;
		prop.value_ = Te2String (TeMAXFLOAT);
		prop.attr_.rep_.name_ = columnName;
		prop.attr_.rep_.type_ = TeREAL;
		TePropertyVector  result;
		result.push_back (prop);
		return result;
	}
	TeCoord2D p1 = box.center();

	int line_index;
	TeCoord2D pinter;
	double distance;

	TeProperty  prop;
	prop.value_ = Te2String (TeMAXFLOAT);
	if (TeNearest (p1, ls, line_index, pinter, distance))
		prop.value_ = Te2String (distance);


	prop.attr_.rep_.name_ = columnName;
	prop.attr_.rep_.type_ = TeREAL;

	TePropertyVector  result;
	result.push_back (prop);
	return result;

}


TePropertyVector  TeMinimumDistancePointsStrategy::
compute (TeTheme* theme, const string& /* attrName */, TeBox box, const string& columnName)
{

	TePointSet ps;
	if (theme->layer()->getPoints (ps) == false) 
	{
		TeProperty  prop;
		prop.value_ = Te2String (TeMAXFLOAT);
		prop.attr_.rep_.name_ = columnName;
		prop.attr_.rep_.type_ = TeREAL;
		TePropertyVector  result;
		result.push_back (prop);
		return result;
	}


	// if (TeGetRepresentation (layer, ls, t) == false) return false;
	TeCoord2D p1 = box.center();

	TeCoord2D pinter;

	TeProperty  prop;
	prop.value_ = Te2String (TeMAXFLOAT);
//	int i;
	double distance;
	if (TeNearest (p1, ps, pinter, distance))
//	if (TeNearest (p1, ps, i))
	{
		//double distance = TeDistance (p1, ps[i].location()); 
		prop.value_ = Te2String (distance);
	}


	prop.attr_.rep_.name_ = columnName;
	prop.attr_.rep_.type_ = TeREAL;

	TePropertyVector  result;
	result.push_back (prop);
	return result;

}



TePolygonSet
TeBox2PolygonSet (const TeBox& box)
{
	// create polygon representing each cell box
	// simplification: assume same projection

	TePolygon poly;
              
	TeCoord2D coord1 (box.x1(), box.y1());
	TeCoord2D coord2 (box.x1(), box.y2());
	TeCoord2D coord3 (box.x2(), box.y2());
	TeCoord2D coord4 (box.x2(), box.y1());
	TeCoord2D coord5 (box.x1(), box.y1());

	TeLine2D line;
	line.add(coord1);
	line.add(coord2);
	line.add(coord3);
	line.add(coord4);
	line.add(coord5);

	TeLinearRing ring(line);
	poly.add(ring);
	TePolygonSet ps;  
	ps.add (poly);
	return ps;
}


TePolygon
TeBox2Polygon (const TeBox& box)
{
	// create polygon representing each cell box
	// simplification: assume same projection

	TePolygon poly;
              
	TeCoord2D coord1 (box.x1(), box.y1());
	TeCoord2D coord2 (box.x1(), box.y2());
	TeCoord2D coord3 (box.x2(), box.y2());
	TeCoord2D coord4 (box.x2(), box.y1());
	TeCoord2D coord5 (box.x1(), box.y1());

	TeLine2D line;
	line.add(coord1);
	line.add(coord2);
	line.add(coord3);
	line.add(coord4);
	line.add(coord5);

	TeLinearRing ring(line);
	poly.add(ring);

	return poly;
}



bool TeNearest (TeCoord2D& pt,TePointSet& ps,  TeCoord2D& pout, double& dmin, const double& /* tol */)
{
	bool flag = false;

	dmin = TeMAXFLOAT;

	for (unsigned int i = 0 ; i < ps.size(); i++)
	{
		double d = 	TeDistance (pt, ps[i].location());
		if (d < dmin)
		{

			pout = ps[i].location();
			dmin = d;
			flag = true;
		}
	
	}
	return flag;
}
