#define TEAGN_ENABLE_STDOUT_LOG

#include <TePDIExamplesBase.hpp>

#include <TePDIRadarLeeFilter.hpp>
#include <TePDIRadarKuanFilter.hpp>
#include <TePDIRadarFrostFilter.hpp>

#include <TePDIParameters.hpp>
#include <TeAgnostic.h>
#include <TePDIUtils.hpp>

#include <TeInitRasterDecoders.h>

#include <TeProgress.h>
#include <TeStdIOProgress.h>

void LeeFixed_test()
{
  TePDIParameters params;

  TePDITypes::TePDIRasterPtrType inRaster( new TeRaster(
    std::string( TEPDIEXAMPLESRESPATH "cbers_b2_crop.tif" ), 'r' ) );
  TEAGN_TRUE_OR_THROW( inRaster->init(), "Unable to init inRaster" );
  params.SetParameter( "input_image", inRaster );

  TePDITypes::TePDIRasterPtrType outRaster;
  TEAGN_TRUE_OR_THROW( TePDIUtils::TeAllocRAMRaster( outRaster,
    1, 1, 1, false, TeDOUBLE, 0 ), "RAM Raster Alloc error" );
  params.SetParameter( "output_image", outRaster );

  std::vector<int> channels;
  channels.push_back( 0 );
  params.SetParameter( "channels", channels );

  params.SetParameter( "filter_type", TePDIRadarLeeFilter::TePDILeeFixedType );

  params.SetParameter( "det_type", TePDIRadarLeeFilter::TePDILeeDTLinear );

  params.SetParameter( "iterations", (int)1 );

  params.SetParameter( "mask_width", (int)3 );

  params.SetParameter( "look_number", (double)1. );

  params.SetParameter( "variance_threshold", (double)0.1 );

  TePDIRadarLeeFilter filter;

  TEAGN_TRUE_OR_THROW( filter.Reset( params ),
    "Invalid Parameters" );

  TEAGN_TRUE_OR_THROW( filter.Apply(),
    "Apply error" );

  TEAGN_TRUE_OR_THROW( TePDIUtils::TeRaster2Geotiff( outRaster,
    TEPDIEXAMPLESBINPATH "RadarLeeFixed_test.tif" ), "GeoTIF generation error" );
  
}


void LeeAdaptative_test()
{
  TePDIParameters params;

  TePDITypes::TePDIRasterPtrType inRaster( new TeRaster(
    std::string( TEPDIEXAMPLESRESPATH "cbers_b2_crop.tif" ), 'r' ) );
  TEAGN_TRUE_OR_THROW( inRaster->init(), "Unable to init inRaster" );
  params.SetParameter( "input_image", inRaster );

  TePDITypes::TePDIRasterPtrType outRaster;
  TEAGN_TRUE_OR_THROW( TePDIUtils::TeAllocRAMRaster( outRaster,
    1, 1, 1, false, TeDOUBLE, 0 ), "RAM Raster Alloc error" );
  params.SetParameter( "output_image", outRaster );

  std::vector<int> channels;
  channels.push_back( 0 );
  params.SetParameter( "channels", channels );

  params.SetParameter( "filter_type", TePDIRadarLeeFilter::TePDILeeAdaptType );

  params.SetParameter( "det_type", TePDIRadarLeeFilter::TePDILeeDTLinear );

  params.SetParameter( "iterations", (int)1 );

  params.SetParameter( "mask_width", (int)3 );

  params.SetParameter( "look_number", (double)1. );

  params.SetParameter( "variance_threshold", (double)0.1 );

  TePDIRadarLeeFilter filter;

  TEAGN_TRUE_OR_THROW( filter.Reset( params ),
    "Invalid Parameters" );

  TEAGN_TRUE_OR_THROW( filter.Apply(),
    "Apply error" );

  TEAGN_TRUE_OR_THROW( TePDIUtils::TeRaster2Geotiff( outRaster,
    TEPDIEXAMPLESBINPATH "RadarLeeAdaptative_test.tif" ), "GeoTIF generation error" );

}

void KuanFixed_test()
{
  TePDIParameters params;

  TePDITypes::TePDIRasterPtrType inRaster( new TeRaster(
    std::string( TEPDIEXAMPLESRESPATH "cbers_b2_crop.tif" ), 'r' ) );
  TEAGN_TRUE_OR_THROW( inRaster->init(), "Unable to init inRaster" );
  params.SetParameter( "input_image", inRaster );

  TePDITypes::TePDIRasterPtrType outRaster;
  TEAGN_TRUE_OR_THROW( TePDIUtils::TeAllocRAMRaster( outRaster,
    1, 1, 1, false, TeDOUBLE, 0 ), "RAM Raster Alloc error" );
  params.SetParameter( "output_image", outRaster );

  std::vector<int> channels;
  channels.push_back( 0 );
  params.SetParameter( "channels", channels );

  params.SetParameter( "filter_type", TePDIRadarKuanFilter::TePDIKuanFixedType );

  params.SetParameter( "det_type", TePDIRadarKuanFilter::TePDIKuanDTLinear );

  params.SetParameter( "iterations", (int)1 );

  params.SetParameter( "mask_width", (int)3 );

  params.SetParameter( "look_number", (double)1. );

  params.SetParameter( "variance_threshold", (double)0.1 );

  TePDIRadarKuanFilter filter;

  TEAGN_TRUE_OR_THROW( filter.Reset( params ),
    "Invalid Parameters" );

  TEAGN_TRUE_OR_THROW( filter.Apply(),
    "Apply error" );

  TEAGN_TRUE_OR_THROW( TePDIUtils::TeRaster2Geotiff( outRaster,
    TEPDIEXAMPLESBINPATH "RadarKuanFixed_test.tif" ), "GeoTIF generation error" );
    
}


void KuanAdaptative_test()
{
  TePDIParameters params;

  TePDITypes::TePDIRasterPtrType inRaster( new TeRaster(
    std::string( TEPDIEXAMPLESRESPATH "cbers_b2_crop.tif" ), 'r' ) );
  TEAGN_TRUE_OR_THROW( inRaster->init(), "Unable to init inRaster" );
  params.SetParameter( "input_image", inRaster );

  TePDITypes::TePDIRasterPtrType outRaster;
  TEAGN_TRUE_OR_THROW( TePDIUtils::TeAllocRAMRaster( outRaster,
    1, 1, 1, false, TeDOUBLE, 0 ), "RAM Raster Alloc error" );
  params.SetParameter( "output_image", outRaster );

  std::vector<int> channels;
  channels.push_back( 0 );
  params.SetParameter( "channels", channels );

  params.SetParameter( "filter_type", TePDIRadarKuanFilter::TePDIKuanAdaptType );

  params.SetParameter( "det_type", TePDIRadarKuanFilter::TePDIKuanDTLinear );

  params.SetParameter( "iterations", (int)1 );

  params.SetParameter( "mask_width", (int)3 );

  params.SetParameter( "look_number", (double)1. );

  params.SetParameter( "variance_threshold", (double)0.1 );

  TePDIRadarKuanFilter filter;

  TEAGN_TRUE_OR_THROW( filter.Reset( params ),
    "Invalid Parameters" );

  TEAGN_TRUE_OR_THROW( filter.Apply(),
    "Apply error" );

  TEAGN_TRUE_OR_THROW( TePDIUtils::TeRaster2Geotiff( outRaster,
    TEPDIEXAMPLESBINPATH "RadarKuanAdaptative_test.tif" ), "GeoTIF generation error" );

}


void Frost_test()
{
  TePDIParameters params;

  TePDITypes::TePDIRasterPtrType inRaster( new TeRaster(
    std::string( TEPDIEXAMPLESRESPATH "cbers_b2_crop.tif" ), 'r' ) );
  TEAGN_TRUE_OR_THROW( inRaster->init(), "Unable to init inRaster" );
  params.SetParameter( "input_image", inRaster );

  TePDITypes::TePDIRasterPtrType outRaster;
  TEAGN_TRUE_OR_THROW( TePDIUtils::TeAllocRAMRaster( outRaster,
    1, 1, 1, false, TeDOUBLE, 0 ), "RAM Raster Alloc error" );
  params.SetParameter( "output_image", outRaster );

  std::vector<int> channels;
  channels.push_back( 0 );
  params.SetParameter( "channels", channels );

  params.SetParameter( "det_type", TePDIRadarFrostFilter::TePDIFrostDTLinear );

  params.SetParameter( "iterations", (int)1 );

  params.SetParameter( "look_number", (double)1. );

  params.SetParameter( "variance_threshold", (double)0.1 );

  params.SetParameter( "corr_coef", (double)0.89 );

  TePDIRadarFrostFilter filter;

  TEAGN_TRUE_OR_THROW( filter.Reset( params ),
    "Invalid Parameters" );

  TEAGN_TRUE_OR_THROW( filter.Apply(),
    "Apply error" );

  TEAGN_TRUE_OR_THROW( TePDIUtils::TeRaster2Geotiff( outRaster,
    TEPDIEXAMPLESBINPATH "RadarFrost_test.tif" ), "GeoTIF generation error" );
 
}


int main()
{
  TEAGN_LOGMSG( "Test started." );

  try{
    TeStdIOProgress pi;
    TeProgress::setProgressInterf( dynamic_cast< TeProgressBase* >( &pi ) );  
  
    TeInitRasterDecoders();

    LeeFixed_test();
    LeeAdaptative_test();

    KuanFixed_test();
    KuanAdaptative_test();

    Frost_test();
  }
  catch( const TeException& e ){
    TEAGN_LOGERR( "Test Failed - " + e.message() );
    return EXIT_FAILURE;
  }  

  TEAGN_LOGMSG( "Test OK." );
  return EXIT_SUCCESS;
}
