// C++ header file partially generated from Ada using cproto.adb

extern "C" {

//----------------------------------------------------------------------------
// CONTROLS - Texttools control (widget) definitions                        --
//                                                                          --
// Developed by Ken O. Burtch                                               --
//----------------------------------------------------------------------------
//                                                                          --
//              Copyright (C) 1999-2001 PegaSoft Canada                     --
//                                                                          --
// This is free software;  you can  redistribute it  and/or modify it under --
// terms of the  GNU General Public License as published  by the Free Soft- --
// ware  Foundation;  either version 2,  or (at your option) any later ver- --
// sion.  This is distributed in the hope that it will be useful, but WITH- --
// OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
// or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
// for  more details.  You should have  received  a copy of the GNU General --
// Public License  distributed with this;  see file COPYING.  If not, write --
// to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
// MA 02111-1307, USA.                                                      --
//                                                                          --
// As a special exception,  if other files  instantiate  generics from this --
// unit, or you link  this unit with other files  to produce an executable, --
// this  unit  does not  by itself cause  the resulting  executable  to  be --
// covered  by the  GNU  General  Public  License.  This exception does not --
// however invalidate  any other reasons why  the executable file  might be --
// covered by the  GNU Public License.                                      --
//                                                                          --
// This is maintained at http://www.vaxxine.com/pegasoft                    --
//                                                                          --
//----------------------------------------------------------------------------


//-> Housekeeping

extern void startup_controls( void );
extern void idle_controls( a_time_stamp idle_period );
extern void shutdown_controls( void );

//-> Window Control Definitions
//
// A control is an object in a window that performs input/output.
// RootControl is the elementary pseudo-control.  All controls
// inherit a frame, internal cursor location, a hot key, and a status.
// There is also a NeedsRedrawing flag which indicates if the control
// dirty.
//
// Controls must support the following subprograms:
// 1. a Hear procedure which handles input and determines how
//    the dialog manager should respond (go to next control, etc.).
// 2. a Draw procedure to draw the control.  (Draw should take into
//    account the NeedsRedrawing flag, need not save colour/styles.)
// 3. an Init procedure to setup the frame, hot key (if any) and to
//    initialize any defaults. (the constructor)
// 4. Encode/Decode to save control info to a file.
// 5. SetStatus for activating the control, etc.
// 6. a Clear procedure to shutdown the control (and deallocate any
//    memory). (the destructor)
//
// All controls inherit:
// 1. an Invalid procedure to force a control to be redrawn (usually
//    when obscured by an overlapping window).
// 2. GetStatus to return the control's status.
// 3. a NeedsRedrawing function to reutnr the NeedsRedrawing flag.
// 4. Free, the unchecked deallocation procedure.
// ...and a few others.  See RootControl below.
//
// Dialog Actions:
//   None - Remain on this control
//   Next - Go to next control
//   Back - Go to control before this one
//   ScanNext - Forward to next control with key as hotkey
//          (the usual result for a key with no meaning for control)
//   Up    - move up to next control
//   Down  - move down to next control
//   Left  - move left to next control
//   Right - move right to next control
//   Complete - this control completes a dialog (simple buttons)
//   FollowLink - follow the link; open a new subwindow
//   Fix Family - turn off/redraw the radio button's family members

enum a_dialog_action {none, next, back, scan_next, up, down, left, right, complete, follow_link, fix_family};

// Control Status:
//   Off       - control will never be selected
//   Standby   - control not currently selected
//   On        - control selected and is accepting input

enum a_control_status {off, standby, on};
typedef str255 a_control_name;

//-> Control Numbers
//
// Maximum number of controls is AControlNumber'Last; 0 = no control #

typedef short a_control_number; // range 0..63

//-> Control Definitions
//
// RootControl, the elementary pseudo-control
//
// GetHotKey - return hot key for this control (or NullKey)
// SetInfo - set info bar text for this control
// GetInfo - return same
// HasInfo - true if info bar text was assigned

// forward definition of private type root_control
typedef *root_control a_control_ptr; // root_control or its child classes pointer


extern void init( root_control *c, int left, [type] top, [type] right, [type] bottom, char hot_key );
extern void finalize( root_control *c );
extern void hear( root_control *c, an_input_record i, a_dialog_action *d );
extern void move( root_control /* class-wide */ *c, int dx, [type] dy );
extern void resize( root_control *c, int dleft, [type] dtop, [type] dright, [type] dbottom );
extern void draw( root_control *c );
extern void set_status( root_control *c, a_control_status status );
extern a_control_status get_status( root_control /* class-wide */ c );
extern encoded_string encode( root_control c );
extern void decode( encoded_string *estr, root_control *c );

extern void invalid( root_control /* class-wide */ *c );
extern unsigned char needs_redrawing( root_control /* class-wide */ c );
extern char get_hot_key( root_control /* class-wide */ c );
extern void set_info( root_control /* class-wide */ *c, str255 text );
extern str255 get_info( root_control /* class-wide */ c );
extern unsigned char has_info( root_control /* class-wide */ c );
extern void get_stickyness( root_control /* class-wide */ c, unsigned char *left, [type] top, [type] right, [type] bottom );
extern void set_stickyness( root_control /* class-wide */ *c, unsigned char left, [type] top, [type] right, [type] bottom );
extern unsigned char in_control( root_control /* class-wide */ c, int x, [type] y );
extern a_rect get_frame( root_control /* class-wide */ c );
extern void scrollable( root_control /* class-wide */ *c, unsigned char b );
extern unsigned char can_scroll( root_control /* class-wide */ c );
extern void free( a_control_ptr *cp );

//-> General Classes
//
// All controls fall into one of two classes:
//
// Iconic Controls: controls that represent information or another
//                  (auto) window (if a link is provided)
//                  (eg. a picture, a static line)
//
// Gnat 2.03 bug: Compiler overlaps link with first variable in
// derived class, so links don't work!
//
// Window Controls: controls that change the environment of the current
//                  window; controls whose value can be edited/changed
//                  (eg. a checkbox, an edit list )
//

// forward declaration of private record a_null_control
// you'll need to copy the class here

// forward declaration of private record an_iconic_control
// you'll need to copy the class here
typedef *an_iconic_control an_iconic_control_ptr; // an_iconic_control or its child classes pointer


extern void init( an_iconic_control *c, int left, [type] top, [type] right, [type] bottom, char hot_key );
extern void finalize( an_iconic_control *c );
extern void draw( an_iconic_control *c );
extern void hear( an_iconic_control *c, an_input_record i, a_dialog_action *d );
extern void set_status( an_iconic_control *c, a_control_status status );
extern void resize( an_iconic_control *c, int dleft, [type] dtop, [type] dright, [type] dbottom );
extern encoded_string encode( an_iconic_control c );
extern void decode( encoded_string *estr, an_iconic_control *c );

extern void set_link( an_iconic_control /* class-wide */ *c, str255 link );
extern str255 get_link( an_iconic_control /* class-wide */ c );
extern void set_close_before_follow( an_iconic_control /* class-wide */ *c, unsigned char close = true );
extern unsigned char get_close_before_follow( an_iconic_control /* class-wide */ c );

// forward declaration of private record a_window_control
// you'll need to copy the class here
typedef *a_window_control a_window_control_ptr; // a_window_control or its child classes pointer


extern void init( a_window_control *c, int left, [type] top, [type] right, [type] bottom, char hot_key );
extern void finalize( a_window_control *c );
extern void draw( a_window_control *c );
extern void hear( a_window_control *c, an_input_record i, a_dialog_action *d );
extern void set_status( a_window_control *c, a_control_status status );
extern void resize( a_window_control *c, int dleft, [type] dtop, [type] dright, [type] dbottom );
extern encoded_string encode( a_window_control c );
extern void decode( encoded_string *estr, a_window_control *c );

//-> Thermometers
//
// SetMax - indicated the value associated with 100%
// GetMax - return same
// SetValue - set the thermometer value (0..Max)
// GetValue - return same

// forward declaration of private record a_thermometer
// you'll need to copy the class here

extern void init( a_thermometer *c, int left, [type] top, [type] right, [type] bottom, char hot_key = null_key );
extern void finalize( a_thermometer *c );
extern void hear( a_thermometer *c, an_input_record i, a_dialog_action *d );
extern void draw( a_thermometer *c );
extern void resize( a_thermometer *c, int dleft, [type] dtop, [type] dright, [type] dbottom );
extern void set_status( a_thermometer *c, a_control_status status );
extern encoded_string encode( a_thermometer c );
extern void decode( encoded_string *estr, a_thermometer *c );

extern long get_max( a_thermometer c );
extern long get_value( a_thermometer c );
extern void set_max( a_thermometer *c, long max );
extern void set_value( a_thermometer *c, long value );


//-> Scroll Bars
//
// SetMax   - set the value associated with the end of the bar
// GetMax   - return same
// SetThumb - set the position of the thumb (0...Max)
// GetThumb - return same
// SetOwner - indicate the list control associated with this bar
// GetOwner - return same

// forward declaration of private record a_scroll_bar
// you'll need to copy the class here

extern void init( a_scroll_bar *c, int left, [type] top, [type] right, [type] bottom, char hot_key = null_key );
extern void finalize( a_scroll_bar *c );
extern void hear( a_scroll_bar *c, an_input_record i, a_dialog_action *d );
extern void draw( a_scroll_bar *c );
extern void resize( a_scroll_bar *c, int dleft, [type] dtop, [type] dright, [type] dbottom );
extern void set_status( a_scroll_bar *c, a_control_status status );
extern encoded_string encode( a_scroll_bar c );
extern void decode( encoded_string *estr, a_scroll_bar *c );

extern long get_max( a_scroll_bar c );
extern long get_thumb( a_scroll_bar c );
extern void set_max( a_scroll_bar *c, long max );
extern void set_thumb( a_scroll_bar *c, long thumb );
extern void set_owner( a_scroll_bar *c, a_control_number owner );
extern a_control_number get_owner( a_scroll_bar c );


//-> Static Lines
//
// SetText - set the text of the line
// GetText - return the text of the line
// SetStyle - set the print text of the line
// GetStyle - return the print text of the line

// forward declaration of private record a_static_line
// you'll need to copy the class here
extern void init( a_static_line *c, int left, [type] top, [type] right, [type] bottom, char hot_key = null_key );
extern void finalize( a_static_line *c );
extern void hear( a_static_line *c, an_input_record i, a_dialog_action *d );
extern void draw( a_static_line *c );
extern void resize( a_static_line *c, int dleft, [type] dtop, [type] dright, [type] dbottom );
extern void set_status( a_static_line *c, a_control_status status );
extern encoded_string encode( a_static_line c );
extern void decode( encoded_string *estr, a_static_line *c );

extern str255 get_text( a_static_line c );
extern void set_text( a_static_line *c, str255 text );
extern void set_text( a_static_line *c, char * text );
extern a_text_style get_style( a_static_line c );
extern void set_style( a_static_line *c, a_text_style style );
extern a_pen_colour_name get_colour( a_static_line c );
extern void set_colour( a_static_line *c, a_pen_colour_name colour );


//-> Edit Lines, elementary edit line
//
// SetText - set the text of the edit line
// GetText - return the text of the edit line
// SetAdvanceMode - enable/disable auto advance when line is full
// GetAdvanceMode - return auto advance setting

// forward declaration of private record an_edit_line
// you'll need to copy the class here
// should be a class
typedef *an_edit_line some_edit_line; // an_edit_line or its child classes pointer


extern void finalize( an_edit_line /* class-wide */ *c );
extern void init( an_edit_line *c, int left, [type] top, [type] right, [type] bottom, unsigned int max = 0, char hot_key = null_key );
extern void hear( an_edit_line *c, an_input_record i, a_dialog_action *d );
extern void draw( an_edit_line *c );
extern void resize( an_edit_line /* class-wide */ *c, int dleft, [type] dtop, [type] dright, [type] dbottom );
extern void set_status( an_edit_line *c, a_control_status status );
extern encoded_string encode( an_edit_line c );
extern void decode( encoded_string *estr, an_edit_line *c );

extern str255 get_text( an_edit_line /* class-wide */ c );
extern void set_text( an_edit_line /* class-wide */ *c, str255 text );
extern unsigned char get_advance_mode( an_edit_line /* class-wide */ c );
extern void set_advance_mode( an_edit_line /* class-wide */ *c, unsigned char mode );
extern unsigned char get_blind_mode( an_edit_line /* class-wide */ c );
extern void set_blind_mode( an_edit_line /* class-wide */ *c, unsigned char mode );
extern int get_max_length( an_edit_line /* class-wide */ c );
extern void set_max_length( an_edit_line /* class-wide */ *c, int max_length );

//-> Integer Edit Lines
//

// forward declaration of private record an_integer_edit_line
// you'll need to copy the class here

extern void init( an_integer_edit_line *c, int left, [type] top, [type] right, [type] bottom, unsigned int max = 0, char hot_key = null_key );
extern void hear( an_integer_edit_line *c, an_input_record i, a_dialog_action *d );
extern void draw( an_integer_edit_line *c );
extern void set_status( an_integer_edit_line *c, a_control_status status );
extern encoded_string encode( an_integer_edit_line c );
extern void decode( encoded_string *estr, an_integer_edit_line *c );

extern void set_value( an_integer_edit_line *c, int value );
extern int get_value( an_integer_edit_line c );

//-> Long Integer Edit Lines
//

// forward declaration of private record a_long_int_edit_line
// you'll need to copy the class here

extern void init( a_long_int_edit_line *c, int left, [type] top, [type] right, [type] bottom, unsigned int max = 0, char hot_key = null_key );
extern void hear( a_long_int_edit_line *c, an_input_record i, a_dialog_action *d );
extern void draw( a_long_int_edit_line *c );
extern void set_status( a_long_int_edit_line *c, a_control_status status );
extern encoded_string encode( a_long_int_edit_line c );
extern void decode( encoded_string *estr, a_long_int_edit_line *c );

extern void set_value( a_long_int_edit_line *c, long value );
extern long get_value( a_long_int_edit_line c );

//-> Float Edit Lines
//

// forward declaration of private record a_float_edit_line
// you'll need to copy the class here

extern void init( a_float_edit_line *c, int left, [type] top, [type] right, [type] bottom, unsigned int max = 0, char hot_key = null_key );
extern void hear( a_float_edit_line *c, an_input_record i, a_dialog_action *d );
extern void draw( a_float_edit_line *c );
extern void set_status( a_float_edit_line *c, a_control_status status );
extern encoded_string encode( a_float_edit_line c );
extern void decode( encoded_string *estr, a_float_edit_line *c );

extern void set_value( a_float_edit_line *c, float value );
extern float get_value( a_float_edit_line c );

//-> Check Boxes
//
// SetText - set the button's message
// GetText - return the button's message
// SetCheck - check/uncheck the button
// GetCheck - return the button's check

// forward declaration of private record a_check_box
// you'll need to copy the class here

extern void init( a_check_box *c, int left, [type] top, [type] right, [type] bottom, char hot_key = null_key );
extern void finalize( a_check_box *c );
extern void hear( a_check_box *c, an_input_record i, a_dialog_action *d );
extern void draw( a_check_box *c );
extern void resize( a_check_box *c, int dleft, [type] dtop, [type] dright, [type] dbottom );
extern void set_status( a_check_box *c, a_control_status status );
extern encoded_string encode( a_check_box c );
extern void decode( encoded_string *estr, a_check_box *c );

extern str255 get_text( a_check_box c );
extern unsigned char get_check( a_check_box c );
extern void set_text( a_check_box *c, str255 text );
extern void set_check( a_check_box *c, unsigned char checked );


//-> Radio Buttons
//
// GetText - return the button's message
// SetText - set the button's message
// SetCheck - check/uncheck the radio button
// GetCheck - return the button's check
// GetFamily - the the family number of the radio button

// forward declaration of private record a_radio_button
// you'll need to copy the class here

extern void init( a_radio_button *c, int left, [type] top, [type] right, [type] bottom, int family = 0, char hot_key = null_key );
extern void finalize( a_radio_button *c );
extern void hear( a_radio_button *c, an_input_record i, a_dialog_action *d );
extern void draw( a_radio_button *c );
extern void resize( a_radio_button *c, int dleft, [type] dtop, [type] dright, [type] dbottom );
extern void set_status( a_radio_button *c, a_control_status status );
extern encoded_string encode( a_radio_button c );
extern void decode( encoded_string *estr, a_radio_button *c );

extern str255 get_text( a_radio_button c );
extern unsigned char get_check( a_radio_button c );
extern int get_family( a_radio_button c );
extern void set_text( a_radio_button *c, str255 text );
extern void set_check( a_radio_button *c, unsigned char checked );


//-> Simple Buttons
//
// SetText - set the button's message
// GetText - return the button's message

// forward declaration of private record a_simple_button
// you'll need to copy the class here

extern void init( a_simple_button *c, int left, [type] top, [type] right, [type] bottom, char hot_key = null_key );
extern void finalize( a_simple_button *c );
extern void hear( a_simple_button *c, an_input_record i, a_dialog_action *d );
extern void draw( a_simple_button *c );
extern void resize( a_simple_button *c, int dleft, [type] dtop, [type] dright, [type] dbottom );
extern void set_status( a_simple_button *c, a_control_status status );
extern encoded_string encode( a_simple_button c );
extern void decode( encoded_string *estr, a_simple_button *c );

extern str255 get_text( a_simple_button c );
extern void set_text( a_simple_button *c, str255 text );
extern void set_text( a_simple_button *c, char * text );
extern unsigned char get_instant( a_simple_button c );
extern void set_instant( a_simple_button *c, unsigned char instant = true );
extern a_pen_colour_name get_colour( a_simple_button c );
extern void set_colour( a_simple_button *c, a_pen_colour_name colour );

//-> Window Buttons
//
// SetText - set the button's message
// GetText - return the button's message
// SetLink - set the path to the window associated with this button
// GetLink - return the window path

// forward declaration of private record a_window_button
// you'll need to copy the class here

extern void init( a_window_button *c, int left, [type] top, [type] right, [type] bottom, char hot_key = null_key );
extern void finalize( a_window_button *c );
extern void hear( a_window_button *c, an_input_record i, a_dialog_action *d );
extern void draw( a_window_button *c );
extern void resize( a_window_button *c, int dleft, [type] dtop, [type] dright, [type] dbottom );
extern void set_status( a_window_button *c, a_control_status status );
extern encoded_string encode( a_window_button c );
extern void decode( encoded_string *estr, a_window_button *c );

extern void set_text( a_window_button *c, str255 text );
extern str255 get_text( a_window_button c );
extern unsigned char get_instant( a_window_button c );
extern void set_instant( a_window_button *c, unsigned char instant = true );
extern void set_control_hit( a_window_button *c, a_control_number chit );
extern a_control_number get_control_hit( a_window_button c );

//-> Rectangles
//
// SetColours - set the foreground and background colours
// GetColours - return the foreground and background colours

// forward declaration of private record a_rectangle
// you'll need to copy the class here

extern void init( a_rectangle *c, int left, [type] top, [type] right, [type] bottom, char hot_key = null_key );
extern void finalize( a_rectangle *c );
extern void hear( a_rectangle *c, an_input_record i, a_dialog_action *d );
extern void draw( a_rectangle *c );
extern void resize( a_rectangle *c, int dleft, [type] dtop, [type] dright, [type] dbottom );
extern void set_status( a_rectangle *c, a_control_status status );
extern encoded_string encode( a_rectangle c );
extern void decode( encoded_string *estr, a_rectangle *c );

extern void set_colours( a_rectangle *c, a_pen_colour_name frame_colour, [type] back_colour );
extern void get_colours( a_rectangle c, a_pen_colour_name *frame_colour, [type] back_colour );


//-> Lines
//
// SetColour - select the colour of the line
// GetColour - return the colour of the line
// SetDrawDir - DownRight => line is drawn from top-left to bottom-right
//    of the control frame, else bottom-left to top-right.
// GetDrawDir - return the drawing direction

// forward declaration of private record a_line
// you'll need to copy the class here

extern void init( a_line /* class-wide */ *c, int left, [type] top, [type] right, [type] bottom, char hot_key = null_key );
extern void finalize( a_line /* class-wide */ *c );
extern void hear( a_line /* class-wide */ *c, an_input_record i, a_dialog_action *d );
extern void draw( a_line *c );
extern void resize( a_line /* class-wide */ *c, int dleft, [type] dtop, [type] dright, [type] dbottom );
extern void set_status( a_line /* class-wide */ *c, a_control_status status );
extern encoded_string encode( a_line /* class-wide */ c );
extern void decode( encoded_string *estr, a_line /* class-wide */ *c );

extern void set_colour( a_line /* class-wide */ *c, a_pen_colour_name colour );
extern a_pen_colour_name get_colour( a_line /* class-wide */ c );
extern void set_draw_dir( a_line *c, unsigned char down_right );
extern unsigned char get_draw_dir( a_line c );

// Section Separators
//
// On Graphics Displays, centered in drawing grid appropriately

// forward declaration of private record an_horizontal_sep
// you'll need to copy the class here
extern void draw( an_horizontal_sep *c );

// forward declaration of private record a_vertical_sep
// you'll need to copy the class here
extern void draw( a_vertical_sep *c );

//-> Static Lists, the elementary static list
//
// Is the list the belongs to the control a pointer to a list, or
// a copy of a list supplied by the programmer?  A pointer makes it
// handy to read the list, but offers no protection against failure
// to inform the control to update.  I'll compromise here: SetList
// COPIES and GetList returns a pointer.
//
// that it can't be copied by assignment.
// SetList - install the text to display in the box
// SetOrigin - change top line being displayed
// GetList - return the list of text
// GetOrigin - return the origin
// GetCurrent - return line the cursor is on
// GetPosition - return the position on the line
// SetCursor - move the cursor to a specific place
// GetLength - return number of lines
// JustifyText - format text to fit within specified width
// SetScrollBar - set the scroll bar (or thermometer) to be associated
//   with this list control
// GetScrollBar - return the associated scroll bar (or 0)

// forward declaration of private record a_static_list
// you'll need to copy the class here
typedef *a_static_list some_list_control; // a_static_list or its child classes pointer


extern void init( a_static_list *c, int left, [type] top, [type] right, [type] bottom, char hot_key = null_key );
extern void finalize( a_static_list *c );
extern void hear( a_static_list *c, an_input_record i, a_dialog_action *d );
extern void draw( a_static_list *c );
extern void resize( a_static_list /* class-wide */ *c, int dleft, [type] dtop, [type] dright, [type] dbottom );
extern void set_status( a_static_list /* class-wide */ *c, a_control_status status );
extern encoded_string encode( a_static_list /* class-wide */ c );
extern void decode( encoded_string *estr, a_static_list /* class-wide */ *c );

extern void set_list( a_static_list /* class-wide */ *c, str255_list._list *list );
extern void set_origin( a_static_list /* class-wide */ *c, str255_list._alist_index origin );
extern str255_list._list get_list( a_static_list /* class-wide */ c );
extern str255_list._alist_index get_origin( a_static_list /* class-wide */ c );
extern str255_list._alist_index get_current( a_static_list /* class-wide */ c );
extern str255_list._alist_index get_length( a_static_list /* class-wide */ c );
extern void justify_text( a_static_list /* class-wide */ *c, int width, str255_list._alist_index starting_at = 0 );
extern void move_cursor( a_static_list /* class-wide */ *c, int dx, long dy );
extern void set_scroll_bar( a_static_list /* class-wide */ *c, a_control_number bar );
extern a_control_number get_scroll_bar( a_static_list /* class-wide */ c );
extern void copy_line( a_static_list /* class-wide */ *c, str255 *text );
extern void paste_line( a_static_list /* class-wide */ *c, str255 text );
extern void replace_line( a_static_list /* class-wide */ *c, str255 text );

extern void find_text( a_static_list /* class-wide */ *c, str255 str2find, unsigned char backwards, [type] is_reg_exp = false );
extern void replace_text( a_static_list /* class-wide */ *c, str255 str2find, [type] str2repl, unsigned char backwards, [type] is_reg_exp = false );
extern void set_find_phrase( a_static_list /* class-wide */ *c, str255 phrase );

extern void set_mark( a_static_list /* class-wide */ *c, long mark );
extern long get_mark( a_static_list /* class-wide */ c );
// mark position.  Use -1 to denote no mark set.

extern void copy_lines( a_static_list /* class-wide */ *c, long mark2, str255_list._list *lines );
// copy lines between mark2 and mark set with SetMark
extern void paste_lines( a_static_list /* class-wide */ *c, str255_list._list *lines );

//-> Check Lists
//
// SetChecks - install list of check boxes
// GetChecks - return pointer to list of checks

// forward declaration of private record a_check_list
// you'll need to copy the class here

extern void init( a_check_list *c, int left, [type] top, [type] right, [type] bottom, char hot_key = null_key );
extern void finalize( a_check_list *c );
extern void hear( a_check_list *c, an_input_record i, a_dialog_action *d );
extern void draw( a_check_list *c );

extern void set_checks( a_check_list *c, boolean_list._list *checks );
extern boolean_list._list get_checks( a_check_list c );


//-> Radio Lists
//
// SetChecks - install list of radio button checks + first to check
// GetChecks - return a pointer to the list of checks
// GetCheck  - return the number of the item checked

// forward declaration of private record a_radio_list
// you'll need to copy the class here

extern void init( a_radio_list *c, int left, [type] top, [type] right, [type] bottom, char hot_key = null_key );
extern void finalize( a_radio_list *c );
extern void hear( a_radio_list *c, an_input_record i, a_dialog_action *d );
extern void draw( a_radio_list *c );

extern void set_checks( a_radio_list *c, boolean_list._list *checks, boolean_list._alist_index default = 1 );
extern boolean_list._list get_checks( a_radio_list c );
extern boolean_list._alist_index get_check( a_radio_list c );


//-> Edit Lists
//
// GetPosition - get horizontal position of cursor (left side = 1)
// SetCursor - move the cursor to a specific position in the text

// forward declaration of private record an_edit_list
// you'll need to copy the class here
extern void init( an_edit_list *c, int left, [type] top, [type] right, [type] bottom, char hot_key = null_key );
extern void finalize( an_edit_list *c );
extern void hear( an_edit_list *c, an_input_record i, a_dialog_action *d );
extern void draw( an_edit_list *c );

extern int get_position( an_edit_list /* class-wide */ c );
extern void set_cursor( an_edit_list /* class-wide */ *c, int x, str255_list._alist_index y );

extern void touch( an_edit_list /* class-wide */ *c );
// set touch flag to true
extern void clear_touch( an_edit_list /* class-wide */ *c );
// set touch flag to false
extern unsigned char was_touched( an_edit_list /* class-wide */ c );
// true if Touch or received input.  Used for saving

//-> SOURCE EDIT LIST
//
// For displaying source code with hilighted keywords

// forward declaration of private record a_source_edit_list
// you'll need to copy the class here

extern void init( a_source_edit_list *c, int left, [type] top, [type] right, [type] bottom, char hot_key = null_key );
extern void finalize( a_source_edit_list *c );
extern void hear( a_source_edit_list *c, an_input_record i, a_dialog_action *d );
extern void draw( a_source_edit_list *c );

extern void add_keyword( a_source_edit_list *c, char * keyword );
// add a keyword
extern void clear_keywords( a_source_edit_list *c );
// remove all keywords

//--> UNFINISHED CONTROLS

// forward declaration of private record an_htmlbox
// you'll need to copy the class here

//-> Pictures
//
// Bit-mapped pictures.  They can double as traditional icons using the
// text description as the icon caption.  APicture is a collection of
// simple pictures optimized at different resolutions.

// forward declaration of private record a_simple_picture
// you'll need to copy the class here

// forward declaration of private record a_picture
// you'll need to copy the class here

//-> Scalable pictures
//
// Traditional "draw" object composed of scalable geometric objects, like
// lines, circles, rectangles, etc.

// forward declaration of private record a_sketch
// you'll need to copy the class here

//-> Animations
//
// A collection of objects to be displayed through a sequence of states.
// The objects can't be edited, hence an animation is iconic.

// forward declaration of private record an_animation
// you'll need to copy the class here

// forward declaration of private record a_tree_list
// you'll need to copy the class here
//dummy


class root_control : ada._finalization._controlled {
private:

a_rect frame;
// frame surrounding control
a_control_status status;
// Off / Standby / On
a_control_name name;
// name of the control
unsigned char stick_left;
// frame.left should adhere to window's left
unsigned char stick_top;
// frame.top  should adhere to window's top
unsigned char stick_right;
// frame.right should adhere to w's right
unsigned char stick_bottom;
// frame.top should adhere to w's bottom
int cursor_x;
// cursor location
int cursor_y;
unsigned char scrollable;
// true if ScrollWindow should ignore
unsigned char needs_redrawing;
// true if needs redrawing
char hot_key;
// key to jump to this item (else NullKey)
unsigned char has_info;
// true if text is valid for info bar
str255 info_text;
// string to show in info bar if hilighted

};

class a_null_control : root_control

class an_iconic_control : root_control {
private:

str255 link;
// link to another system-controlled window
unsigned char close_before_follow;
// close before following link

};

class a_window_control : root_control

class a_thermometer : a_window_control {
private:

long max;
// ranges 0..max
long value;
// current value

};

class a_scroll_bar : a_window_control {
private:

long max;
// ranges 0..Max
long thumb;
// current position
a_control_number owner;
// related control (for window manager)
// optimizations for text screen
unsigned char dirty_thumb;
// true if only thumb needs redrawing
int old_thumb;
// old drawing position for thumb

};

class a_static_line : an_iconic_control {
private:

str255 text;
// text in the static line
a_text_style style;
// the style of text (default normal)
a_pen_colour_name colour;
// colour of text

};

class an_edit_line : a_window_control {
private:

// should be a class
str255 text;
// text in the edit line
unsigned int max;
// maximum number of characters (not impl. yet)
unsigned int origin;
// offset for display if text is wider than box
unsigned char advance_mode;
// auto-advance with last character?
unsigned char blind_mode;
// true for blind text (eg. password entry)
int max_length;
// maximum number of characters
// optimzations for text screen
unsigned char dirty_text;
// if only text right of cursor needs drawing

};

class an_integer_edit_line : an_edit_line {
private:

int value;

};

class a_long_int_edit_line : an_edit_line {
private:

long value;

};

class a_float_edit_line : an_edit_line {
private:

float value;

};

class a_check_box : a_window_control {
private:

str255 text;
// message of the button
unsigned char checked;
// true if button's checked
unsigned int hot_pos;

};

class a_radio_button : a_window_control {
private:

str255 text;
// title
unsigned char checked;
// true if button is "on"
int family;
// a number to associate families
unsigned int hot_pos;

};

class a_simple_button : a_window_control {
private:

str255 text;
// message of the button
unsigned char instant;
// true if an instant selection on ScanNext
unsigned int hot_pos;
// position of hot key character
a_pen_colour_name colour;

};

class a_window_button : an_iconic_control {
private:

str255 text;
// message of the button
unsigned char instant;
// true if an instant selection on ScanNext
unsigned int hot_pos;
// position of hot key character
a_control_number chit;
// what was hit

};

class a_rectangle : an_iconic_control {
private:

a_pen_colour_name frame_colour;
// colour of the frame
a_pen_colour_name back_colour;
// colour of the background
str255 text;

};

class a_line : an_iconic_control {
private:

a_pen_colour_name colour;
// colour of the line
unsigned char down_right;
// true if line goes from top-left to b-r

};

class an_horizontal_sep : a_line

class a_vertical_sep : a_line

class a_static_list : a_window_control {
private:

str255_list._list list;
// list of text
str255_list._alist_index origin;
// line # at top of box
a_control_number scroll_bar;
// reference value for window manager
long mark;
// as set by set mark
str255 find_phrase = null_str255;
// for hilighting purposes

};

class a_check_list : a_static_list {
private:

boolean_list._list checks;
// list of selections (if any)

};

class a_radio_list : a_static_list {
private:

boolean_list._list checks;
// list of selections (if any)
long last_check;
// last selection (else 0)

};

class an_edit_list : a_static_list {
private:

unsigned char dirty_line;
// if current line is dirty
unsigned char touched = false;
// true if received input
unsigned char forward_char_search_mode = false;
// true if in mode

};

class a_source_edit_list : an_edit_list {
private:

str255_list._list keyword_list;

};

//--> UNFINISHED CONTROLS

class an_htmlbox : a_static_list {
private:


};

class a_simple_picture : an_iconic_control {
private:

a_picture_id pic;
// ID of the picture
str255 path;
// path of the picture
str255 text;
// description (if can't be displayed)

};

class a_picture : a_simple_picture {
private:

// to be defined

};

class a_sketch : an_iconic_control {
private:


};

class an_animation : an_iconic_control {
private:

int x, y;
// actually, redundant with control pos'n
int xvector, yvector;
// motion offset information
unsigned char enabled;
// actually, redundant with status
unsigned char visible;
// actually, redundant with status
short index;
// frame index
short ani_status;
// grammer status
//Stack  : AnAnimationStack;  -- the animation grammar

};

class a_tree_list : a_static_list
//dummy


}
