Attribute VB_Name = "DLPortIO"
'****************************************************************************
'*  @doc INTERNAL
'*  @module ticables.bas
'*
'*  LibTiCables, TI cables library
'*  <cp> Copyright 2001 Romain Livin<nl>
'*  All Rights Reserved.<nl>
'*  Source code released under the terms of the GPL license.
'*
'*  Win32 Prototypes for LibTiCables
'*
'*  Please report bugs to:
'*  Romain Livin
'*  E-mail: rlievin@mail.com
'*  Web: lpg.ticalc.org/prj_tilp
'*
'*  @comm
'*  Author: Roms<nl>
'*  Date:   23/11/01 14:08:58
'*
'*  @group Revision History
'*  @comm
'*  $Revision: 1 $
'*  <nl>
'*  $Log: /DLPortIO/API/DLPORTIO.BAS $
'
' 1     9/27/96 2:03p Royf
' Initial revision.
'*
'****************************************************************************

'+------------------+
'| Type definitions |
'+------------------+
Type LinkCable
    i As Integer
End Type

Type LinkParam
    CalcType As Integer
    LinkType As Integer
    IoAddr As Integer
    Device As String
    Timeout As Integer
    Delay As Integer
    Baudrate As Integer
    Hfc As Integer
    Port As Integer
    Method As Integer
End Type

Type PortInfo
    LptCount As Integer
    LptAddr As String
    LptMode As String
    LptName As String
    
    ComCount As Integer
    ComAddr As String
    ComMode As String
    ComName As String
End Type

'+---------------+
'| DLL functions |
'+---------------+

Public Declare Function TicableGetVersion Lib "libticables.dll" Alias "ticable_get_version" () As String
Public Declare Function TicableGetError Lib "libticables.dll" Alias "ticable_get_error" (ByVal ErrNum As Integer, ByVal ErrorMsg As String) As Integer

Public Declare Function TicableSetParam Lib "libticables.dll" Alias "ticable_set_param" (ByRef lp As LinkParam)
Public Declare Function TicableGetParam Lib "libticables.dll" Alias "ticable_get_param" (ByRef lp As LinkParam) As Integer
Public Declare Function TicableGetDefaultParam Lib "libticables.dll" Alias "ticable_get_default_param" (ByRef lp As LinkParam) As Integer
Public Declare Function TicableGetSupport Lib "libticables.dll" Alias "ticable_get_support" (ByVal CableType As Integer) As Integer
'Public Declare Function TicableSetCable Lib "libticables.dll" Alias "ticable_set_cable" (ByVal CableType As Integer, ByRef lc As LinkCable) as integer

Public Declare Function TicableSetTimeout Lib "libticables.dll" Alias "ticable_set_timeout" (ByVal Timeout As Integer)
Public Declare Function TicableGetTimeout Lib "libticables.dll" Alias "ticable_get_timeout" () As Integer
Public Declare Function TicableSetDelay Lib "libticables.dll" Alias "ticable_set_delay" (ByVal Delay As Integer)
Public Declare Function TicableGetDelay Lib "libticables.dll" Alias "ticable_get_delay" () As Integer
Public Declare Function TicableSetBaudrate Lib "libticables.dll" Alias "ticable_set_baudrate" (ByVal Baudrate As Integer)
Public Declare Function TicableGetBaudrate Lib "libticables.dll" Alias "ticable_get_baudrate" () As Integer
Public Declare Function TicableSetIoAddress Lib "libticables.dll" Alias "ticable_set_io_address" (ByVal IoAddr As Integer)
Public Declare Function TicableGetIoAddress Lib "libticables.dll" Alias "ticable_get_io_address" () As Integer
Public Declare Function TicableSetIoDevice Lib "libticables.dll" Alias "ticable_set_io_device" (ByVal IoDevice As String)
Public Declare Function TicableGetIoDevice Lib "libticables.dll" Alias "ticable_get_io_device" () As String
Public Declare Function TicableSetHfc Lib "libticables.dll" Alias "ticable_set_hfc" (ByVal Hfc As Integer)
Public Declare Function TicableGetHfc Lib "libticables.dll" Alias "ticable_get_hfc" () As Integer
Public Declare Function TicableSetPort Lib "libticables.dll" Alias "ticable_set_port" (ByVal Port As Integer)
Public Declare Function TicableGetPort Lib "libticables.dll" Alias "ticable_get_port" () As Integer
Public Declare Function TicableSetMethod Lib "libticables.dll" Alias "ticable_set_method" (ByVal Method As Integer)
Public Declare Function TicableGetMethod Lib "libticables.dll" Alias "ticable_get_method" () As Integer

Public Declare Function TicableDetectOs Lib "libticables.dll" Alias "ticable_detect_os" (ByRef OsType As String) As Integer
Public Declare Function TicableDetectPort Lib "libticables.dll" Alias "ticable_detect_port" (ByRef Pi As PortInfo) As Integer
Public Declare Function TicableDetectCable Lib "libticables.dll" Alias "ticable_detect_cable" (ByRef Pi As PortInfo) As Integer

'public declare function DISPLAY lib "libticables.dll" (
Public Declare Function TicableDISPLAYSettings Lib "libticables.dll" Alias "ticable_DISPLAY_settings" (ByVal op As Integer) As Integer
Public Declare Function Test1 Lib "libticables.dll" Alias "test" (ByVal s As String) As String
Public Declare Function Test2 Lib "libticables.dll" Alias "test2" (ByVal s As String) As String

Public Declare Function TicableSetCable Lib "libticables.dll" Alias "ticable_lc_set_cable" (ByVal CableType As Integer) As Integer
Public Declare Function TicableInitPort Lib "libticables.dll" Alias "ticable_lc_init_port" () As Integer
Public Declare Function TicableOpenPort Lib "libticables.dll" Alias "ticable_lc_open_port" () As Integer
Public Declare Function TicablePut Lib "libticables.dll" Alias "ticable_lc_put" (ByVal data As Byte) As Integer
Public Declare Function TicableGet Lib "libticables.dll" Alias "ticable_lc_get" (ByRef data As Byte) As Integer
Public Declare Function TicableClosePort Lib "libticables.dll" Alias "ticable_lc_close_port" () As Integer
Public Declare Function TicableTermPort Lib "libticables.dll" Alias "ticable_lc_term_port" () As Integer
Public Declare Function TicableCheckPort Lib "libticables.dll" Alias "ticable_lc_check_port" (ByRef status As Integer) As Integer
Public Declare Function TicableSetRedWirePort Lib "libticables.dll" Alias "ticable_lc_set_red_wire" (ByVal b As Byte) As Integer
Public Declare Function TicableSetWhiteWirePort Lib "libticables.dll" Alias "ticable_lc_set_white_wire" (ByVal b As Byte) As Integer
Public Declare Function TicableGetRedWirePort Lib "libticables.dll" Alias "ticable_lc_get_red_wire" () As Integer
Public Declare Function TicableGetWhiteWirePort Lib "libticables.dll" Alias "ticable_lc_get_white_wire" () As Integer
