//=======================================================================
//  mydialog.cxx - Source file for myDialog class
//  Copyright (C) 1995  Bruce E. Wampler
//
//  This program is part of the V C++ GUI Framework example programs.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  (see COPYING) along with this program; if not, write to the Free
//  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//=======================================================================

#include "mydialog.h"
#include <v/vnotice.h>

//	The following would be automatically generated by Vigr.  There
//	should be some regular algroithm for generating the #defines -
//	e.g., 2 letters from class name (md), something from the Cmd type (CB),
//	and a value to distinguish each label from aother.  The user should
//	also be able to override the default generated name.  There can be
//	some standard names such as xxBtnOK, etc.  The idea is to get some
//	good compromise for uniqueness, ease of generation, and readability.
//	Each module should have labels starting at the next 100, with the
//	top level window starting with 100.

const ItemVal mdLbl1 = 200;

const ItemVal mdFrm1 = 201;
const ItemVal mdLbl2 = 202;
const ItemVal mdCB1 = 203;
const ItemVal mdCB2 = 204;
const ItemVal mdCB3 = 205;
const ItemVal mdCB4 = 206;

const ItemVal mdFrmV1 = 207;
const ItemVal mdLbl3 = 208;
const ItemVal mdRB1 = 209;
const ItemVal mdRB2 = 210;
const ItemVal mdRB3 = 211;

const ItemVal mdFrmV2 = 212;
const ItemVal mdLbl4 = 213;
const ItemVal mdBtn1 = 214;
const ItemVal mdBtn2 = 215;
const ItemVal mdBtn3 = 216;

const ItemVal mdBtnTog = 217;
const ItemVal mdBtnChange = 218;

    static char change_me[] = "Change Me A";	// a label to change

// This would also be automatically generated by Vigr. One of the functions
// of Vigr is to allow the user to specify types and positions of Cmds in the
// dialogs.
//
    static DialogCmd DefaultCmds[] =
      {
	{C_Label, mdLbl1, 0,"X",NoList,CA_MainMsg,isSens,NoFrame, 0, 0},

	// This demonstrates an alternate way to label a frame
	{C_Frame, mdFrm1, 0, "", NoList, CA_None, isSens, NoFrame, 0, mdLbl1},
	{C_Label, mdLbl2, 0, "CheckBox", NoList, CA_None, isSens, mdFrm1, 0, 0},
	{C_CheckBox, mdCB1, 0, "Test A", NoList, CA_None, isSens, mdFrm1, 0, mdLbl2},
	{C_CheckBox, mdCB2, 0, "Test B", NoList, CA_None, isSens, mdFrm1, mdCB1, mdLbl2},
	{C_CheckBox, mdCB3, 1, "Test C", NoList, CA_None, isSens, mdFrm1, 0, mdCB1},
	{C_CheckBox, mdCB4, 1, "Test D", NoList, CA_None, isSens, mdFrm1, 0, mdCB3},

	{C_Frame, mdFrmV1, 0, "", NoList,CA_None,isSens,NoFrame, mdFrm1, mdLbl1},
	{C_Label, mdLbl3, 0, "Radios", NoList, CA_None, isSens, mdFrmV1, 0, 0},
	{C_RadioButton, mdRB1, 1, "KOB", NoList,CA_None,isSens, mdFrmV1, 0, mdLbl3},
	{C_RadioButton, mdRB2, 0, "KOAT", NoList, CA_None, isSens, mdFrmV1, 0, mdRB1},
	{C_RadioButton, mdRB3, 0, "KRQE", NoList, CA_None, isSens, mdFrmV1, 0, mdRB2},

	{C_Frame, mdFrmV2, 0, "", NoList,CA_None,isSens,NoFrame, mdFrmV1, mdLbl1},
	{C_Label, mdLbl4, 0, "Buttons", NoList, CA_None, isSens, mdFrmV2, 0, 0},
	{C_Button, mdBtn1, mdBtn1, "Button 1", NoList, CA_None, isSens, mdFrmV2, 0, mdLbl4},
	{C_Button, mdBtn2, mdBtn2, "Button 2", NoList, CA_None, isSens, mdFrmV2, 0, mdBtn1},
	{C_Button, mdBtn3, mdBtn3, "Button 3", NoList, CA_None, isSens, mdFrmV2, 0, mdBtn2},

	{C_Button, mdBtnTog, 0, "Toggle Sensitive", NoList, CA_None,
	    isSens, NoFrame, 0, mdFrmV1},
	{C_Button, mdBtnChange, 0, change_me, NoList, CA_None,
	    isSens, NoFrame, mdBtnTog, mdFrmV1},
	{C_Button, M_Cancel, M_Cancel," Cancel ",NoList,CA_None,
	    isSens,NoFrame,mdBtnChange, mdFrmV1},
	{C_Button, M_OK, M_OK, " OK ", NoList, CA_DefaultButton, 
	    isSens, NoFrame, M_Cancel, mdFrmV1},

	{C_EndOfList,0,0,0,0,CA_None,0,0,0}
      };


//=========================>>> myDialog::myDialog <<<====================
  myDialog::myDialog(vBaseWindow* bw, char* title) :
    vDialog(bw, 0, title)
  {
    UserDebug(Constructor,"myDialog::myDialog()\n")

    _toggleId = mdFrm1;		// Start with first item

    AddDialogCmds(DefaultCmds);		// add the predefined commands
  }

//========================>>> myDialog::~myDialog <<<====================
  myDialog::~myDialog()
  {
    UserDebug(Destructor,"myDialog::~myDialog() destructor\n")
  }

//====================>>> myDialog::DialogCommand <<<=======================
  void myDialog::DialogCommand(ItemVal id, ItemVal retval, CmdType ctype)
  {
    // After the user has selected a command from the dialog,
    // this routine is called with the value.  This code would be generated
    // by Vigr.

    vNoticeDialog note(this);

    UserDebug2(CmdEvents,"myDialog::DialogCommand(id:%d, val:%d)\n",id, retval)

    switch (id)		// We will do some things depending on value
      {
	case mdCB1:		// CheckBox
	  {
	    note.Notice("Test A");
	    break;
	  }

	case mdCB2:		// CheckBox
	  {
	    note.Notice("Test B");
	    break;
	  }

	case mdCB3:		// CheckBox
	  {
	    note.Notice("Test C");
	    break;
	  }

	case mdRB1:		// Radio Button
	  {
	    note.Notice("KOB");
	    break;
	  }

	case mdRB2:		// Radio Button
	  {
	    note.Notice("KOAT");
	    break;
	  }

	case mdRB3:		// Radio Button
	  {
	    note.Notice("KRQE");
	    break;
	  }

	case mdBtn1:		// Button
	  {
	    note.Notice("Button 1");
	    break;
	  }

	case mdBtn2:		// Button
	  {
	    note.Notice("Button 2");
	    break;
	  }

	case mdBtn3:		// Button
	  {
	    note.Notice("Button 3");
	    break;
	  }

	case mdBtnTog:		// Toggle sensitive of some objects
	  {
//	    note.Notice("Toggle Button");

	    // We will toggle the sensitive of each item in the dialog
	    SetValue(_toggleId, 1, Sensitive);

	    // First, set the current item to 0

	    // up the counter for the next item
	    if (++_toggleId > mdBtn3)
		_toggleId  = mdFrm1;		// reStart with first item

	    // Now, set the new current item insensitive
	    SetValue(_toggleId, 0, Sensitive);

	    break;
	  }

	case mdBtnChange:		// Change my own label
	  {
//	    note.Notice("Change Me A");

	    // We will change the label on this button
	    change_me[10]++;		// change the "A"
	    SetString(mdBtnChange, change_me);
	    break;
	  }

      }
    // All commands should also route through the parent handler
    vDialog::DialogCommand(id,retval,ctype);
  }
