.TH "ZIP_FOPEN_ENCRYPTED" "3" "December 18, 2017" "NiH" "Library Functions Manual"
.nh
.if n .ad l
.SH "NAME"
\fBzip_fopen_encrypted\fR,
\fBzip_fopen_index_encrypted\fR
\- open encrypted file in zip archive for reading
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
\fB#include <zip.h>\fR
.sp
\fIzip_file_t *\fR
.br
.PD 0
.HP 4n
\fBzip_fopen_encrypted\fR(\fIzip_t\ *archive\fR, \fIconst\ char\ *fname\fR, \fIzip_flags_t\ flags\fR, \fIconst\ char\ *password\fR);
.PD
.PP
\fIzip_file_t *\fR
.br
.PD 0
.HP 4n
\fBzip_fopen_index_encrypted\fR(\fIzip_t\ *archive\fR, \fIzip_uint64_t\ index\fR, \fIzip_flags_t\ flags\fR, \fIconst\ char\ *password\fR);
.PD
.SH "DESCRIPTION"
The
\fBzip_fopen_encrypted\fR()
function opens the encrypted file name
\fIfname\fR
in
\fIarchive\fR
using the password given in the
\fIpassword\fR
argument.
The
\fIflags\fR
argument are the same as for
zip_fopen(3).
.PP
The
\fBzip_fopen_index_encrypted\fR()
function opens the file at position
\fIindex\fR,
see
zip_fopen_index(3).
These functions are called automatically by
zip_fopen(3);
you only need to call them if you want to specify a non-default password
(see
zip_set_default_password(3)).
.SH "RETURN VALUES"
Upon successful completion, a
\fIstruct zip_file\fR
pointer is returned.
Otherwise,
\fRNULL\fR
is returned and the error code in
\fIarchive\fR
is set to indicate the error.
.SH "ERRORS"
.TP 22n
[\fRZIP_ER_NOPASSWD\fR]
No password was provided.
.PP
The function
\fBzip_fopen_encrypted\fR()
may also fail and set
\fIzip_err\fR
for any of the errors specified for the routine
zip_fopen(3).
.PP
The function
\fBzip_fopen_index_encrypted\fR()
may also fail and set
\fIzip_err\fR
for any of the errors specified for the routine
zip_fopen_index(3).
.SH "SEE ALSO"
libzip(3),
zip_fclose(3),
zip_fopen(3),
zip_fread(3),
zip_get_num_entries(3),
zip_name_locate(3)
.SH "HISTORY"
\fBzip_fopen_encrypted\fR()
and
\fBzip_fopen_index_encrypted\fR()
were added in libzip 1.0.
.SH "AUTHORS"
Dieter Baron <\fIdillo@nih.at\fR>
and
Thomas Klausner <\fItk@giga.or.at\fR>
