/***************************************************************************
 *
 * This file is covered by a dual licence. You can choose whether you
 * want to use it according to the terms of the GNU GPL version 2, or
 * under the terms of Zorp Professional Firewall System EULA located
 * on the Zorp installation CD.
 *
 * $Id: sockaddr.h,v 1.19 2004/02/17 16:08:04 bazsi Exp $
 *
 ***************************************************************************/

#ifndef ZORP_SOCKADDR_H_INCLUDED
#define ZORP_SOCKADDR_H_INCLUDED

#include <zorp/zorplib.h>

#include <sys/types.h>
#ifdef HAVE_UNISTD_H
  #include <unistd.h>
#endif
#include <errno.h>
#include <sys/types.h>

#ifdef G_OS_WIN32
#  include <winsock2.h>
#  define socklen_t int
#else
#  include <sys/socket.h>
#  include <sys/un.h>
#  include <netinet/in.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

#define MAX_SOCKADDR_STRING	128

/* sockaddr public interface */

#define ZSA_LOCAL		0x0001 /* within host */

typedef struct _ZSockAddrFuncs ZSockAddrFuncs;

typedef struct _ZSockAddr
{
  gint refcnt;
  guint32 flags;
  ZSockAddrFuncs *sa_funcs;
  int salen;
  struct sockaddr sa;
} ZSockAddr;

struct _ZSockAddrFuncs 
{
  GIOStatus (*sa_bind_prepare)   (int sock, ZSockAddr *addr, guint32 sock_flags);
  GIOStatus (*sa_bind)		(int sock, ZSockAddr *addr, guint32 sock_flags);
  ZSockAddr *(*sa_clone)        (ZSockAddr *addr, gboolean wildcard_clone);
  gchar   *(*sa_format)         (ZSockAddr *addr,   /* format to text form */
  				 gchar *text,
  				 gulong n);
  void     (*freefn)            (ZSockAddr *addr);
};

ZSockAddr *z_sockaddr_new(struct sockaddr *sa, int salen);
ZSockAddr *z_sockaddr_new_copy(struct sockaddr *sa, int salen);
gchar *z_sockaddr_format(ZSockAddr *a, gchar *text, gulong n);
ZSockAddr *z_sockaddr_ref(ZSockAddr *a);
void z_sockaddr_unref(ZSockAddr *a);

ZSockAddr *z_sockaddr_inet_new(const gchar *ip, guint16 port);
ZSockAddr *z_sockaddr_inet_new2(struct sockaddr_in *sinaddr);
ZSockAddr *z_sockaddr_inet_range_new(const gchar *ip, guint16 min_port, guint16 max_port);

guint z_sockaddr_inet_get_address(ZSockAddr *s);
guint z_sockaddr_inet_get_port(ZSockAddr *s);
gboolean z_sockaddr_inet_check(ZSockAddr *s);

#if ZORPLIB_ENABLE_IPOPTIONS
void z_sockaddr_inet_get_options(ZSockAddr *s, gpointer *options, guint *options_length);
void z_sockaddr_inet_set_options(ZSockAddr *s, gpointer options, guint options_length);
#endif

#ifndef G_OS_WIN32
ZSockAddr *z_sockaddr_unix_new(const gchar *name);
ZSockAddr *z_sockaddr_unix_new2(struct sockaddr_un *s_un, int sunlen);
#endif

static inline ZSockAddr *
z_sockaddr_clone(ZSockAddr *addr, gboolean wildcard_clone)
{
  return addr->sa_funcs->sa_clone(addr, wildcard_clone);
}

gchar *z_inet_ntoa(gchar *buf, size_t bufsize, struct in_addr a);
gboolean z_inet_aton(const gchar *buf, struct in_addr *a);

#ifdef __cplusplus
}
#endif

#endif
