/*
 * memory_mod.c -- Trivial module for reading simple, memory files
 *
 * Copyright (c) 1997 by Roman Hodek <Roman.Hodek@informatik.uni-erlangen.de>
 * Modified by Nick Holgate to support memory file I/O.
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file COPYING in the main directory of this archive
 * for more details.
 */

#include "defs.h"

/***************************** Prototypes *****************************/

static int mod_memory_open( void *data, long count );
static long mod_memory_fillbuf( void *buf );
static int mod_memory_skip( long cnt );
static int mod_memory_close( void );

/************************* End of Prototypes **************************/

#define MAXBUF	(32*1024)

/* definition of the module structure */
MODULE memory_mod = {
	"memory",					/* name					*/
	MAXBUF,						/* maxbuf (arbitrary)	*/
	mod_memory_open,
	mod_memory_fillbuf,
	mod_memory_skip,
	mod_memory_close,
	MOD_REST_INIT
};

/*--------------------------------------------------------------------------*/

static	long	f_size;
static	long	f_pos;
static	char	*f_data;

/*--------------------------------------------------------------------------*/

static
int
mod_memory_open
(	void	*data,
	long	count
)
{
	f_pos  = 0;
	f_size = count;
	f_data = data;

	return SUCCESS;
}

/*--------------------------------------------------------------------------*/

static
long
mod_memory_fillbuf
(	void	*buf
)
{	long	count = MAXBUF;
	long	left;

	if (f_pos == f_size)
	{
		/* EOF */
		return -1;
	}

	if (count > (left = f_size - f_pos))
	{
		count = left;
	}

	mem_move(buf, f_data + f_pos, count);

	f_pos += count;
	return count;
}

/*--------------------------------------------------------------------------*/

static
int
mod_memory_skip
(	long	cnt
)
{
	cnt += f_pos;

	/* only allow seek within extents of file */
    if (cnt < 0 || cnt > f_size)
    {
		return -1;
	}

	f_pos = cnt;

    return cnt;
}

/*--------------------------------------------------------------------------*/

static
int
mod_memory_close
(	void
)
{
	return 0;
}

/*-----------------------------< end of file >------------------------------*/
