/*
Magpie - reference librarian for Debian systems
Copyright (C) 2000  Bear Giles <bgiles@coyotesong.com>

This program is free software; you may redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the license, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

static const char rcsid[] = "$Id$";

/*****
This module lists all packages, sorted by md5sum.
*****/
#include <assert.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include "magpie.h"

#include "parser.h"

extern int mkdir (const char *, mode_t);

#define OUTPUT_FILE	"md5sums.html"


/*+
Comparison function for sorting by package md5sum.
It serves as a "knock on the side of the head" - what other fields
could be used for the sort?  What information would that provide?
+*/
static int cmp_md5sum (const void *p, const void *q)
{
	struct package_info *pp = *((struct package_info **) p);
	struct package_info *qq = *((struct package_info **) q);

	if (!pp->md5sum)
		return 1;
	if (!qq->md5sum)
		return -1;

	return strcmp (pp->md5sum, qq->md5sum);
}
	

/*+
+*/
static int md5sums_init (void)
{
	int i;
	FILE *fp;
	struct package_info *p;

	qsort (cache, cachecnt, sizeof (cache[0]), cmp_md5sum);

	fp = fopen (OUTPUT_FILE, "w");
	mp_doc_open (fp, "All Packages Sorted by MD5 Checksum");

	mp_abstract (fp, "\
This is a list of packages ordered by MD5 checksum.  It serves no real\n\
purpose.");

	mp_list_open (fp);
	for (i = 0; i < cachecnt; i++) {
		p = cache[i];
		mp_package (fp, p, 2, T_MD5SUM);
	}
	mp_list_close (fp);
	mp_doc_close (fp);
	fclose (fp);

	gzip (OUTPUT_FILE);

	return 0;
}


/*+
Print the *tasks* packages ordered by name.
+*/
static int md5sums_index (FILE *fp, int type)
{
	if (type != MAGPIE_ALL_PACKAGES)
		return 0;

	mp_item_open (fp); 
	mp_url (fp, "%s.gz", "Ordered by MD5 checksum", 
		OUTPUT_FILE);
	mp_item_close (fp); 

	return 0;
}


struct magpie_module mod_md5sums = { 
	version           : MAGPIE_VERSION,
	description       : "group packages by package md5sums",
	init              : md5sums_init,
	unannotated_index : md5sums_index
};
