%{
/*
Magpie - reference librarian for Debian systems
Copyright (C) 2000  Bear Giles <bgiles@coyotesong.com>

This program is free software; you may redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the license, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

static const char rcsid[] = "$Id$";

/*****
This file contains a list of all recognized tags. 
*****/
#include "parser.h"
%}
struct tags { char *name; int value; };
%%
Package,		T_PACKAGE
Priority,		T_PRIORITY
Section,		T_SECTION
Version,		T_VERSION
Depends,		T_DEPENDS
Recommends,		T_RECOMMENDS
Maintainer,		T_MAINTAINER
Suggests,		T_SUGGESTS
Architecture,	T_ARCHITECTURE
Filename,		T_FILENAME
Conflicts,		T_CONFLICTS
Size,			T_SIZE
MD5sum,			T_MD5SUM
Description,	T_DESCRIPTION
Provides,		T_PROVIDES
Replaces,		T_REPLACES,
Essential,		T_ESSENTIAL,
Pre-Depends,	T_PREDEPENDS,
Installed-Size,	T_INSTALLED_SIZE
Source,			T_SOURCE
Status,			T_STATUS
Conffiles,		T_CONFFILES
Config-Version,	T_CONFIG_VERSION
installed-size,	T_INSTALLED_SIZE
source,			T_SOURCE
%%

const struct tags * lookup_tag (const char *str, unsigned int len)
{
	return in_word_set_tags (str, len);
}
