%{
/*
Magpie - reference librarian for Debian systems
Copyright (C) 2000  Bear Giles <bgiles@coyotesong.com>

This program is free software; you may redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the license, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

static const char rcsid[] = "$Id$";

/*****
This file contains a list of all recognized tokens.  More precisely,
the tokens that are formalized.
*****/
#include <stdio.h>
#include "parser.h"

#define T_CATEGORY T_SECTION
%}
struct tokens { char *name; int token; int value; };
%%
yes,			T_ESSENTIAL,	T_TRUE
no,				T_ESSENTIAL,	T_FALSE
required,		T_PRIORITY,		T_REQUIRED
important,		T_PRIORITY,		T_IMPORTANT
standard,		T_PRIORITY,		T_STANDARD
optional,		T_PRIORITY,		T_OPTIONAL
extra,			T_PRIORITY,		T_EXTRA
main,			T_SECTION,		T_MAIN
contrib,		T_SECTION,		T_CONTRIB
non-free,		T_SECTION,		T_NON_FREE
non-us,			T_SECTION,		T_NON_US
non-US,			T_SECTION,		T_NON_US
local,			T_SECTION,		T_LOCAL
affinity,		T_SECTION,		T_AFFINITY
alien,			T_SECTION,		T_ALIEN
unknown,		T_SECTION,		T_UNKNOWN
admin,			T_CATEGORY,		T_ADMIN
base,			T_CATEGORY,		T_BASE
comm,			T_CATEGORY,		T_COMM
devel,			T_CATEGORY,		T_DEVEL
doc,			T_CATEGORY,		T_DOC
editors,		T_CATEGORY,		T_EDITORS
electronics,	T_CATEGORY,		T_ELECTRONICS
games,			T_CATEGORY,		T_GAMES
graphics,		T_CATEGORY,		T_GRAPHICS
hamradio,		T_CATEGORY,		T_HAMRADIO
interpreters,	T_CATEGORY,		T_INTERPRETERS
libs,			T_CATEGORY,		T_LIBS
mail,			T_CATEGORY,		T_MAIL
math,			T_CATEGORY,		T_MATH
misc,			T_CATEGORY,		T_MISC
net,			T_CATEGORY,		T_NET
news,			T_CATEGORY,		T_NEWS
oldlibs,		T_CATEGORY,		T_OLDLIBS
otherosfs,		T_CATEGORY,		T_OTHEROSFS
shells,			T_CATEGORY,		T_SHELLS
sound,			T_CATEGORY,		T_SOUND
tex,			T_CATEGORY,		T_TEX
text,			T_CATEGORY,		T_TEXT
utils,			T_CATEGORY,		T_UTILS
web,			T_CATEGORY,		T_WEB
x11,			T_CATEGORY,		T_X11
science,		T_CATEGORY,		T_SCIENCE
stormbas,		T_CATEGORY,		T_STORMBASE
storm-sas,		T_CATEGORY,		T_STORMSAS
all,			T_ARCHITECTURE,	T_ALL
alpha,			T_ARCHITECTURE,	T_ALPHA
arm,			T_ARCHITECTURE,	T_ARM
hurd-i386,		T_ARCHITECTURE,	T_HURD_I386
i386,			T_ARCHITECTURE,	T_I386
m68k,			T_ARCHITECTURE,	T_M68K
powerpc,		T_ARCHITECTURE,	T_POWERPC
sparc,			T_ARCHITECTURE,	T_SPARC
yes,			T_ESSENTIAL,	T_TRUE
no,				T_ESSENTIAL,	T_FALSE
%%

const struct tokens * lookup_token (const char *str, unsigned int len, int token)
{
	const struct tokens *t = in_word_set_tokens (str, len);
	return (t != NULL && t->token == token) ? t : NULL;
}
