/* This file is part of Malaga, a system for Natural Language Analysis.
 * Copyright (C) 1995-1999 Bjoern Beutel
 *
 * Bjoern Beutel
 * Universitaet Erlangen-Nuernberg
 * Abteilung fuer Computerlinguistik
 * Bismarckstrasse 12
 * D-91054 Erlangen
 * e-mail: malaga@linguistik.uni-erlangen.de 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

/* description ==============================================================*/

/* This module contains function to compile and execute pattern matching 
 * strings. */

/* constants ================================================================*/

#define PATTERN_VAR_MAX 5 /* maximum number of pattern variables */

/* variables ================================================================*/

GLOBAL string_t pattern_var[PATTERN_VAR_MAX]; /* pattern variables */

/* functions ================================================================*/

extern string_t compile_pattern (string_t string, int_t pattern_var_no);
/* Convert <string> to a pattern to be used as input to "match_pattern".
 * If <pattern_var_no> != -1, mark the pattern so the string matching this
 * pattern will be stored in <pattern_var[pattern_var_no]>.
 * The result pattern must be freed with "free" after usage. */

extern bool_t match_pattern (string_t string, string_t pattern);
/* Test whether <string> matches <pattern> (a string of chars compiled with
 * "compile_pattern") and set substring indices in <pattern_var>.
 * The substrings remain valid till "compile_pattern" is called again. */

/* end of file ==============================================================*/
