/* This file is part of Malaga, a system for Natural Language Analysis.
 * Copyright (C) 1995-1999 Bjoern Beutel
 *
 * Bjoern Beutel
 * Universitaet Erlangen-Nuernberg
 * Abteilung fuer Computerlinguistik
 * Bismarckstrasse 12
 * D-91054 Erlangen
 * e-mail: malaga@linguistik.uni-erlangen.de 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

/* description ==============================================================*/

/* This module manages the symbol table for constants, variables and rules. */

/* functions that use the symbol table for rules and functions ==============*/

extern int_t enter_rule (string_t name, 
			 int_t first_instr, 
			 rule_type_t type, 
			 int_t num_params);
/* Enter rule <name> of <type> that starts at <first_instr> into the
 * symbol table. The rule number will be returned. */

extern void enter_function (string_t name, int_t index);
/* Associate standard function <name> with <index>. */

extern rule_t *find_rule_or_function (string_t name, int_t *rule_number);
/* Find rule <name> and return its rule descriptor.
 * If <rule_number> != NULL, save its rule index in <*rule_number>.
 * If the rule descriptor is NULL, the name describes a standard function. */

extern void check_rules_defined (void);
/* Check if all rules in the symbol tree are defined. */

/* functions that use the symbol table for variables ========================*/

extern int_t find_variable (string_t name);
/* Find variable <name> in the symbol table and return its stack index. */

extern string_t define_variable (string_t name, int_t stack_index);
/* Define the value on index <stack_index> to be a new variable
 * and return a copy of its name in the string pool. */

extern void undefine_variable (string_t name);
/* Close the scope of variable <name>. */

extern void dump_variables (void);
/* Dump all variables and variables scopes in the table. */

/* functions that use the symbol table for constants ========================*/

extern int_t find_constant (string_t name);
/* Find constant <name> in the symbol table and return its value pool index. */

extern void define_constant (string_t name, int_t const_index);
/* Define constant <name> with value at <const_index> in the value pool. */

extern void free_symbols (void);
/* Free all memory used by the symbol table. */

/* end of file ==============================================================*/
