/*
                   Manual Page Editor: Configuration
 */

#ifndef CONFIG_H
#define CONFIG_H

#ifndef PREFIX
# define PREFIX	"/usr"
#endif


/*
 *      Languages (define only one):
 */
#define PROG_LANGUAGE_ENGLISH   1
/* #define PROG_LANGUAGE_SPANISH        2 */
/* #define PROG_LANGUAGE_FRENCH         3 */
/* incomplete #define PROG_LANGUAGE_GERMAN      4 */
/* incomplete #define PROG_LANGUAGE_ITALIAN     5 */
/* incomplete #define PROG_LANGUAGE_NORWEGIAN   6 */
/* incomplete #define PROG_LANGUAGE_PORTUGUESE  7 */


/*
 *	Syntax highlighting enabled by default (TRUE or FALSE)?
 */
#define MEDIT_DEF_SYNTAX_HIGHLIGHTING	FALSE

/*
 *	ManEdit local configuration file:
 *
 *	User's home directory will be prepended.
 */
#define MEDIT_RCFILE_LOCAL	".maneditrc"


/*
 *	ManEdit global directory:
 */
#define MEDIT_GLOBAL_DIR	(PREFIX "/share/manedit")

/*
 *	Manual page help sub directory (MEDIT_GLOBAL_DIR will
 *      be prepended at run time):
 */
#define MEDIT_HELP_DIR		"help"

/*
 *	Manual page templates sub directory (MEDIT_GLOBAL_DIR will
 *	be prepended at run time):
 */
#define MEDIT_TEMPLATES_DIR	"templates"


/*
 *	Help files, located in MEDIT_GLOBAL_DIR/MEDIT_HELP_DIR:
 */
#define MEDIT_MANPAGE_WRITING_FILE		"manpage_writing_procedures"
#define MEDIT_MANPAGE_XML_REFERANCE_FILE	"manpage_xml_referance"


/*
 *	Fond specification format strings:
 */
#define MEDIT_FONT_NAME_HEADING1	\
	"-adobe-helvetica-medium-r-normal-*-24-*-*-*-p-*-iso8859-1"
#define MEDIT_FONT_NAME_HEADING2	\
	"-adobe-helvetica-medium-r-normal-*-20-*-*-*-p-*-iso8859-1"
#define MEDIT_FONT_NAME_HEADING3	\
	"-adobe-helvetica-medium-r-normal-*-18-*-*-*-p-*-iso8859-1"
#define MEDIT_FONT_NAME_HEADING4	\
	"-adobe-helvetica-medium-r-normal-*-16-*-*-*-p-*-iso8859-1"
#define MEDIT_FONT_NAME_HEADING5	\
	"-adobe-helvetica-medium-r-normal-*-14-*-*-*-p-*-iso8859-1"
#define MEDIT_FONT_NAME_HEADING6	\
	"-adobe-helvetica-medium-r-normal-*-12-*-*-*-p-*-iso8859-1"

#define MEDIT_FONT_NAME_HEADING1_REV	\
	"-adobe-helvetica-medium-r-normal-*-24-*-*-*-p-*-iso8859-1"
#define MEDIT_FONT_NAME_HEADING2_REV	\
        "-adobe-helvetica-medium-r-normal-*-20-*-*-*-p-*-iso8859-1"
#define MEDIT_FONT_NAME_HEADING3_REV	\
        "-adobe-helvetica-medium-r-normal-*-18-*-*-*-p-*-iso8859-1"
#define MEDIT_FONT_NAME_HEADING4_REV	\
	"-adobe-helvetica-medium-r-normal-*-16-*-*-*-p-*-iso8859-1"

#define MEDIT_FONT_NAME_EDIT_STD	\
	"-adobe-courier-medium-r-*-*-14-*-*-*-*-*-*-*"

#define MEDIT_FONT_NAME_MANPAGE_STD	\
        "-adobe-courier-medium-r-*-*-14-*-*-*-*-*-*-*"
#define MEDIT_FONT_NAME_MANPAGE_BOLD	\
	"-adobe-courier-medium-r-*-*-14-*-*-*-*-*-*-*"
#define MEDIT_FONT_NAME_MANPAGE_UNDERLINE	\
        "-adobe-courier-medium-r-*-*-14-*-*-*-*-*-*-*"


/*
 *	Clist and ctree row spacing (in pixels):
 */
#define MEDIT_LIST_ROW_SPACING	20

/*
 *	Color strings:
 */
#define MEDIT_CSTR_EDIT_TEXT_FG		"black"
#define MEDIT_CSTR_EDIT_TEXT_BG		"white"
#define MEDIT_CSTR_EDIT_TEXT_DELIM_FG	"#a000a0"
#define MEDIT_CSTR_EDIT_TEXT_TAG_FG	"#0040a0"
#define MEDIT_CSTR_EDIT_TEXT_SYMREP_FG	"#a04000"

#define MEDIT_CSTR_MANPAGE_TEXT_FG		"black"
#define MEDIT_CSTR_MANPAGE_TEXT_BG		"#ffffc0"
#define MEDIT_CSTR_MANPAGE_TEXT_BOLD_FG		"black"
#define MEDIT_CSTR_MANPAGE_TEXT_UNDERLINE_FG	"black"


/*
 *      Drag and drop target type names and info values:
 */
#define MEDIT_DND_TYPE_INFO_TEXT_PLAIN		0	/* "text/plain" */
#define MEDIT_DND_TYPE_INFO_TEXT_URI_LIST	1	/* "text/uri-list" */
#define MEDIT_DND_TYPE_INFO_STRING		2	/* "STRING" */

#define MEDIT_DND_TYPE_INFO_EDITOR_BRANCH_CMD	3
#define MEDIT_DND_TYPE_NAME_EDITOR_BRANCH_CMD	"manedit/editor/branch"
#define MEDIT_DND_TYPE_INFO_VIEWER_BRANCH_CMD	4
#define MEDIT_DND_TYPE_NAME_VIEWER_BRANCH_CMD	"manedit/viewer/branch"


/*
 *	Convert manual page to printable output command:
 *
 *	%f = filename
 *	%p = optional parameters
 */
#if !defined(__FreeBSD__)
#define MEDIT_CMD_MANPAGE_TO_OUTPUT	(PREFIX "/bin/man %p %f")
#else
#define MEDIT_CMD_MANPAGE_TO_OUTPUT	(PREFIX "/bin/manwrap %p %f")
#endif	/* !__FreeBSD__ */

/*
 *	List of names for sections by number:
 */
#define MEDIT_SECT_NAME_ANY	"*Any*"		/* Any section. */
#define MEDIT_SECT_NAME_EXACT	"*Exact*"	/* Full path to manpage file. */

#define MEDIT_SECT_NAME_1	"User Commands"
#define MEDIT_SECT_NAME_2	"System Calls"
#define MEDIT_SECT_NAME_3	"Library Functions"
#define MEDIT_SECT_NAME_4	"Special Files"
#define MEDIT_SECT_NAME_5	"File Formats"
#define MEDIT_SECT_NAME_6	"Games"
#define MEDIT_SECT_NAME_7	"Miscellaneous"
#define MEDIT_SECT_NAME_8	"Administration"


#endif	/* CONFIG_H */
