/*
          Manual Page Editor: Undo/Redo Management and Operation
 */
#ifndef EDITORUNDO_H
#define EDITORUNDO_H

#include <gtk/gtk.h>
#include <sys/types.h>

#include "editor.h"


#define EDITOR_UNDO_REMOVE_CHARS	10
#define EDITOR_UNDO_INSERT_CHARS	11


/*
 *	Common undo structure which has the first 3 members.
 */
typedef struct {

	int type;
	char *comment;
        void *editor_ptr;

} editor_undo_common_struct;

/*
 *	Remove characters (for undoing insert characters) structure:
 */
typedef struct {

	int type;	/* Always EDITOR_UNDO_REMOVE_CHARS. */
	char *comment;
        void *editor_ptr;

	GtkWidget *w;		/* Text widget. */

	int	position,	/* Remove starting index. */
		length;		/* Remove this many characters. */

} editor_undo_remove_chars_struct;

/*
 *	Insert characters (for undoing remove characters) structure:
 */
typedef struct {

	int type;       /* Always EDITOR_UNDO_INSERT_CHARS. */
	char *comment;
	void *editor_ptr;

        GtkWidget *w;           /* Text widget. */

	int	position,	/* Insert starting index. */
		length;		/* Insert this many characters. */

	char *characters;	/* Null terminated characters to be
				 * inserted, shared so needs to be free'ed.
				 */

} editor_undo_insert_chars_struct;


extern void *EditorUndoNew(
	editor_struct *editor, int type, const char *comment
);
extern void EditorUndoDelete(editor_struct *editor, void *u);

extern int EditorUndoDoApply(
	editor_struct *editor,
	void ***in_list, int *in_total,
	void ***out_list, int *out_total,
	int max
);


#endif	/* EDITORUNDO_H */
