/*
 * Copyright (c) 2001-2003 Shiman Associates Inc. All Rights Reserved.
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

#ifndef _MAS_API_INTERNAL_H
#define _MAS_API_INTERNAL_H

#include "mas.h"
#include "mas_core.h"

/* opaque pointers */
struct _mas_api_internal_device
{
    int32 device_instance;
    mas_channel_t control_channel;
};

struct _mas_api_internal_port
{
    int32 portnum;
    mas_channel_t control_channel;
};

struct _mas_api_internal_channel
{
    int32 id;
    char* hostname;
};

/* opaque.c */
extern int32 _alloc_device  ( mas_device_t* device );
extern int32 _free_device   ( mas_device_t* device );
extern int32 _alloc_port    ( mas_port_t* port );
extern int32 _free_port     ( mas_port_t* port );
extern int32 _alloc_channel ( mas_channel_t* channel );
extern int32 _free_channel  ( mas_channel_t* channel );
extern int32 _copy_channel  ( mas_channel_t channel_dest, mas_channel_t channel_src );

/* rtpcomm.c */
extern uint32 _get_ssrc( void );

#endif /* _MAS_API_INTERNAL_H */
