/* matchbox - a lightweight window manager

   Copyright 2002 Matthew Allum

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
*/


#include "docked_client.h"

Client*
docked_client_new(Wm *w, Window win)
{
   Client *c = base_client_new(w, win); 
   c->type = docked;

   c->reparent     = &docked_client_reparent;
   c->configure    = &docked_client_configure;
   c->show         = &docked_client_show;
   c->hide         = &docked_client_hide;
   c->destroy      = &docked_client_destroy;
   c->move_resize  = &docked_client_move_resize;
   
   return c;
}

void
docked_client_move_resize(Client *c)
{
   XMoveResizeWindow(c->wm->dpy, c->window, c->x ,
		     c->y-docked_client_get_y_offset(c)
		     ,c->width, c->height);
}

void
docked_client_show(Client *c)
{
   // c->y = 1+docked_client_get_y_offset(c); 
   // c->move_resize(c);
   XMapWindow(c->wm->dpy, c->window);
}

void
docked_client_hide(Client *c)
{
   //   c->y = c->wm->dpy_height+docked_client_get_y_offset(c);
   //   c->move_resize(c);
   c->ignore_unmap++;
   XUnmapWindow(c->wm->dpy, c->window);
}

void
docked_client_configure(Client *c)
{
   c->x = docked_client_get_offset(c);
   c->y = 1+docked_client_get_y_offset(c); 
   client_deliver_config(c);
   return;
}

void
docked_client_reparent(Client *c)
{
   XAddToSaveSet(c->wm->dpy, c->window);
   XReparentWindow(c->wm->dpy, c->window, c->wm->dockwin, c->x, c->y);
   XMapWindow(c->wm->dpy, c->window); /* needed ? */
}

int
docked_client_get_offset(Client *c)
{
   Client *p; int offset = dockbar_client_init_offset(c);
   for (p=c->next; p != c; p=p->next) 
      if (p->type == docked)
	 offset += ( p->width + c->wm->theme->padding );
   return offset;
}

int
docked_client_get_y_offset(Client *c)
{
   return c->wm->dpy_height-c->wm->config->dock_maxheight;
}


void
docked_client_destroy(Client *c) /* experimental */
{
   Client *p;
   for (p=c->next; p != c; p=p->next) 
      if (p->type == docked && p->x > c->x)
      {
	 p->x -= ( c->width + c->wm->theme->padding);
	 p->move_resize(p);
	 client_deliver_config(p);
      }
   base_client_destroy(c);
}

int
dockbar_client_init_offset(Client *c)
{
   int i;
   Theme *t = c->wm->theme;
#ifdef USE_XFT   
   i = max( t->toolbar_xftfont->ascent + t->toolbar_xftfont->descent,
	    t->buttons[BUTTON_TOOLBAR].width,
	    t->buttons[BUTTON_TOOLBAR_CLOSE].height,
	    0) + t->padding + t->win_border_width;
#else
   i = max( t->toolbar_font->ascent + t->toolbar_font->descent,
	    t->buttons[BUTTON_TOOLBAR].width,
	    t->buttons[BUTTON_TOOLBAR_CLOSE].height,
	    0) + t->padding + t->win_border_width;
#endif
   return i;

}






