/* matchbox - a lightweight window manager

   Copyright 2002 Matthew Allum

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
*/

#include "misc.h"

void err(const char *fmt, ...)
{
    va_list argp;
    fprintf(stderr, "X-error: ");
    va_start(argp, fmt);
    vfprintf(stderr, fmt, argp);
    va_end(argp);
    fprintf(stderr, "\n");
}

void dbg(const char *fmt, ...)
{
#ifdef DEBUG
    va_list argp;
    fprintf(stderr, "DBG: ");
    va_start(argp, fmt);
    vfprintf(stderr, fmt, argp);
    va_end(argp);
    fprintf(stderr, "\n");
#endif
}


int max(int n, ...)
{
   va_list ap;
   int maxnum = n;

   va_start(ap, n);
   while ((n = va_arg(ap, int)))
   {
      if (n > maxnum)
	 maxnum = n;

   }
   va_end(ap);
   return maxnum;
}



void fork_exec(char *cmd)
{
    pid_t pid = fork();

    switch (pid) {
        case 0:
            execlp("/bin/sh", "sh", "-c", cmd, NULL);
            err("exec failed, cleaning up child");
            exit(1);
        case -1:
            err("can't fork");
    }
}

void sig_handler(int signal)
{
    switch (signal) {
        case SIGINT:
        case SIGTERM:
        case SIGHUP:
	   /* quit_nicely(); */ exit(1); break;
        case SIGCHLD:
            wait(NULL); break;
    }
}

int handle_xerror(Display *dpy, XErrorEvent *e)
{
   //    client *c = wm_find_client(w, e->resourceid, WINDOW);

    if (e->error_code == BadAccess &&
	e->resourceid == RootWindow(dpy, DefaultScreen(dpy)) ) {
        err("root window unavailible (maybe another wm is running?)");
        exit(1);
    } else {
        char msg[255];
        XGetErrorText(dpy, e->error_code, msg, sizeof msg);
        err("X error (%#lx): %s (opcode: %i)",
	    e->resourceid, msg, e->request_code);
    }

    /* if (c) remove_client(c, WITHDRAW); */
    return 0;
}

int ignore_xerror(Display *dpy, XErrorEvent *e)
{
   return 0;
}
void dump(client *c)
{
    err("%s\n\t ignore %d\n"
        "\tframe %#lx, win %#lx, geom %dx%d+%d+%d",
        c->name, c->ignore_unmap,
        c->frame, c->window, c->width, c->height, c->x, c->y);
}

void dump_clients(wm* w)
{
    client *c;
    for (c = w->head_client; c; c = c->next) dump(c);
}


#ifdef USE_XFT
int max_xstringChars(wm *w, int *width, char *txt, XftFont *font_info)
#else
int max_xstringChars(wm *w, int *width, char *txt, XFontStruct* font_info)
#endif
{
   int cnt = strlen(txt);
#ifdef USE_XFT
      XGlyphInfo       extents;
      XftTextExtents8(w->dpy, font_info,(unsigned char *)txt, cnt, &extents);
      while ( extents.width > width)
      {
	 cnt--;
	 XftTextExtents8(w->dpy, font_info,(unsigned char *)
			 txt, cnt, &extents);
      }
#else
      while (XTextWidth(font_info, txt, cnt) > *width) cnt--;
#endif
      return cnt;
}

