/* matchbox - a lightweight window manager

   Copyright 2002 Matthew Allum

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
*/

#include "win_util.h"

void
wu_drag(Client *c) /* drag box */
{
    XEvent ev;
    int x1, y1;
    int old_cx = c->x;
    int old_cy = c->y;
    if (XGrabPointer(c->wm->dpy, c->wm->root, False,
		     (ButtonPressMask|ButtonReleaseMask|PointerMotionMask),
		     GrabModeAsync,
		     GrabModeAsync, None, c->wm->curs, CurrentTime)
	!= GrabSuccess)
       return;
    
    XGrabServer(c->wm->dpy);
    wu_get_mouse_position(c->wm, &x1, &y1);
    draw_outline(c);
    
    for (;;) {
       dbg("looping on drag");
       XMaskEvent(c->wm->dpy,
		   (ButtonPressMask|ButtonReleaseMask|PointerMotionMask), &ev);
       
       switch (ev.type) {
            case MotionNotify:
	       dbg("drag, got motion notify");
	       draw_outline(c);
                c->x = old_cx + (ev.xmotion.x - x1);
                c->y = old_cy + (ev.xmotion.y - y1);
		draw_outline(c);
                break;
            case ButtonRelease:
	       dbg("drag, got release");
	       draw_outline(c);
		XMoveWindow(c->wm->dpy, c->frame, c->x,
			    c->y - main_client_title_height(c));
		XUngrabPointer(c->wm->dpy, CurrentTime);
		XUngrabServer(c->wm->dpy);
                return;
        }
    }

    client_deliver_config(c);
}


void draw_outline(Client *c)
{
    int x,y,width, height;
    c->get_coverage(c, &x, &y, &width, &height);
    XDrawRectangle(c->wm->dpy, c->wm->root, c->wm->theme->invert_gc,
		   x, y, width, height);
}


void
wu_get_mouse_position(Wm *w, int *x, int *y)
{
    Window mouse_root, mouse_win;
    int win_x, win_y;
    unsigned int mask;

    XQueryPointer(w->dpy, w->root, &mouse_root, &mouse_win,
        x, y, &win_x, &win_y, &mask);
}

void wu_allow_xstroke( Wm *w, Window win)
{
   XChangeProperty(w->dpy, win, w->atoms[REC_PROTOCOLS], XA_ATOM, 32,
		   PropModeReplace,
		   (unsigned char *) &(w->atoms[REC_KEY]), 1);
}

int wu_trim_title( Wm *w, char *name, int max_width )
{
   int  char_cnt = strlen(name);
#ifdef USE_XFT
   XGlyphInfo       extents;
   XftTextExtents8(w->dpy, w->theme->xftfont,
		   (unsigned char *) name, char_cnt,
		   &extents);
   while (extents.width > max_width)
   {
      XftTextExtents8(w->dpy, w->theme->xftfont,
		      (unsigned char *) name, char_cnt,
		      &extents);
      char_cnt--;
   }
#else
   while (XTextWidth(w->theme->font, name, char_cnt) > max_width)
      char_cnt--;
#endif
   return char_cnt;
}
