/*-------------------------------------------------------------------------
 * Copyright (c) 2000 Kenneth W. Sodemann (stufflehead@bigfoot.com)
 *-------------------------------------------------------------------------
 * comp_guess_dlg
 *
 * Synopsis:
 *   Computer player guess display dialog.
 *
 * $Id: comp_guess_dlg.c,v 1.1 2000/10/15 15:36:15 stuffle Exp $
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to
 * Free Software Foundation, Inc.
 * 59 Temple Place, Suite 330 
 * Boston, MA  02111-1307  USA
 *
 *-------------------------------------------------------------------------
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "operators.h"
#include "support.h"

static GtkWidget*
create_computer_guess_dlg (gint           card_one,
                           gint           card_two,
                           operator_type  op,
                           gint           answer)
{
  GtkWidget *computer_guess_dlg;
  GtkWidget *dialog_vbox1;
  GtkWidget *hbox2;
  GtkWidget *pixmap8;
  GtkWidget *vbox2;
  GtkWidget *label1;
  GtkWidget *label2;
  GtkWidget *label3;
  GString   *tmp_str;

  computer_guess_dlg = gnome_dialog_new (_("Computer Player Guess"),
                                         GNOME_STOCK_BUTTON_YES,
                                         GNOME_STOCK_BUTTON_NO,
                                         NULL);
  gtk_object_set_data (GTK_OBJECT (computer_guess_dlg), 
                       "computer_guess_dlg",
                       computer_guess_dlg);
  GTK_WINDOW (computer_guess_dlg)->type = GTK_WINDOW_DIALOG;
  gtk_window_set_policy (GTK_WINDOW (computer_guess_dlg), 
                         FALSE, FALSE, FALSE);

  dialog_vbox1 = GNOME_DIALOG (computer_guess_dlg)->vbox;
  gtk_object_set_data (GTK_OBJECT (computer_guess_dlg), 
                       "dialog_vbox1",
                       dialog_vbox1);
  gtk_widget_show (dialog_vbox1);

  hbox2 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox2);
  gtk_object_set_data_full (GTK_OBJECT (computer_guess_dlg), 
                            "hbox2", 
                            hbox2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox2);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), hbox2, TRUE, TRUE, 0);

  pixmap8 = create_pixmap (computer_guess_dlg, "comp_player.xpm", FALSE);
  gtk_widget_ref (pixmap8);
  gtk_object_set_data_full (GTK_OBJECT (computer_guess_dlg), "pixmap8", 
                            pixmap8, (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pixmap8);
  gtk_box_pack_start (GTK_BOX (hbox2), pixmap8, TRUE, TRUE, 0);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox2);
  gtk_object_set_data_full (GTK_OBJECT (computer_guess_dlg), "vbox2", vbox2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox2);
  gtk_box_pack_start (GTK_BOX (hbox2), vbox2, TRUE, TRUE, 0);

  label1 = gtk_label_new (_("The computer player is going to make a guess"));
  gtk_widget_ref (label1);
  gtk_object_set_data_full (GTK_OBJECT (computer_guess_dlg), 
                            "label1", 
                            label1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label1);
  gtk_box_pack_start (GTK_BOX (vbox2), label1, FALSE, FALSE, 0);

  tmp_str = g_string_new ("");
  g_string_sprintf (tmp_str, 
                    _("The computer player guesses that %d %c %d = %d"),
                    card_one,
                    operator_symbol (op),
                    card_two,
                    answer);
  label2 = gtk_label_new (tmp_str->str);
  gtk_widget_ref (label2);
  gtk_object_set_data_full (GTK_OBJECT (computer_guess_dlg), "label2", label2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label2);
  gtk_box_pack_start (GTK_BOX (vbox2), label2, FALSE, FALSE, 0);
  g_string_free (tmp_str, TRUE);

  label3 = gtk_label_new (_("Is the computer player correct?"));
  gtk_widget_ref (label3);
  gtk_object_set_data_full (GTK_OBJECT (computer_guess_dlg), 
                            "label3", 
                            label3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label3);
  gtk_box_pack_start (GTK_BOX (vbox2), label3, FALSE, FALSE, 0);

  return computer_guess_dlg;
}


gint
execute_comp_guess_dlg (GtkWidget     *parent,
                        gint           card1,
                        gint           card2,
                        operator_type  op,
                        gint           answer)
{
   GtkWidget  *dlg;

   dlg = create_computer_guess_dlg (card1, card2, op, answer);
   gnome_dialog_set_parent (GNOME_DIALOG (dlg), GTK_WINDOW (parent));
   gnome_dialog_set_close (GNOME_DIALOG (dlg), TRUE);
   gtk_window_set_position (GTK_WINDOW (dlg), 
                            GTK_WIN_POS_CENTER);

   return gnome_dialog_run (GNOME_DIALOG (dlg));
}
