(* Copyright (C) 2004, HELM Team.
 * 
 * This file is part of HELM, an Hypertextual, Electronic
 * Library of Mathematics, developed at the Computer Science
 * Department, University of Bologna, Italy.
 * 
 * HELM is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * HELM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with HELM; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA  02111-1307, USA.
 * 
 * For details, see the HELM World-Wide-Web page,
 * http://helm.cs.unibo.it/
 *)

(* $Id: number_notation.ml 8219 2008-03-19 17:37:02Z sacerdot $ *)

let _ =
  DisambiguateChoices.add_num_choice
    ("natural number",
      (fun _ num _ -> LibraryObjects.build_nat (int_of_string num)));
  DisambiguateChoices.add_num_choice
    ("Coq natural number",
      (fun _ num _ -> HelmLibraryObjects.build_nat (int_of_string num)));
  DisambiguateChoices.add_num_choice
    ("real number",
      (fun _ num _ -> HelmLibraryObjects.build_real (int_of_string num)));
  DisambiguateChoices.add_num_choice
    ("binary positive number",
      (fun _ num _ ->
        let num = int_of_string num in
        if num = 0 then
          raise (DisambiguateTypes.Invalid_choice (None, lazy "0 is not a valid positive number"))
        else
          HelmLibraryObjects.build_bin_pos num));
  DisambiguateChoices.add_num_choice
    ("binary integer number",
      (fun _ num _ ->
        let num = int_of_string num in
        if num = 0 then
          HelmLibraryObjects.BinInt.z0
        else if num > 0 then
          Cic.Appl [
            HelmLibraryObjects.BinInt.zpos;
            HelmLibraryObjects.build_bin_pos num ]
        else
          assert false))
