/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.Iterator;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTree;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilderException;

public class TreeMojo
extends AbstractMojo {
    private static final String INDENT = "   ";
    private static final String NEWLINE = System.getProperty("line.separator");
    private MavenProject project;
    private ArtifactRepository localRepository;
    private ArtifactFactory artifactFactory;
    private ArtifactMetadataSource artifactMetadataSource;
    private ArtifactCollector artifactCollector;
    private DependencyTreeBuilder dependencyTreeBuilder;
    private File output;
    private DependencyTree dependencyTree;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.dependencyTree = this.dependencyTreeBuilder.buildDependencyTree(this.project, this.localRepository, this.artifactFactory, this.artifactMetadataSource, this.artifactCollector);
            String dependencyTreeString = this.serialiseDependencyTree(this.dependencyTree);
            if (this.output != null) {
                this.write(dependencyTreeString, this.output);
                this.getLog().info((CharSequence)("Wrote dependency tree to: " + this.output));
            } else {
                this.log(dependencyTreeString);
            }
        }
        catch (DependencyTreeBuilderException exception) {
            throw new MojoExecutionException("Cannot build project dependency tree", (Exception)((Object)exception));
        }
        catch (IOException exception) {
            throw new MojoExecutionException("Cannot serialise project dependency tree", (Exception)exception);
        }
    }

    public MavenProject getProject() {
        return this.project;
    }

    public DependencyTree getDependencyTree() {
        return this.dependencyTree;
    }

    private String serialiseDependencyTree(DependencyTree tree) {
        StringBuffer buffer = new StringBuffer();
        this.serialiseDependencyNode(tree.getRootNode(), buffer);
        return buffer.toString();
    }

    private void serialiseDependencyNode(DependencyNode node, StringBuffer buffer) {
        for (int i = 0; i < node.getDepth(); ++i) {
            buffer.append(INDENT);
        }
        buffer.append(node.getArtifact()).append(NEWLINE);
        Iterator iterator = node.getChildren().iterator();
        while (iterator.hasNext()) {
            DependencyNode child = (DependencyNode)iterator.next();
            this.serialiseDependencyNode(child, buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(String string, File file) throws IOException {
        this.output.getParentFile().mkdirs();
        FileWriter writer = null;
        try {
            writer = new FileWriter(this.output);
            writer.write(string);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException exception) {
                    this.getLog().error((CharSequence)"Cannot close file", (Throwable)exception);
                }
            }
        }
    }

    private void log(String string) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new StringReader(string));
        while ((line = reader.readLine()) != null) {
            this.getLog().info((CharSequence)line);
        }
        reader.close();
    }
}

