// Author(s): Jeroen Keiren
// Copyright: see the accompanying file COPYING or copy at
// https://svn.win.tue.nl/trac/MCRL2/browser/trunk/COPYING
//
// Distributed under the Boost Software License, Version 1.0.
// (See accompanying file LICENSE_1_0.txt or copy at
// http://www.boost.org/LICENSE_1_0.txt)
//
/// \file mcrl2/data/data.h
/// \brief Contains includes of frequently used header files for data
///        expressions.

#ifndef MCRL2_DATA_DATA_H
#define MCRL2_DATA_DATA_H

namespace mcrl2 {
  /// \brief Namespace for all data library functionality
  namespace data {
  }
}

#include "abstraction.h"
#include "application.h"
#include "data_expression.h"
#include "exists.h"
#include "forall.h"
#include "function_symbol.h"
#include "lambda.h"
#include "variable.h"
#include "where_clause.h"

#endif // MCRL2_DATA_DATA_H
