/*
  MeCab -- Yet Another Part-of-Speech and Morphological Analyzer
 
  $Id: nbest_generator.h,v 1.2 2004/03/08 07:40:53 taku-ku Exp $;

  Copyright (C) 2001-2004 Taku Kudo <taku-ku@is.aist-nara.ac.jp>
  This is free software with ABSOLUTELY NO WARRANTY.
  
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/  
#ifndef _MECAB_NBEST_GENERATOR_H
#define _MECAB_NBEST_GENERATOR_H

#include "mecab.h"
#include "freelist.h"
#include <queue>

namespace MeCab {
  
  class NBestGenerator {

  private:

    struct QueueElement {
      Node *node;
      QueueElement *next;
      unsigned int fx; // f(x) = h(x) + g(x): cost function for A* search
      unsigned int gx; // g(x)
    };

    class QueueElementComp {
    public: 
      const bool operator () (QueueElement *q1, QueueElement *q2) { return (q1->fx > q2->fx); }
    };

    std::priority_queue <QueueElement*, std::vector <QueueElement *>, QueueElementComp> agenda;
    FreeList <QueueElement> freelist;

  public:
    NBestGenerator  (): freelist(512) {};
    ~NBestGenerator () {};
    bool  set (Node *);
    Node* next ();
  };
}

#endif
