/*
  MeCab -- Yet Another Part-of-Speech and Morphological Analyzer
 
  $Id: viterbisub.h,v 1.14 2004/08/06 18:05:14 taku-ku Exp $;

  Copyright (C) 2001-2004 Taku Kudo <taku-ku@is.aist-nara.ac.jp>
  This is free software with ABSOLUTELY NO WARRANTY.
  
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/  
#include "viterbi.h"

namespace MeCab {

#ifdef _VITERBI_WITH_ALL_PATH
   bool Viterbi::connectWithAllPath
#else
   bool Viterbi::connectNormal
#endif
     (unsigned int pos, Node *rNode)
  {
    for (;rNode; rNode = rNode->rnext) {

      register unsigned int bestCost = INT32_MAX;
      Node* bestNode = 0;
      rNode->path = 0;

      for (Node *lNode = endNodeList[pos]; lNode; lNode = lNode->lnext) {

	register unsigned int cost = lNode->cost + connector->getCost (lNode->prev, lNode, rNode);
	 
	if (cost < bestCost) {
	  bestNode  = lNode;
	  bestCost  = cost;
	}
	 
#ifdef _VITERBI_WITH_ALL_PATH
	Path *path = pathFreeList->alloc ();
	path->cost = cost;
	path->node = lNode;
	path->next = rNode->path;
	rNode->path = path;
#endif
      }
       
      // overflow check 2003/03/09 
      if (! bestNode) {
	 _what = "Viterbi::connect(): too long sentence.";
         return false;
      }

      rNode->prev    = bestNode;
      rNode->next    = 0;
      rNode->cost    = bestCost;
      unsigned int x = rNode->end + pos;
      rNode->lnext   = endNodeList[x];
      endNodeList[x] = rNode;

      if (rNode->token->rcAttr2) { 
	unsigned int pos2 = rNode->end + pos;
	if (begin + pos2 == end) continue;
	Node *rNode2 = lookup (pos2);
	for (; rNode2; rNode2 = rNode2->rnext) {
	   rNode2->cost   = rNode->cost + connector->getCost (rNode->prev, rNode, rNode2);

#ifdef _VITERBI_WITH_ALL_PATH
	  Path *path = pathFreeList->alloc ();
	  path->cost = rNode2->cost;
	  path->node = rNode;
	  path->next = 0;
	  rNode2->path = path;
#endif	   
	  rNode2->prev   = rNode;
	  rNode2->next    = 0;
	  unsigned int x = rNode2->end + pos2;
	  rNode2->lnext  = endNodeList[x];
	  endNodeList[x] = rNode2;
	}
      } 
    }
     
    return true; 
  }
}
