/*************************************************************************
* COPYRIGHT (C) 1999 - 2003  EDF R&D
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*  
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/

/******************************************************************************
 * - Nom du fichier : test18.c
 *
 * - Description : routines de test de la conformite d'un fichier MED.
 *
 *****************************************************************************/

#include <med.h>
#include <med_utils.h>
#include <stdlib.h>

int main() {
  med_idt fid;
  med_int majeur, mineur, release;

  /* Creation du fichier test18.med */
  if ((fid = MEDouvrir("test18.med",MED_CREATION)) < 0) {
    MESSAGE("Erreur a la creation du fichier test18.med");
    return -1;
  }
  fprintf(stdout,"- Creation du fichier test18.med \n",fid);
  
  if (MEDfermer(fid) < 0) {
    MESSAGE("Erreur a la fermeture du fichier");
    return -1;
  }
  fprintf(stdout,"- Fermeture du fichier \n");

  /*
   * Quelle version de la bibliotheque MED est utilisee ?
   */
  MEDversionDonner(&majeur, &mineur, &release);
  fprintf(stdout,"- Version de MED utilisee pour lire le fichier : %d.%d.%d \n",majeur,mineur,release); 
  /*
   * Le fichier  lire est-il au bon format de fichier HDF ?
   */
  if (! MEDformatConforme("test18.med"))
    fprintf(stdout,"- Format HDF du fichier MED conforme au format HDF utilise par la bibliotheque \n");
  else
    fprintf(stdout,"- Format HDF du fichier MED non conforme au format HDF utilise par la bibliotheque \n");
  
  /*
   * Le fichier a lire a-t-il t cr avec une version de la bibliothque MED conforme avec celle utilise ?
   * (Numros majeur et mineur identiques).
   */
  if (! MEDversionConforme("test18.med"))
    fprintf(stdout,"- Version MED du fichier conforme a la bibliotheque MED utilisee \n");
  else
    fprintf(stdout,"- Version MED du fichier non conforme a la bibliotheque MED utilisee \n");

  if ((fid = MEDouvrir("test18.med",MED_LECTURE)) < 0) {
    MESSAGE("Erreur a l'ouverture du fichier test18.med");
    return -1;
  }
  fprintf(stdout,"- Ouverture du fichier en lecture \n",fid);

  /*
   * Une fois le fichier ouvert on peut avoir acces au numero de version complet
   */
  if (MEDversionLire(fid, &majeur, &mineur, &release) < 0) {
    MESSAGE("Erreur a la lecture du numero de version de la bibliothque ");
    return -1;
  }
  fprintf(stdout,"- Ce fichier a ete cree avec MED %d.%d.%d \n",majeur,mineur,release); 

  if (MEDfermer(fid) < 0) {
    MESSAGE("Erreur a la fermeture du fichier");
    return -1;
  }
  fprintf(stdout,"- Fermeture du fichier \n");
  
  return 0;
}
