/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.plugin;

import com.fluendo.jst.Buffer;
import com.fluendo.jst.Caps;
import com.fluendo.jst.Element;
import com.fluendo.jst.Event;
import com.fluendo.jst.Pad;
import com.fluendo.plugin.OggPayload;
import com.fluendo.utils.Debug;
import com.fluendo.utils.MemUtils;
import com.jcraft.jogg.Packet;
import com.jcraft.jorbis.Block;
import com.jcraft.jorbis.Comment;
import com.jcraft.jorbis.DspState;
import com.jcraft.jorbis.Info;
import java.util.Vector;

public class VorbisDec
extends Element
implements OggPayload {
    private long packet;
    private long offset;
    private Info vi;
    private Comment vc;
    private DspState vd;
    private Block vb;
    private boolean discont;
    private Packet op;
    private float[][][] _pcmf = new float[1][][];
    private int[] _index;
    private static final byte[] signature = new byte[]{1, 118, 111, 114, 98, 105, 115};
    private Pad srcPad = new Pad(1, "src"){

        protected boolean eventFunc(Event event) {
            return VorbisDec.this.sinkPad.pushEvent(event);
        }
    };
    private Pad sinkPad = new Pad(2, "sink"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean eventFunc(Event event) {
            boolean bl;
            switch (event.getType()) {
                case 1: {
                    bl = VorbisDec.this.srcPad.pushEvent(event);
                    Object object = this.streamLock;
                    synchronized (object) {
                        Debug.log(4, "synced " + this);
                        break;
                    }
                }
                case 2: {
                    bl = VorbisDec.this.srcPad.pushEvent(event);
                    break;
                }
                case 3: {
                    Debug.log(3, "got EOS " + this);
                    bl = VorbisDec.this.srcPad.pushEvent(event);
                    break;
                }
                default: {
                    bl = VorbisDec.this.srcPad.pushEvent(event);
                }
            }
            return bl;
        }

        /*
         * Enabled aggressive block sorting
         */
        protected int chainFunc(Buffer buffer) {
            int n;
            int n2 = 0;
            ((VorbisDec)VorbisDec.this).op.packet_base = buffer.data;
            ((VorbisDec)VorbisDec.this).op.packet = buffer.offset;
            ((VorbisDec)VorbisDec.this).op.bytes = buffer.length;
            ((VorbisDec)VorbisDec.this).op.b_o_s = VorbisDec.this.packet == 0L ? 1 : 0;
            ((VorbisDec)VorbisDec.this).op.e_o_s = 0;
            ((VorbisDec)VorbisDec.this).op.packetno = VorbisDec.this.packet;
            if (buffer.isFlagSet(1)) {
                VorbisDec.this.offset = -1L;
                VorbisDec.this.discont = true;
                Debug.log(3, "vorbis: got discont");
                VorbisDec.this.vd.synthesis_init(VorbisDec.this.vi);
            }
            if (VorbisDec.this.packet < 3L) {
                if (VorbisDec.this.vi.synthesis_headerin(VorbisDec.this.vc, VorbisDec.this.op) < 0) {
                    Debug.log(1, "This Ogg bitstream does not contain Vorbis audio data.");
                    return -5;
                }
                if (VorbisDec.this.packet == 2L) {
                    VorbisDec.this.vd.synthesis_init(VorbisDec.this.vi);
                    VorbisDec.this.vb.init(VorbisDec.this.vd);
                    Debug.log(3, "vorbis rate: " + ((VorbisDec)VorbisDec.this).vi.rate);
                    Debug.log(3, "vorbis channels: " + ((VorbisDec)VorbisDec.this).vi.channels);
                    VorbisDec.this._index = new int[((VorbisDec)VorbisDec.this).vi.channels];
                    this.caps = new Caps("audio/raw");
                    this.caps.setFieldInt("width", 16);
                    this.caps.setFieldInt("depth", 16);
                    this.caps.setFieldInt("rate", ((VorbisDec)VorbisDec.this).vi.rate);
                    this.caps.setFieldInt("channels", ((VorbisDec)VorbisDec.this).vi.channels);
                }
                buffer.free();
                VorbisDec vorbisDec = VorbisDec.this;
                vorbisDec.packet = vorbisDec.packet + 1L;
                return 0;
            }
            if (VorbisDec.this.isHeader(VorbisDec.this.op)) {
                Debug.log(3, "ignoring header");
                return 0;
            }
            long l = buffer.timestamp;
            if (l != -1L) {
                VorbisDec.this.offset = l * (long)((VorbisDec)VorbisDec.this).vi.rate / 1000000L;
            } else {
                l = VorbisDec.this.offset * 1000000L / (long)((VorbisDec)VorbisDec.this).vi.rate;
            }
            if (VorbisDec.this.vb.synthesis(VorbisDec.this.op) != 0) {
                Debug.log(1, "decoding error");
                return -5;
            }
            VorbisDec.this.vd.synthesis_blockin(VorbisDec.this.vb);
            while ((n = VorbisDec.this.vd.synthesis_pcmout(VorbisDec.this._pcmf, VorbisDec.this._index)) > 0) {
                float[][] fArray = VorbisDec.this._pcmf[0];
                int n3 = n * 2 * ((VorbisDec)VorbisDec.this).vi.channels;
                int n4 = 0;
                buffer.ensureSize(n3);
                buffer.offset = 0;
                buffer.timestamp = l;
                buffer.time_offset = VorbisDec.this.offset;
                buffer.length = n3;
                buffer.caps = this.caps;
                buffer.setFlag(1, VorbisDec.this.discont);
                VorbisDec.this.discont = false;
                int n5 = 0;
                while (n5 < n) {
                    int n6 = 0;
                    while (n6 < ((VorbisDec)VorbisDec.this).vi.channels) {
                        int n7 = (int)((double)fArray[n6][VorbisDec.this._index[n6] + n5] * 32767.0);
                        if (n7 > Short.MAX_VALUE) {
                            n7 = Short.MAX_VALUE;
                        } else if (n7 < Short.MIN_VALUE) {
                            n7 = Short.MIN_VALUE;
                        }
                        buffer.data[n4] = (byte)(n7 >> 8 & 0xFF);
                        buffer.data[n4 + 1] = (byte)(n7 & 0xFF);
                        n4 += 2;
                        ++n6;
                    }
                    ++n5;
                }
                VorbisDec.this.vd.synthesis_read(n);
                VorbisDec vorbisDec = VorbisDec.this;
                vorbisDec.offset = vorbisDec.offset + (long)n;
                n2 = VorbisDec.this.srcPad.push(buffer);
                if (n2 != 0) break;
            }
            VorbisDec vorbisDec = VorbisDec.this;
            vorbisDec.packet = vorbisDec.packet + 1L;
            return n2;
        }
    };

    public boolean isType(Packet packet) {
        return this.typeFind(packet.packet_base, packet.packet, packet.bytes) > 0;
    }

    public int takeHeader(Packet packet) {
        return this.vi.synthesis_headerin(this.vc, packet);
    }

    public boolean isHeader(Packet packet) {
        return (packet.packet_base[packet.packet] & 1) == 1;
    }

    public boolean isKeyFrame(Packet packet) {
        return true;
    }

    public long getFirstTs(Vector vector) {
        int n = vector.size();
        long l = 0L;
        long l2 = 0L;
        Packet packet = new Packet();
        int n2 = 0;
        while (n2 < n) {
            boolean bl;
            Buffer buffer = (Buffer)vector.elementAt(n2);
            packet.packet_base = buffer.data;
            packet.packet = buffer.offset;
            packet.bytes = buffer.length;
            long l3 = this.vi.blocksize(packet);
            if (l3 <= 0L) {
                return -1L;
            }
            if (l2 == 0L) {
                l2 = l3;
                bl = true;
            } else {
                bl = false;
            }
            long l4 = (l3 + l2) / 4L;
            l2 = l3;
            if (!bl) {
                l += l4;
            }
            if (buffer.time_offset != -1L) {
                l = buffer.time_offset - l;
                long l5 = this.granuleToTime(l);
                buffer = (Buffer)vector.elementAt(0);
                buffer.timestamp = l5;
                return l5;
            }
            ++n2;
        }
        return -1L;
    }

    public long granuleToTime(long l) {
        if (l < 0L) {
            return -1L;
        }
        return l * 1000000L / (long)this.vi.rate;
    }

    public VorbisDec() {
        this.vi = new Info();
        this.vc = new Comment();
        this.vd = new DspState();
        this.vb = new Block(this.vd);
        this.op = new Packet();
        this.addPad(this.srcPad);
        this.addPad(this.sinkPad);
    }

    protected int changeState(int n) {
        switch (n) {
            case 18: {
                this.packet = 0L;
                this.offset = -1L;
                this.vi.init();
                this.vc.init();
                break;
            }
        }
        int n2 = super.changeState(n);
        return n2;
    }

    public String getFactoryName() {
        return "vorbisdec";
    }

    public String getMime() {
        return "audio/x-vorbis";
    }

    public int typeFind(byte[] byArray, int n, int n2) {
        if (MemUtils.startsWith(byArray, n, n2, signature)) {
            return 10;
        }
        return -1;
    }
}

