#!/bin/bash
# Use this script to build MegaGlest Source Code Archive for a Version Release
# ----------------------------------------------------------------------------
# Written by Mark Vejvoda <mark_vejvoda@hotmail.com>
# Copyright (c) 2011 Mark Vejvoda under GNU GPL v3.0+

VERSION=$(./mg-version.sh --version)
RELEASENAME=megaglest-source
PACKAGE="$RELEASENAME-$VERSION.tar.xz"
CURRENTDIR="$(dirname $(readlink -f $0))"
RELEASEDIR="$CURRENTDIR/release/$RELEASENAME-$VERSION/megaglest-$VERSION"
SOURCEDIR="$CURRENTDIR/../../source/"
REPODIR="$CURRENTDIR/../../"

echo "Creating source package in: ${RELEASEDIR} git REPO is in: ${REPODIR}"
# exit 1

[[ -d "$RELEASEDIR" ]] && rm -rf "$RELEASEDIR"
mkdir -p "$RELEASEDIR"

echo "Exporting source ..."
# svn export --force "$SOURCEDIR" "$RELEASEDIR/source"
cd "$RELEASEDIR"
mkdir source
cd source
git archive --remote ${REPODIR} HEAD:source | tar x
cd "$RELEASEDIR"

echo "Exporting mk ..."
# mkdir -p "$RELEASEDIR/mk/cmake/"
# svn export --force "$CURRENTDIR/../cmake/" "$RELEASEDIR/mk/cmake/"
# mkdir -p "$RELEASEDIR/mk/macosx/"
# svn export --force "$CURRENTDIR/../macosx/" "$RELEASEDIR/mk/macosx/"
# mkdir -p "$RELEASEDIR/mk/windoze/"
# svn export --force "$CURRENTDIR/../windoze/" "$RELEASEDIR/mk/windoze/"
mkdir -p mk
cd mk
git archive --remote ${REPODIR} HEAD:mk | tar x
cd "$RELEASEDIR"

echo "Exporting docs ..."
# svn export --force "$CURRENTDIR/../../docs" $RELEASEDIR
mkdir docs
cd docs
git archive --remote ${REPODIR} HEAD:docs | tar x
cd "$RELEASEDIR"

echo "Exporting files in mk/linux ..."
# svn export --force "$CURRENTDIR/glest.ini" $RELEASEDIR/glest.ini
# svn export --force "$CURRENTDIR/glestkeys.ini" $RELEASEDIR/glestkeys.ini
# svn export --force "$CURRENTDIR/servers.ini" $RELEASEDIR/servers.ini
# svn export --force "$CURRENTDIR/glest.ico" $RELEASEDIR/glest.ico
# svn export --force "$CURRENTDIR/megaglest.bmp" $RELEASEDIR/megaglest.bmp
# svn export --force "$CURRENTDIR/megaglest.png" $RELEASEDIR/megaglest.png
# svn export --force "$CURRENTDIR/megaglest.xpm" $RELEASEDIR/megaglest.xpm
# svn export --force "$CURRENTDIR/megaglest.desktop" $RELEASEDIR/megaglest.desktop
# svn export --force "$CURRENTDIR/megaglest_editor.desktop" $RELEASEDIR/megaglest_editor.desktop
# svn export --force "$CURRENTDIR/megaglest_g3dviewer.desktop" $RELEASEDIR/megaglest_g3dviewer.desktop
git archive --remote ${REPODIR} HEAD:mk/linux/ glest.ini | tar x
git archive --remote ${REPODIR} HEAD:mk/linux/ glestkeys.ini | tar x
git archive --remote ${REPODIR} HEAD:mk/linux/ servers.ini | tar x
git archive --remote ${REPODIR} HEAD:mk/linux/ glest.ico | tar x
git archive --remote ${REPODIR} HEAD:mk/linux/ megaglest.bmp | tar x
git archive --remote ${REPODIR} HEAD:mk/linux/ megaglest.png | tar x
git archive --remote ${REPODIR} HEAD:mk/linux/ megaglest.xpm | tar x
git archive --remote ${REPODIR} HEAD:mk/linux/ megaglest.desktop | tar x
git archive --remote ${REPODIR} HEAD:mk/linux/ megaglest_editor.desktop | tar x
git archive --remote ${REPODIR} HEAD:mk/linux/ megaglest_g3dviewer.desktop | tar x

# The mnpages are auto generated by the build process so no need to ship with source
# svn export --force "$CURRENTDIR/megaglest.6" $RELEASEDIR/megaglest.6
# svn export --force "$CURRENTDIR/megaglest_editor.6" $RELEASEDIR/megaglest_editor.6
# svn export --force "$CURRENTDIR/megaglest_g3dviewer.6" $RELEASEDIR/megaglest_g3dviewer.6

echo "Exporting files in data/glest_game ..."
# svn export --force "$CURRENTDIR/../../data/glest_game/megaglest.ico" $RELEASEDIR/megaglest.ico
# svn export --force "$CURRENTDIR/../../data/glest_game/g3dviewer.ico" $RELEASEDIR/g3dviewer.ico
# svn export --force "$CURRENTDIR/../../data/glest_game/editor.ico" $RELEASEDIR/editor.ico
# svn export --force "$CURRENTDIR/start_megaglest" $RELEASEDIR/start_megaglest
# svn export --force "$CURRENTDIR/start_megaglest_g3dviewer" $RELEASEDIR/start_megaglest_g3dviewer
# svn export --force "$CURRENTDIR/start_megaglest_mapeditor" $RELEASEDIR/start_megaglest_mapeditor
# svn export --force "$CURRENTDIR/setupBuildDeps.sh" $RELEASEDIR/setupBuildDeps.sh
# svn export --force "$CURRENTDIR/../../CMakeLists.txt" $RELEASEDIR/CMakeLists.txt
git archive --remote ${REPODIR}/data/glest_game/ HEAD: megaglest.ico | tar x
git archive --remote ${REPODIR}/data/glest_game/ HEAD: g3dviewer.ico | tar x
git archive --remote ${REPODIR}/data/glest_game/ HEAD: editor.ico | tar x
git archive --remote ${REPODIR} HEAD:mk/linux/ start_megaglest | tar x
git archive --remote ${REPODIR} HEAD:mk/linux/ start_megaglest_g3dviewer | tar x
git archive --remote ${REPODIR} HEAD:mk/linux/ start_megaglest_mapeditor | tar x
git archive --remote ${REPODIR} HEAD:mk/linux/ setupBuildDeps.sh | tar x
git archive --remote ${REPODIR} HEAD: CMakeLists.txt | tar x

# exit 1

# START
echo "Removing non required files ..."
# remove embedded library code as that will be packaged in a seperate archive
rm -rf "$RELEASEDIR/source/shared_lib/sources/libircclient/"
rm -rf "$RELEASEDIR/source/shared_lib/include/libircclient/"
rm -rf "$RELEASEDIR/source/shared_lib/sources/platform/miniupnpc/"
rm -rf "$RELEASEDIR/source/shared_lib/include/platform/miniupnpc/"
# rm -rf "$RELEASEDIR/source/shared_lib/sources/streflop/"
# rm -rf "$RELEASEDIR/source/shared_lib/include/streflop/"
rm -rf "$RELEASEDIR/source/masterserver/flags/"
# END

cd ${CURRENTDIR}
echo "Creating $PACKAGE"
[[ -f "$release/$PACKAGE" ]] && rm "release/$PACKAGE"
tar cJf "release/$PACKAGE" -C "$CURRENTDIR/release/$RELEASENAME-$VERSION" "megaglest-$VERSION"

ls -la release/$PACKAGE
