;; $Id: mell-event.el,v 1.1.1.1 2003/06/01 03:04:44 komatsu Exp $
;;
;; AUTHOR:  Hiroyuki KOMATSU <komatsu@taiyaki.org>
;; LICENSE: GPL2
;;

;; Checking Emacs or XEmacs.
(if (not (boundp 'running-xemacs))
    (defconst running-xemacs nil))

(defun mell-event-pending-command-p (&optional command-list)
  "Return the pending command symbol or nil.
COMMAND-LIST narrows checking commands to the list."
  (and (input-pending-p)
       (if command-list
	   (car (member (mell-event-to-command (mell-event-lookup-next))
			command-list))
	 (mell-event-to-command (mell-event-lookup-next))
	 )))

(defun mell-event-lookup-next ()
  (let ((event (mell-event-get-next)))
    (setq unread-command-events 
	  (append (cons event unread-command-events)))
    event)
  )

(cond
 (running-xemacs ;; ----------------------------------------
;; XEmacs
(defalias 'mell-event-get-next 'next-event)

;; XEmacs
(defun mell-event-to-command (event)
  (if (key-press-event-p event)
      (key-binding event)
    nil)
  )

;; XEmacs
(defun mell-event-to-string (event)
  (if (key-press-event-p event)
      (char-to-string (event-to-character event))
    nil)
  )

 )
 (t ;; -----------------------------------------------------

;; FSF Emacs
(defalias 'mell-event-get-next 'read-event)

;; FSF Emacs
(defun mell-event-to-command (event)
  (key-binding (fillarray [nil] last-input-event))
  )

;; FSF Emacs
(defun mell-event-to-string (event)
  (if (char-valid-p event)
      (char-to-string event)
    nil)
  )
))

(provide 'mell-event)
