##############################################################################
#
# Widget to edit items <Peter.Bienstman@ugent.be>
# Duplicate check and find by Jarno Elonen <elonen@iki.fi>
#
##############################################################################

from qt import *
from memaid_core import *
from edit_items_frm import *
from edit_item_dlg import *
from font_util import *


##############################################################################
#
# ListItem
#
##############################################################################

class ListItem(QListViewItem):
    def __init__(self, parent, item):
        QListViewItem.__init__(self,parent, item.q, item.a, item.cat.name)

        self.item = item
        
        self.setMultiLinesEnabled(1)
        self.setRenameEnabled(0, 1)
        self.setRenameEnabled(1, 1)
        self.setRenameEnabled(2, 1)
        
        self.changed = False
    
    
    
##############################################################################
#
# EditItemsDlg
#
##############################################################################

class EditItemsDlg(EditItemsFrm):

    ##########################################################################
    #
    # __init__
    #
    ##########################################################################
    
    def __init__(self, parent=None, name=None, modal=0, fl=0):
        
        EditItemsFrm.__init__(self,parent,name,modal,fl)
        
        self.changed = False
        
        self.category_change_queue = []
        self.item_delete_queue = []
        
        self.popup_item = None

        progress = QProgressDialog(self.trUtf8('Building a list of questions'),
                                   QString(), len(get_items()))
        progress.setMinimumDuration(1000)
        p = 0
        for e in get_items():
            ListItem(self.item_list, e)
            qApp.processEvents()
            if progress.wasCanceled():
                break
            progress.setProgress(p)
            p += 1

        self.connect(self.item_list,
                     SIGNAL("itemRenamed(QListViewItem*,int)"),
                     self.cell_edited)

        self.popup = QPopupMenu(self, "menu")
        #self.popup.insertItem(self.tr("&Edit"), self.edit)
        #self.popup.insertItem(self.tr("&Add vice versa"), self.viceversa)
        self.popup.insertItem(self.tr("&Delete"), self.delete)
        self.connect(self.item_list,
          SIGNAL("contextMenuRequested(QListViewItem*,const QPoint&,int)"),
          self.show_popup)
        self.connect(self.find_button, SIGNAL("clicked()"), self.find)
        self.connect(self.to_find, SIGNAL("returnPressed()"), self.find)
        self.connect(self.apply_button, SIGNAL("clicked()"), self.apply)
        self.connect(self.discard_button, SIGNAL("clicked()"), self.cancel)

        if get_config("font") != None:
            font = listToFont(get_config("font"))
            self.to_find.setFont(font)
            self.item_list.setFont(font)
            
        
    ##########################################################################
    #
    # edit
    #
    ##########################################################################

    def edit(self):
        self.changed = True

    ##########################################################################
    #
    # viceversa
    #
    ##########################################################################
    
    def viceversa(self):
        self.changed = True

    ##########################################################################
    #
    # delete
    #
    ##########################################################################
    
    def delete(self):
        self.item_delete_queue.append(self.popup_item.item)
        self.item_list.takeItem(self.popup_item)
        self.popup_item = None
        self.changed = True

    ##########################################################################
    #
    # show_popup
    #
    ##########################################################################
    
    def show_popup(self,item,point,i):
        self.popup_item = item
        self.popup.popup(point)

    ##########################################################################
    #
    # cell_edited
    #
    ##########################################################################
    
    def cell_edited(self, item, col):
    
        self.changed = True
        item.changed = True
        
        old_cat_name = item.item.cat.name
        new_cat_name = unicode(item.text(2))
        
        if old_cat_name != new_cat_name:
            self.category_change_queue.append((item.item, new_cat_name))
            
    ##########################################################################
    #
    # find
    #
    ##########################################################################
    
    def find(self, string=None):

        # Find either from the current selection or if nothing is selected,
        # from the beginning.
        
        iter     = QListViewItemIterator(self.item_list)
        sel_iter = QListViewItemIterator(self.item_list,
                                         QListViewItemIterator.Selected)
        if sel_iter.current():
            next  = QListViewItemIterator(sel_iter.current())
            next += 1
            if next.current():
                iter = next

        if string is None:
            string = self.to_find.text()
        self.last_search_str = string

        f = None
        while iter.current():
            if iter.current().text(0).find(string, 0, False) >= 0 or \
               iter.current().text(1).find(string, 0, False) >= 0:
                f = iter.current()
                break
            iter += 1
                                    
        if f:
            self.item_list.setSelected(f, 1)
            self.item_list.ensureItemVisible(f)
            self.item_list.setFocus()
        else:
            self.item_list.clearSelection()
            QMessageBox.critical(None,
                self.trUtf8("PyQt MemAid"),
                self.trUtf8("""The text you entered was not found."""),
                self.trUtf8("&OK"), QString(), QString(), 0, -1)
            
    # Repeat last search.
    
    def keyPressEvent(self, e):
        if e.key() == Qt.Key_F3 and self.last_search_str is not None:
            self.find(self.last_search_str)
            e.accept()
        else:
            e.ignore()

    ##########################################################################
    #
    # check_for_duplicates
    #
    ##########################################################################

    def check_for_duplicates(self):

        # Build a dictionary of format 'question':[item, item, ...]
        
        separate_cats = get_config("allow_duplicates_in_diff_cat")
        items_for_question = {}
        for item in get_items():
            key = item.q
            if separate_cats:
                key = (item.cat.name, item.q)
            if not key in items_for_question:
                items_for_question[key] = []
            items_for_question[key].append(item)

        # Filter out duplicate Q/A pairs.

        n_removed = p = 0
        
        progress = QProgressDialog(  \
            self.trUtf8('Filtering out duplicate questions.'),
            self.trUtf8('&Abort'), len(items_for_question))
        
        for q, iarr in items_for_question.iteritems():
            qApp.processEvents()
            if progress.wasCanceled():
                break
            progress.setProgress(p)
            p += 1
            if len(iarr) > 1:
                old_len = len(iarr)
                for j in range(0, old_len-1):
                    if j < len(iarr):
                        i1 = iarr[j]
                        new_iarr = []
                        for i in iarr:
                            if (i is i1) or i.a != i1.a:
                                new_iarr.append(i)
                            else:
                                # print "Removed: %s => %s" % (i.q, i.a)
                                delete_item(i)
                                n_removed += 1
                        iarr = new_iarr
                items_for_question[q] = iarr
                
        progress.hide()
        
        if n_removed > 0:
            QMessageBox.information(None,
                self.trUtf8("PyQt MemAid"),
                unicode(self.trUtf8('Total %d duplicate Q/A pairs were '+
                                    'cleaned up.')) % n_removed,
                self.trUtf8("&Ok"))

        # Ask about non-duplicate-answer cases and merge if the user wishes so.
        
        for q, iarr in items_for_question.iteritems():
            
            if len(iarr) > 1:
                
                answers = ''
                for i in iarr:
                    answers += '<br>"' + i.a + '"'
                if separate_cats:
                    msg = unicode(self.trUtf8('<b>There are %d different '+
                                              'answers in category "%s" for '+
                                              'question</b>:<br>"%s"<br><b>'+
                                              'Answers</b>:%s')) \
                    % (len(iarr), iarr[0].cat.name, iarr[0].q, answers)
                else:
                    msg = unicode(self.trUtf8('<b>There are %d different '+
                                              'answers for question</b>:<br>'+
                                              '"%s"<br><b>Answers</b>:%s')) \
                    % (len(iarr), iarr[0].q, answers)
                    
                status = QMessageBox.question(None,
                      self.trUtf8("PyQt MemAid"), msg,
                      self.trUtf8("&Merge and edit"), self.trUtf8("&Ignore"),
                      self.trUtf8("&Abort"), 0, -1)
                
                if status == 2:
                    return
                
                if status == 0:
                    new_item = iarr[0]
                    delete_item(iarr[0])
                    for i in iarr[1:]:
                        new_item.gr = min(new_item.gr, i.gr)
                        new_item.a += ' / ' + i.a
                        delete_item(i)
                    new_item = add_new_item(new_item.gr, new_item.q,
                                            new_item.a, new_item.cat.name)
                    dlg = EditItemDlg(new_item,self,"Edit merged item",0)
                    dlg.exec_loop()

    ##########################################################################
    #
    # apply
    #
    ##########################################################################
    
    def apply(self):

        check_for_duplicates = (get_config("check_duplicates") >= 2)

        if self.changed == False and not check_for_duplicates:
            return self.accept()
    
        # Changed items.
        
        item = self.item_list.firstChild()
        while item:
    
            if item.changed == True:
                item.item.q  = unicode(item.text(0))
                item.item.a  = unicode(item.text(1))
                
            item = item.nextSibling()
            
        # Deleted items.
            
        for item in self.item_delete_queue:
            delete_item(item)
                
        # Category changes.
            
        for i in self.category_change_queue:
            i[0].change_category(i[1])

        if check_for_duplicates:
          self.check_for_duplicates()

        rebuild_revision_queue()

        self.changed = False
        self.accept()
  
    ##########################################################################
    #
    # cancel
    #
    ##########################################################################
    
    def cancel(self):
    	if self.changed == True:
            status = QMessageBox.warning(None,
            self.trUtf8("PyQt MemAid"),
            self.trUtf8("""There are changed items in the list. """+\
                        """Do you want to discard the changes?"""),
            self.trUtf8("&Yes"), self.trUtf8("&No"), QString(), 1, -1)
                
            if status == 0: # Yes
                self.changed = False
                self.close()
            else:
                return
        else:
            self.changed = False
            self.close()

    ##########################################################################
    #
    # closeEvent
    #
    ##########################################################################

    def closeEvent(self, event):
        
    	if self.changed == True:
            status = QMessageBox.warning(None,
            self.trUtf8("PyQt MemAid"),
            self.trUtf8("""There are changed items in the list. """+\
                        """Do you want to discard the changes?"""),
            self.trUtf8("&Yes"), self.trUtf8("&No"), QString(), 1, -1)
                
            if status == 0: # Yes
                event.accept()
            else:
                event.ignore()
        else:
            event.accept()

