/*
 *  linux/boot/head.S
 *  Copyright (C) 1991, 1992  Linus Torvalds
 */

/*
 *  head.S contains the 32-bit startup code.
 *
 *  1-Jan-96 Modified by Chris Brady for use as a boot/loader for MemTest-86.
 *  Setup the memory management for flat non-paged linear addressing.
 */

.text
.global idt
.global idt_descr
.global trap_regs

#include <linux/linkage.h>
#include "defs.h"
#include "config.h"

#ifndef SYMBOL_NAME
#define SYMBOL_NAME(X) _/**/X
#endif

/*
 * References to members of the boot_cpu_data structure.
 */
#define CPU_PARAMS	SYMBOL_NAME(cpu_id)
#define X86		CPU_PARAMS+0
#define X86_MODEL	CPU_PARAMS+1
#define X86_MASK	CPU_PARAMS+2
#define X86_CPUID	CPU_PARAMS+4
#define X86_CAPABILITY	CPU_PARAMS+8
#define X86_VENDOR_ID	CPU_PARAMS+12
#define X86_CACHE	CPU_PARAMS+24

#define MEM_PARAMS	SYMBOL_NAME(mem_info)

/*
 * Offsets for eregs structure
 */
#define TRAP_REGS	SYMBOL_NAME(trap_regs)
#define ERR_EAX		TRAP_REGS+0
#define ERR_EBX		TRAP_REGS+4
#define ERR_ECX		TRAP_REGS+8
#define ERR_EDX		TRAP_REGS+12
#define ERR_EDI		TRAP_REGS+16
#define ERR_ESI		TRAP_REGS+20
#define ERR_EBP		TRAP_REGS+24
#define ERR_ESP		TRAP_REGS+28
#define ERR_VECT	TRAP_REGS+32
#define ERR_EFLAG	TRAP_REGS+36
#define ERR_CS		TRAP_REGS+40
#define ERR_CIP		TRAP_REGS+44
#define ERR_CODE	TRAP_REGS+48

startup_32:

	cld
	cli
/*
 * start system 32-bit setup. We need to re-do some of the things done
 * in 16-bit mode for the "real" operations.
 */
	xorl %eax,%eax
a20:	incl %eax		# check that A20 really IS enabled
	movl %eax,0x000000	# loop forever if it isn't
	cmpl %eax,0x100000
	je a20

        lgdt gdt_descr
        ljmp $KERNEL_CS, $flush
flush:  movl $KERNEL_DS, %eax   # reload all the segment registers
        mov %ax,%ds             # after changing gdt.
        mov %ax,%es
        mov %ax,%fs
        mov %ax,%gs
	mov %ax,%ss

	/* Pick the appropriate stack address */
	movl $HIGH_TEST_ADR,%esp
	cmpl $startup_32, %esp
	jb 1f
	movl $LOW_TEST_ADR, %esp
1:


/*
 * Setup and exception handler
 */
        lea SYMBOL_NAME(idt),%edi

        lea vec0,%edx
        movl $(KERNEL_CS << 16),%eax
        movw %dx,%ax            /* selector = 0x0010 = cs */
        movw $0x8E00,%dx        /* interrupt gate - dpl=0, present */
        movl %eax,(%edi)
        movl %edx,4(%edi)
        addl $8,%edi

        lea vec1,%edx
        movl $(KERNEL_CS << 16),%eax
        movw %dx,%ax            /* selector = 0x0010 = cs */
        movw $0x8E00,%dx        /* interrupt gate - dpl=0, present */
        movl %eax,(%edi)
        movl %edx,4(%edi)
        addl $8,%edi

        lea vec2,%edx
        movl $(KERNEL_CS << 16),%eax
        movw %dx,%ax            /* selector = 0x0010 = cs */
        movw $0x8E00,%dx        /* interrupt gate - dpl=0, present */
        movl %eax,(%edi)
        movl %edx,4(%edi)
        addl $8,%edi

        lea vec3,%edx
        movl $(KERNEL_CS << 16),%eax
        movw %dx,%ax            /* selector = 0x0010 = cs */
        movw $0x8E00,%dx        /* interrupt gate - dpl=0, present */
        movl %eax,(%edi)
        movl %edx,4(%edi)
        addl $8,%edi

        lea vec4,%edx
        movl $(KERNEL_CS << 16),%eax
        movw %dx,%ax            /* selector = 0x0010 = cs */
        movw $0x8E00,%dx        /* interrupt gate - dpl=0, present */
        movl %eax,(%edi)
        movl %edx,4(%edi)
        addl $8,%edi

        lea vec5,%edx
        movl $(KERNEL_CS << 16),%eax
        movw %dx,%ax            /* selector = 0x0010 = cs */
        movw $0x8E00,%dx        /* interrupt gate - dpl=0, present */
        movl %eax,(%edi)
        movl %edx,4(%edi)
        addl $8,%edi

        lea vec6,%edx
        movl $(KERNEL_CS << 16),%eax
        movw %dx,%ax            /* selector = 0x0010 = cs */
        movw $0x8E00,%dx        /* interrupt gate - dpl=0, present */
        movl %eax,(%edi)
        movl %edx,4(%edi)
        addl $8,%edi

        lea vec7,%edx
        movl $(KERNEL_CS << 16),%eax
        movw %dx,%ax            /* selector = 0x0010 = cs */
        movw $0x8E00,%dx        /* interrupt gate - dpl=0, present */
        movl %eax,(%edi)
        movl %edx,4(%edi)
        addl $8,%edi

        lea vec8,%edx
        movl $(KERNEL_CS << 16),%eax
        movw %dx,%ax            /* selector = 0x0010 = cs */
        movw $0x8E00,%dx        /* interrupt gate - dpl=0, present */
        movl %eax,(%edi)
        movl %edx,4(%edi)
        addl $8,%edi

        lea vec9,%edx
        movl $(KERNEL_CS << 16),%eax
        movw %dx,%ax            /* selector = 0x0010 = cs */
        movw $0x8E00,%dx        /* interrupt gate - dpl=0, present */
        movl %eax,(%edi)
        movl %edx,4(%edi)
        addl $8,%edi

        lea vec10,%edx
        movl $(KERNEL_CS << 16),%eax
        movw %dx,%ax            /* selector = 0x0010 = cs */
        movw $0x8E00,%dx        /* interrupt gate - dpl=0, present */
        movl %eax,(%edi)
        movl %edx,4(%edi)
        addl $8,%edi

        lea vec11,%edx
        movl $(KERNEL_CS << 16),%eax
        movw %dx,%ax            /* selector = 0x0010 = cs */
        movw $0x8E00,%dx        /* interrupt gate - dpl=0, present */
        movl %eax,(%edi)
        movl %edx,4(%edi)
        addl $8,%edi

        lea vec12,%edx
        movl $(KERNEL_CS << 16),%eax
        movw %dx,%ax            /* selector = 0x0010 = cs */
        movw $0x8E00,%dx        /* interrupt gate - dpl=0, present */
        movl %eax,(%edi)
        movl %edx,4(%edi)
        addl $8,%edi

        lea vec13,%edx
        movl $(KERNEL_CS << 16),%eax
        movw %dx,%ax            /* selector = 0x0010 = cs */
        movw $0x8E00,%dx        /* interrupt gate - dpl=0, present */
        movl %eax,(%edi)
        movl %edx,4(%edi)
        addl $8,%edi

        lea vec14,%edx
        movl $(KERNEL_CS << 16),%eax
        movw %dx,%ax            /* selector = 0x0010 = cs */
        movw $0x8E00,%dx        /* interrupt gate - dpl=0, present */
        movl %eax,(%edi)
        movl %edx,4(%edi)
        addl $8,%edi

        lea vec15,%edx
        movl $(KERNEL_CS << 16),%eax
        movw %dx,%ax            /* selector = 0x0010 = cs */
        movw $0x8E00,%dx        /* interrupt gate - dpl=0, present */
        movl %eax,(%edi)
        movl %edx,4(%edi)
        addl $8,%edi

        lea vec16,%edx
        movl $(KERNEL_CS << 16),%eax
        movw %dx,%ax            /* selector = 0x0010 = cs */
        movw $0x8E00,%dx        /* interrupt gate - dpl=0, present */
        movl %eax,(%edi)
        movl %edx,4(%edi)
        addl $8,%edi

        lea vec17,%edx
        movl $(KERNEL_CS << 16),%eax
        movw %dx,%ax            /* selector = 0x0010 = cs */
        movw $0x8E00,%dx        /* interrupt gate - dpl=0, present */
        movl %eax,(%edi)
        movl %edx,4(%edi)
        addl $8,%edi

        lea vec18,%edx
        movl $(KERNEL_CS << 16),%eax
        movw %dx,%ax            /* selector = 0x0010 = cs */
        movw $0x8E00,%dx        /* interrupt gate - dpl=0, present */
        movl %eax,(%edi)
        movl %edx,4(%edi)
        addl $8,%edi

	lidt idt_descr

/* Copy the memory size params */
	movl $0x90000,%esi
	movl $MEM_PARAMS,%edi
        movl $200,%ecx
        cld
        rep
        movsl

/* Find out the CPU type */

	movl $-1,X86_CPUID		#  -1 for no CPUID initially

/* check if it is 486 or 386. */

	movl $3,X86		# at least 386
	pushfl			# push EFLAGS
	popl %eax		# get EFLAGS
	movl %eax,%ecx		# save original EFLAGS
	xorl $0x40000,%eax	# flip AC bit in EFLAGS
	pushl %eax		# copy to EFLAGS
	popfl			# set EFLAGS
	pushfl			# get new EFLAGS
	popl %eax		# put it in eax
	xorl %ecx,%eax		# change in flags
	andl $0x40000,%eax	# check if AC bit changed
	je id_done

	movl $4,X86		# at least 486
	movl %ecx,%eax
	xorl $0x200000,%eax	# check ID flag
	pushl %eax
	popfl			# if we are on a straight 486DX, SX, or
	pushfl			# 487SX we can't change it
	popl %eax
	xorl %ecx,%eax
	pushl %ecx		# restore original EFLAGS
	popfl
	andl $0x200000,%eax
	jne have_cpuid

	/* Test for Cyrix CPU types */
	xor %ax,%ax		# clear ax
	sahf			# clear flags
	mov $5,%ax
	mov $2,%bx
	div %bl			# do operation that does not change flags
	lahf			# get flags
	cmp $2,%ah		# check for change in flags
	jne id_done		# if not Cyrix
	movl $2,X86		# Use two to identify as Cyrix
	jp id_done

have_cpuid:
	/* get vendor info */
	xorl %eax,%eax			# call CPUID with 0 -> return vendor ID
	cpuid
	movl %eax,X86_CPUID		# save CPUID level
	movl %ebx,X86_VENDOR_ID		# first 4 chars
	movl %edx,X86_VENDOR_ID+4	# next 4 chars
	movl %ecx,X86_VENDOR_ID+8	# last 4 chars

	orl %eax,%eax			# do we have processor info as well?
	je id_done

	movl $1,%eax		# Use the CPUID instruction to get CPU type
	cpuid
	movb %al,%cl		# save reg for future use
	andb $0x0f,%ah		# mask processor family
	movb %ah,X86
	andb $0xf0,%al		# mask model
	shrb $4,%al
	movb %al,X86_MODEL
	andb $0x0f,%cl		# mask mask revision
	movb %cl,X86_MASK
	movl %edx,X86_CAPABILITY

	movl $0,X86_CACHE
	movl $0,X86_CACHE+4
	movl $0,X86_CACHE+8
	movl $0,X86_CACHE+12

	movl X86_VENDOR_ID+8,%eax
	cmpl $0x6c65746e,%eax	# Is this an Intel CPU?
	jne not_intel
	movl $2,%eax		# Use the CPUID instruction to get cache info 
	cpuid
	movl %eax,X86_CACHE
	movl %ebx,X86_CACHE+4
	movl %ecx,X86_CACHE+8
	movl %edx,X86_CACHE+12
	jp   id_done

not_intel:
	movl X86_VENDOR_ID+8,%eax
	cmpl $0x444d4163,%eax	# Is this an AMD CPU?
	jne not_amd

	movl $0x80000005,%eax	# Use the CPUID instruction to get cache info 
	cpuid
	movl %ecx,X86_CACHE
	movl %edx,X86_CACHE+4
	movl $0x80000006,%eax	# Use the CPUID instruction to get cache info
	cpuid
	movl %ecx,X86_CACHE+8

not_amd:
	movl X86_VENDOR_ID+8,%eax
	cmpl $0x64616374,%eax	# Is this a Cyrix CPU?
	jne id_done

	movl X86_CPUID,%eax	# get CPUID level
	cmpl $2, %eax		# Is there cache information available ?
	jne id_done

	movl $2,%eax		# Use the CPUID instruction to get cache info 
	cpuid
	movl %edx,X86_CACHE

id_done:
        call SYMBOL_NAME(do_test)

vec0:
	movl %eax,ERR_EAX
	movl $0,ERR_VECT
	jp int_hand
vec1:
	movl %eax,ERR_EAX
	movl $1,ERR_VECT
	jp int_hand
	
vec2:
	movl %eax,ERR_EAX
	movl $2,ERR_VECT
	jp int_hand
	
vec3:
	movl %eax,ERR_EAX
	movl $3,ERR_VECT
	jp int_hand
	
vec4:
	movl %eax,ERR_EAX
	movl $4,ERR_VECT
	jp int_hand
	
vec5:
	movl %eax,ERR_EAX
	movl $5,ERR_VECT
	jp int_hand
	
vec6:
	movl %eax,ERR_EAX
	movl $6,ERR_VECT
	jp int_hand
	
vec7:
	movl %eax,ERR_EAX
	movl $7,ERR_VECT
	jp int_hand
	
vec8:
	movl %eax,ERR_EAX
	movl $8,ERR_VECT
	popl %eax
	movl %eax,ERR_CODE
	jp int_hand
	
vec9:
	movl %eax,ERR_EAX
	movl $9,ERR_VECT
	jp int_hand
	
vec10:
	movl %eax,ERR_EAX
	movl $10,ERR_VECT
	popl %eax
	movl %eax,ERR_CODE
	jp int_hand
	
vec11:
	movl %eax,ERR_EAX
	movl $11,ERR_VECT
	popl %eax
	movl %eax,ERR_CODE
	jp int_hand
	
vec12:
	movl %eax,ERR_EAX
	movl $12,ERR_VECT
	popl %eax
	movl %eax,ERR_CODE
	jp int_hand
	
vec13:
	movl %eax,ERR_EAX
	movl $13,ERR_VECT
	popl %eax
	movl %eax,ERR_CODE
	jp int_hand
	
vec14:
	movl %eax,ERR_EAX
	movl $14,ERR_VECT
	popl %eax
	movl %eax,ERR_CODE
	jp int_hand
	
vec15:
	movl %eax,ERR_EAX
	movl $15,ERR_VECT
	jp int_hand
	
vec16:
	movl %eax,ERR_EAX
	movl $16,ERR_VECT
	jp int_hand
	
vec17:
	movl %eax,ERR_EAX
	movl $17,ERR_VECT
	popl %eax
	movl %eax,ERR_CODE
	jp int_hand
	
vec18:
	movl %eax,ERR_EAX
	movl $18,ERR_VECT
	jp int_hand
	
vec19:
	movl %eax,ERR_EAX
	movl $19,ERR_VECT
	jp int_hand
	
int_hand:
	movl %ebx,ERR_EBX
	movl %ecx,ERR_ECX
	movl %edx,ERR_EDX
	movl %edi,ERR_EDI
	movl %esi,ERR_ESI
	movl %ebp,ERR_EBP
	movl %esp,ERR_ESP
	movl (%esp), %eax
	movl %eax,ERR_CIP
	movl 4(%esp), %eax
	movl %eax,ERR_CS
	movl 8(%esp),%eax
	movl %eax,ERR_EFLAG
        call SYMBOL_NAME(inter)
	movl ERR_EAX,%eax
	movl ERR_EBX,%ebx
	movl ERR_ECX,%ecx
	movl ERR_EDX,%edx
	movl ERR_EDI,%edi
	movl ERR_ESI,%esi
	movl ERR_EBP,%ebp
	iret

/*
 * The interrupt descriptor table has room for 32 idt's
 */
.align 4        
.word 0
idt_descr:
        .word 20*8-1           # idt contains 32 entries
        .long SYMBOL_NAME(idt)

idt:
        .fill 20,8,0           # idt is uninitialized

gdt_descr:
        .word (16)*8-1
        .long _gdt

.align 4
_gdt:
        .quad 0x0000000000000000        /* NULL descriptor */
        .quad 0x0000000000000000        /* not used */
        .quad 0x00cf9a000000ffff        /* 0x10 main 4gb code at 0x000000 */
        .quad 0x00cf92000000ffff        /* 0x18 main 4gb data at 0x000000 */
        .quad 0x00cf9a100000ffff        /* 0x20 relo 4gb code at 0x100000 */
        .quad 0x00cf92100000ffff        /* 0x28 relo 4gb data at 0x100000 */
