/* mg-canvas-tip.h
 *
 * Copyright (C) 2002 - 2004 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __MG_CANVAS_TIP__
#define __MG_CANVAS_TIP__

#include <gnome.h>

G_BEGIN_DECLS


/*
 * 
 * "Tooltip item" GnomeCanvas item: a CanvasGroup item which is used to present
 * a tip when the mouse does not move for a time (handled by the CanvasBase object)
 *
 */

#define MG_CANVAS_TIP_TYPE          (mg_canvas_tip_get_type())
#define MG_CANVAS_TIP(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, mg_canvas_tip_get_type(), MgCanvasTip)
#define MG_CANVAS_TIP_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, mg_canvas_tip_get_type (), MgCanvasTipClass)
#define IS_MG_CANVAS_TIP(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, mg_canvas_tip_get_type ())


typedef struct _MgCanvasTip        MgCanvasTip;
typedef struct _MgCanvasTipClass   MgCanvasTipClass;
typedef struct _MgCanvasTipPrivate MgCanvasTipPrivate;


/* struct for the object's data */
struct _MgCanvasTip
{
	GnomeCanvasGroup    object;

	MgCanvasTipPrivate *priv;
};

/* struct for the object's class */
struct _MgCanvasTipClass
{
	GnomeCanvasGroupClass parent_class;
};

guint      mg_canvas_tip_get_type (void);
	
G_END_DECLS

#endif
