/*
 *  Merlin's Clock Applet
 *  - A GNOME panel applet that displays the time or date.
 *  Copyright (C) 1999 Merlin Hughes
 *  - merlin@merlin.org
 *  - http://nitric.com/freeware/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Street #330, Boston, MA 02111-1307, USA.
 */

#ifndef _MERLIN_CLOCK_H
#define _MERLIN_CLOCK_H

/* I dunno what PACKAGE means... */
#define PACKAGE "gnome-core"
#define VERSION "0.1.0"

#include <applet-widget.h>

typedef struct MerlinClockData {
  GtkWidget *applet;

  gint breadth, depth;

  gboolean datemode, extended, setup, force_update, vertical;

  gboolean toggle;
  time_t toggle_t;

  guint timeout;
  gint timeout_t;

  gchar foreground_s[24];
  GdkColor foreground;

  gchar background_s[24];
  GdkColor background;

  gchar *font_s;
  GdkFont *font;

  /* Widgets n stuff... */
  GtkWidget *area;
  GdkPixmap *pixmap;
  GdkImage *image;
  GdkGC *gc;

  GtkWidget *about_box;

  /*
   *
   * For the  "Properties" window ...
   *
   */
  GnomePropertyBox *prop_win;

  /* General */
  GtkObject *breadth_adj;
  GtkWidget *mode_radio_time, *mode_radio_date, *check_extended;

  GnomeColorPicker *foreground_sel;
  GnomeColorPicker *background_sel;
  GnomeFontPicker *font_sel;

} MerlinClockData;

#define MERLIN_CLOCK_TOGGLE_PERIOD 3

/*
 *
 * Configuration defaults
 *
 */

#define MERLIN_CLOCK_DATEMODE_TIME "time"
#define MERLIN_CLOCK_DATEMODE_DATE "date"

/* Global configuration parameters */
#define MERLIN_CLOCK_DEFAULT_DATEMODE        "time"
#define MERLIN_CLOCK_DEFAULT_BREADTH         "48"
#define MERLIN_CLOCK_DEFAULT_EXTENDED        "false"
#define MERLIN_CLOCK_DEFAULT_FOREGROUND      "#FFFF00"
#define MERLIN_CLOCK_DEFAULT_BACKGROUND      "#52080A"
#define MERLIN_CLOCK_DEFAULT_FONT            "fixed"

/*
 *
 * Prototypes
 *
 */
void about_cb (AppletWidget *widget, gpointer data);
void destroy_about(GtkWidget *w, gpointer data);

void merlin_clock_set_size(MerlinClockData *mc);
gint merlin_clock_update(gpointer data);
gint merlin_clock_orient_handler(GtkWidget *w, PanelOrientType o,
				   gpointer data);
gint merlin_clock_expose_handler(GtkWidget *widget, GdkEventExpose *expose,
				   gpointer data);
gint merlin_clock_configure_handler(GtkWidget *widget, GdkEventConfigure *event,
			       gpointer data);
GtkWidget *make_new_merlin_clock_applet (const gchar *goad_id);
void merlin_clock_create_gc(MerlinClockData *mc);
void merlin_clock_setup_colors(MerlinClockData *mc);
GtkWidget *applet_start_new_applet (const gchar *goad_id,
				     const char **params, int nparams);

#endif /* _MERLIN_CLOCK_H */
