/* ======================================================================
 * utils.hh
 * 
 * This file is part of MeshIO, the general and extensible 3D mesh I/O
 * library.
 * Copyright (c) 1999 Niklas Elmqvist. All rights reserved.
 *
 * File created 1999-06-02 by Niklas Elmqvist <d97elm@dtek.chalmers.se>.
 * 
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 *
 * ======================================================================
 */

#ifndef _UTILS_HH_
#define _UTILS_HH_

// -- System Includes
//#include <stdlib.h>
//#include <stdio.h>

// -- Defines and Macros
#define MAX(x, y)	((x) < (y) ? (y) : (x))
#define MIN(x, y)	((x) < (y) ? (x) : (y))

#ifndef PI
#define PI 			3.141592687	// The Magic Number
#endif
#define TRUE			1		// Duh
#define FALSE			0		// Duh, part II

#define MAX_STRING_LENGTH	1024		// String length maximum

// Byte swapping macros (only applicable on big-endian machines)
#ifdef BIGENDIAN
#define SWAP32(x)	( (((x) & 0xff000000) >> 24) + (((x) & 0x00ff0000) >> 8) + (((x) & 0x0000ff00) << 8) + (((x) & 0x000000ff) << 24) )
#define SWAP16(x)	( (((x) & 0xff00) >> 8) + (((x) & 0x00ff) << 8) )
#else
#define SWAP32(x)	(x)
#define SWAP16(x)	(x)
#endif

// -- Struct Definitions
typedef struct _ListNode {
    void *data;
    struct _ListNode *next;
} ListNode;

// -- Function prototypes

// Read a zero-terminated string from a file
void StringReader(FILE *f, char *buf, int len = MAX_STRING_LENGTH);

// Write a zero-terminated string to a file
void StringWriter(FILE *f, char *buf);

// Read data and swap them for little-endian/big-endian compatibility
bool ReadData(FILE *f, void *val, int nsize, int nelem = 1, bool swap = true);

// Write data and swap them for little-endian/big-endian compatibility
bool WriteData(FILE *f, void *val, int nsize, int nelem = 1, bool swap = true);

// Add a node to a linked list
ListNode *AddNode(ListNode *list, void *data);

// Delete a node from a linked list (if found)
ListNode *DelNode(ListNode *list, void *data);

// Reverse a linked list
ListNode *ReverseList(ListNode *list);

// Clear a linked list
void ClearList(ListNode *list);

#endif /* utils.hh */

